/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.ColumnHead;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttCommands;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttController;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.OnClickPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.OnSwipePanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineRows;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TrackControls;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.ViewList;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class Gantt
extends JPanel
implements GanttCommands {
    private static final boolean DEBUG = false;
    public static final int HEADER_HEIGHT = JBUI.scale((int)30);
    private static final JBDimension SLIDER_DIMENSION = JBUI.size((int)140, (int)16);
    GanttController myGanttController = new GanttController();
    private Chart myChart = new Chart(this);
    private ViewList myViewList = new ViewList(this.myChart);
    private ColumnHead myColumnHead = new ColumnHead(this.myChart);
    private TimeLineRows myRowGraphc = new TimeLineRows(this.myChart);
    private JScrollPane myScrollPane = new JBScrollPane((Component)this.myRowGraphc);
    TrackControls myTrackControls = new TrackControls(this.myChart);
    TitleBar myTitleBar;
    JTextField myDuration;
    private DecimalFormat myFormat = new DecimalFormat("####.00");
    private MotionSceneModel myMotionSceneModel;
    private JLabel myTitleLabel;

    public Gantt(GanttEventListener listener2) {
        super(new BorderLayout());
        this.myTitleBar = new TitleBar(this.myChart);
        this.add((Component)this.myTitleBar, "North");
        this.add((Component)this.myScrollPane, "Center");
        this.myScrollPane.setColumnHeaderView(this.myColumnHead);
        this.myScrollPane.setRowHeaderView(this.myViewList);
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", this.myTrackControls);
        this.myScrollPane.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        JViewport viewPort = this.myScrollPane.getViewport();
        viewPort.setScrollMode(1);
        viewPort.setScrollMode(2);
        viewPort.setScrollMode(0);
        this.myRowGraphc.getAutoscrolls();
        this.myChart.myContainerHeight = this.myScrollPane.getViewport().getHeight();
        this.myChart.myContainerWidth = this.myScrollPane.getViewport().getWidth();
        this.setBackground(Chart.ourSecondaryPanelBackground);
        this.setup();
        if (listener2 != null) {
            listener2.onInit(this);
        }
        this.myGanttController.setListener(listener2);
        this.myTrackControls.setGantt(this.myGanttController);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ((Gantt)Gantt.this).myChart.myContainerHeight = Gantt.this.myScrollPane.getViewport().getHeight();
                ((Gantt)Gantt.this).myChart.myContainerWidth = Gantt.this.myScrollPane.getViewport().getWidth();
                Gantt.this.myChart.update(ChartElement.Reason.RESIZE);
            }
        });
        MouseAdapter timeLineMouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Gantt.this.repaint();
            }

            private float clamp(float value2, float min, float max) {
                return Math.max(min, Math.min(value2, max));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int pos = e.getX();
                float timeCursorMs = (float)(pos - ((Gantt)Gantt.this).myChart.myChartLeftInset) / ((Gantt)Gantt.this).myChart.myPixelsPerMs;
                Gantt.this.myChart.setTimeCursorMs(this.clamp(timeCursorMs, 0.0f, ((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs));
                float percent = Gantt.this.myChart.getTimeCursorMs() / (float)((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs;
                Rectangle rec = Gantt.this.myRowGraphc.getVisibleRect();
                Gantt.this.myGanttController.framePosition(percent);
                int dx = 0;
                if (pos + 1 < rec.x) {
                    dx = pos - rec.x;
                }
                if (pos > rec.x + rec.width) {
                    dx = pos - (rec.x + rec.width);
                }
                if (dx != 0) {
                    rec.x += dx / 2;
                    Gantt.this.myRowGraphc.scrollRectToVisible(rec);
                }
                Gantt.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                float pos = (float)((int)(100.0f * Gantt.this.myChart.getTimeCursorMs() / Gantt.this.myChart.getAnimationTotalTimeMs())) / 100.0f;
                float timeCursorMs = pos * Gantt.this.myChart.getAnimationTotalTimeMs();
                Gantt.this.myChart.setTimeCursorMs(this.clamp(timeCursorMs, 0.0f, ((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs));
                float percent = Gantt.this.myChart.getTimeCursorMs() / (float)((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs;
                Gantt.this.myGanttController.framePosition(percent);
                Gantt.this.repaint();
            }
        };
        this.myColumnHead.addMouseMotionListener(timeLineMouse);
        this.myColumnHead.addMouseWheelListener(timeLineMouse);
        this.myColumnHead.addMouseListener(timeLineMouse);
        Dimension min = this.getMinimumSize();
        this.setMinimumSize(new Dimension(min.width, 2 * min.height));
    }

    void selectionChanged() {
        this.myGanttController.myListener.selectionEvent();
    }

    public void setZoom(float percent) {
        this.myChart.setZoom(percent);
    }

    public MotionSceneModel.KeyFrame getSelectedKey(String id) {
        return this.myChart.mySelectedKeyFrame;
    }

    public MotionSceneModel.ConstraintView getSelectedConstraintView(String id) {
        return this.myChart.mySelectedConstraint;
    }

    public void clearSelectedKey() {
        this.myChart.mySelectedKeyView = null;
        this.myChart.mySelectedKeyFrame = null;
        this.myChart.mySelectedKeyFrameTag = null;
        this.myChart.mySelectedConstraintTag = null;
    }

    public MotionSceneModel.TransitionTag getTransitionTag() {
        if (this.myChart.myModel == null) {
            return null;
        }
        return this.myChart.myModel.getTransitionTag(0);
    }

    public MotionSceneModel.OnSwipeTag getOnSwipeTag() {
        if (this.myChart.myModel == null) {
            return null;
        }
        return this.myChart.myModel.getOnSwipeTag();
    }

    public void handleSelectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        List views2;
        List<Object> list = views2 = this.myMotionSceneModel != null ? this.myMotionSceneModel.getViews() : Collections.emptyList();
        if (views2.isEmpty()) {
            return;
        }
        NlComponent motion = ((NlComponent)views2.get(0)).getParent();
        if (motion == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(selection.size());
        for (NlComponent selected : selection) {
            String id;
            if (selected.getParent() != motion || (id = selected.getId()) == null) continue;
            ids.add(id);
        }
        this.myViewList.handleSelection(ids);
    }

    @NotNull
    private JSlider createZoomSlider() {
        JSlider slider = new JSlider();
        slider.setPreferredSize((Dimension)SLIDER_DIMENSION);
        slider.setValue(0);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Gantt.this.setZoom(1.0f + (float)((JSlider)e.getSource()).getValue() / 25.0f);
            }
        });
        return slider;
    }

    public void setDurationMs(int time2) {
        this.myDuration.setText(Integer.toString(time2));
    }

    void updateLabel() {
        String s;
        switch (this.myChart.getMode()) {
            case START: {
                s = "Start Constraint " + this.myFormat.format(this.myChart.getTimeCursorMs()) + "ms";
                break;
            }
            case END: {
                s = "End Constraint " + this.myFormat.format(this.myChart.getTimeCursorMs()) + "ms";
                break;
            }
            default: {
                s = "Timeline " + this.myFormat.format(this.myChart.getTimeCursorMs()) + "ms";
            }
        }
        this.myTitleLabel.setText(s);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myRowGraphc == null) {
            return;
        }
        this.myRowGraphc.setBackground(bg);
        this.myViewList.setBackground(bg);
        this.myTrackControls.setBackground(bg);
        this.myScrollPane.setBackground(bg);
        this.myColumnHead.setBackground(bg);
    }

    public void setup() {
    }

    public Chart getChart() {
        return this.myChart;
    }

    public MotionSceneModel getMotionScene() {
        return this.myMotionSceneModel;
    }

    public void setMotionScene(MotionSceneModel motionScene) {
        this.myMotionSceneModel = motionScene;
        if (motionScene.myTransition != null && !motionScene.myTransition.isEmpty()) {
            this.myDuration.setText(Integer.toString(motionScene.myTransition.get((int)0).duration));
        }
        this.myChart.clear();
        for (String s : motionScene.getSceneViewsNames()) {
            this.myChart.addView(new ViewElement(s, motionScene.getSceneView(s)));
        }
        this.myChart.update(ChartElement.Reason.ADDVIEW);
        this.myChart.setMotionSceneModel(this.myMotionSceneModel);
        this.validate();
        this.repaint();
    }

    @Override
    public void setProgress(float percent) {
        this.myChart.setCursorPosition(percent);
    }

    @Override
    public void setMode(GanttCommands.Mode mode) {
        this.myChart.setMode(mode);
    }

    @Override
    public GanttCommands.Mode getMode() {
        return this.myChart.getMode();
    }

    @Override
    public void update() {
    }

    static interface ChartElement {
        public void update(Reason var1);

        public void repaint();

        public void invalidate();

        public static enum Reason {
            RESIZE,
            ADDVIEW,
            SELECTION_CHANGED,
            ZOOM,
            CONSTRUCTION,
            MODE_CHANGE,
            CURSOR_POSITION_CHANGED,
            GRAPH_SELECTED,
            OTHER;

        }
    }

    static class ViewElement {
        String myName;
        int myYStart;
        int myHeight;
        boolean myHasAttribute = false;
        boolean myHasCycle = false;
        boolean myHasPosition = false;
        int myHeightView = 0;
        int myHeightAttribute = 0;
        int myHeightCycle = 0;
        int myHeightPosition = 0;
        MotionSceneModel.MotionSceneView mKeyFrames;

        public ViewElement(String name, MotionSceneModel.MotionSceneView keyFrames) {
            this.myName = name;
            this.mKeyFrames = keyFrames;
        }

        public String toString() {
            return this.myName;
        }

        public Icon getIcon() {
            if (this.mKeyFrames == null) {
                return null;
            }
            return this.mKeyFrames.getIcon();
        }

        ViewElement(String name) {
        }
    }

    class TitleBar
    extends JPanel
    implements ChartElement {
        MotionSceneUI motionSceneUI;
        Chart myChart;

        TitleBar(Chart chart) {
            super(new BorderLayout());
            this.myChart = chart;
            chart.add(this);
            this.motionSceneUI = new MotionSceneUI(Gantt.this, chart);
            this.add((Component)this.motionSceneUI, "North");
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUI.scale((int)4)));
            Gantt.this.myTitleLabel = new JLabel("Motion");
            this.add((Component)Gantt.this.myTitleLabel, "West");
            JPanel right2 = new JPanel();
            Gantt.this.myDuration = this.motionSceneUI.mPropPanel.myDuration;
            ((PlainDocument)Gantt.this.myDuration.getDocument()).setDocumentFilter(new IntFilter());
            Gantt.this.myDuration.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JTextField c = (JTextField)e.getSource();
                    ActionListener[] listeners = c.getActionListeners();
                    ActionEvent event = new ActionEvent(c, 1001, null);
                    for (int i2 = 0; i2 < listeners.length; ++i2) {
                        listeners[i2].actionPerformed(event);
                    }
                }
            });
            Gantt.this.myDuration.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Gantt.this.myGanttController.myListener != null) {
                        int duration = Integer.parseInt(Gantt.this.myDuration.getText());
                        Gantt.this.myGanttController.myListener.transitionDuration(duration);
                        TitleBar.this.myChart.setAnimationTotalTimeMs(duration);
                    }
                }
            });
            Gantt.this.myDuration.setAlignmentX(0.0f);
            right2.add(new JLabel(StudioIcons.LayoutEditor.Motion.MIN_SCALE));
            right2.add(Gantt.this.createZoomSlider());
            right2.add(new JLabel(StudioIcons.LayoutEditor.Motion.MAX_SCALE));
            this.add((Component)right2, "East");
        }

        @Override
        public void update(ChartElement.Reason reason) {
            MotionSceneModel.OnSwipeTag onSwipeTag = null;
            ArrayList<MotionSceneModel.OnClickTag> onClickTags = null;
            String[] transitionNames = null;
            if (this.myChart != null && this.myChart.myModel != null) {
                onSwipeTag = this.myChart.myModel.getOnSwipeTag();
                onClickTags = this.myChart.myModel.getOnClickTags();
                transitionNames = this.myChart.myModel.getTransitionsNames();
            }
            if (this.motionSceneUI.mySwipePanel == null) {
                if (onSwipeTag == null) {
                    return;
                }
                this.motionSceneUI.addOnSwipePanel();
                this.motionSceneUI.mySwipePanel.setOnSwipeTag(onSwipeTag);
            } else {
                if (onSwipeTag == null) {
                    this.motionSceneUI.myPropTabb.remove((Component)this.motionSceneUI.mySwipePanel);
                    this.motionSceneUI.mySwipePanel = null;
                } else {
                    this.motionSceneUI.mySwipePanel.setOnSwipeTag(onSwipeTag);
                }
                this.motionSceneUI.updateOnClicks(onClickTags);
            }
            if (transitionNames != null) {
                this.motionSceneUI.rebuildTransitionName(transitionNames);
            }
        }
    }

    static class MotionSceneUI
    extends JPanel {
        PropPanel mPropPanel;
        JBTabbedPane myPropTabb;
        OnPanelCreate myCreate;
        OnSwipePanel mySwipePanel;
        OnClickPanel[] onClickPanel = new OnClickPanel[0];
        ComboBox<String> myTransition;
        final Dimension mDimensions;
        Chart myChart;
        Gantt myGantt;
        boolean mRebuildingUI = false;

        MotionSceneUI(Gantt gantt, Chart chart) {
            this.setLayout(new BorderLayout());
            this.myGantt = gantt;
            this.myChart = chart;
            JPanel topControlls = new JPanel(new BorderLayout());
            JPanel transitions = new JPanel(new BorderLayout());
            topControlls.add(transitions);
            JPanel transitionList = new JPanel();
            transitions.add((Component)transitionList, "West");
            JLabel label = new JLabel("Transition");
            transitionList.add(label);
            this.myTransition = new ComboBox((Object[])new String[]{"(start - end)", "new..."});
            transitionList.add((Component)this.myTransition);
            this.myTransition.addActionListener(l -> this.selectTransition());
            this.myPropTabb = new JBTabbedPane();
            this.mPropPanel = new PropPanel();
            this.mDimensions = this.mPropPanel.getPreferredSize();
            this.myPropTabb.add((Component)this.mPropPanel, (Object)"Properties");
            this.myCreate = new OnPanelCreate(this);
            this.myPropTabb.add((Component)this.myCreate, (Object)"+");
            this.myPropTabb.addChangeListener(c -> this.plusHit(c));
            this.add((Component)topControlls, "North");
            this.add((Component)this.myPropTabb, "Center");
        }

        private void selectTransition() {
            if (this.mRebuildingUI) {
                return;
            }
            int items2 = this.myTransition.getItemCount();
            int selectedIndex = this.myTransition.getSelectedIndex();
            if (selectedIndex == items2 - 1) {
                this.myTransition.insertItemAt((Object)" - ", items2 - 1);
                this.myTransition.setSelectedIndex(items2 - 1);
            } else {
                this.myChart.myModel.setCurrentTransition(selectedIndex);
                this.myChart.update(ChartElement.Reason.SELECTION_CHANGED);
            }
            this.myGantt.setMotionScene(this.myChart.myModel);
            this.myChart.update(ChartElement.Reason.ADDVIEW);
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
        }

        void addOnClickPanel() {
            MotionSceneModel.OnClickTag onClickTag = this.myGantt.myMotionSceneModel.createOnClick();
            OnClickPanel clickPanel = new OnClickPanel(this.mDimensions);
            int index = this.myPropTabb.indexOfComponent((Component)this.myCreate);
            this.myPropTabb.insertTab("onClick", null, (Component)clickPanel, "Support swiping", index);
            this.myPropTabb.setSelectedIndex(index);
            clickPanel.setOnClick(onClickTag);
        }

        private void addOnSwipePanel() {
            MotionSceneModel.OnSwipeTag onSwipeTag = this.myGantt.myMotionSceneModel.createOnSwipe();
            this.mySwipePanel = new OnSwipePanel(this.mDimensions);
            int index = this.myPropTabb.indexOfComponent((Component)this.myCreate);
            this.myPropTabb.insertTab("onSwipe", null, (Component)this.mySwipePanel, "Support swiping", index);
            this.myPropTabb.setSelectedIndex(index);
            this.mySwipePanel.setOnSwipeTag(onSwipeTag);
        }

        private void plusHit(ChangeEvent c) {
        }

        public void updateOnClicks(ArrayList<MotionSceneModel.OnClickTag> onClickTags) {
            if (onClickTags == null) {
                for (OnClickPanel ui : this.onClickPanel) {
                    this.myPropTabb.remove((Component)ui);
                }
                return;
            }
            if (this.onClickPanel.length != onClickTags.size()) {
                for (OnClickPanel ui : this.onClickPanel) {
                    this.myPropTabb.remove((Component)ui);
                }
                int oldLen = this.onClickPanel.length;
                this.onClickPanel = Arrays.copyOf(this.onClickPanel, onClickTags.size());
                for (int i2 = oldLen; i2 < this.onClickPanel.length; ++i2) {
                    this.onClickPanel[i2] = new OnClickPanel(this.mDimensions);
                }
                int index = this.myPropTabb.indexOfComponent((Component)this.myCreate);
                for (int i3 = 0; i3 < this.onClickPanel.length; ++i3) {
                    this.myPropTabb.insertTab("onClick" + (i3 + 1), null, (Component)this.onClickPanel[i3], "Support onClick", index + i3);
                }
            }
            for (int i4 = 0; i4 < this.onClickPanel.length; ++i4) {
                this.onClickPanel[i4].setOnClick(onClickTags.get(i4));
            }
        }

        public void rebuildTransitionName(String[] names) {
            this.mRebuildingUI = true;
            String current = (String)this.myTransition.getSelectedItem();
            int show = 0;
            this.myTransition.removeAllItems();
            for (int i2 = 0; i2 < names.length; ++i2) {
                String name = names[i2];
                if (name.equals(current)) {
                    show = i2;
                }
                this.myTransition.insertItemAt((Object)name, i2);
            }
            this.myTransition.insertItemAt((Object)"New...", names.length);
            this.myTransition.setSelectedIndex(show);
            this.mRebuildingUI = false;
            this.updateTransitionProperties();
        }

        static String trimId(String fullId) {
            if (fullId == null) {
                return null;
            }
            int slashPos = fullId.indexOf(47);
            if (slashPos == -1) {
                return fullId;
            }
            return fullId.substring(fullId.indexOf(47) + 1);
        }

        private void updateTransitionProperties() {
            String end = MotionSceneUI.trimId(this.myChart.myModel.getEndId());
            String start = MotionSceneUI.trimId(this.myChart.myModel.getStartId());
            int endPos = 0;
            int startPos = 0;
            String[] csets = this.myChart.myModel.getKnownConstraintSetID();
            this.mPropPanel.myEndConstraint.removeAllItems();
            this.mPropPanel.myStartConstraint.removeAllItems();
            for (int i2 = 0; i2 < csets.length; ++i2) {
                String cset = csets[i2];
                String setIdName = MotionSceneUI.trimId(cset);
                this.mPropPanel.myEndConstraint.addItem((Object)cset);
                this.mPropPanel.myStartConstraint.addItem((Object)cset);
                if (end != null && end.equals(setIdName)) {
                    endPos = i2;
                }
                if (start == null || !start.equals(setIdName)) continue;
                startPos = i2;
            }
            this.mPropPanel.myEndConstraint.addItem((Object)"New...");
            this.mPropPanel.myStartConstraint.addItem((Object)"New...");
            if (end != null) {
                this.mPropPanel.myEndConstraint.setSelectedIndex(endPos);
            }
            if (start != null) {
                this.mPropPanel.myStartConstraint.setSelectedIndex(startPos);
            }
        }

        static class PropPanel
        extends JPanel {
            JTextField myDuration;
            ComboBox<String> myStartConstraint;
            ComboBox<String> myEndConstraint;
            JTextField myStaggered;

            PropPanel() {
                super(new GridBagLayout());
                this.setBackground(Chart.ourSecondaryPanelBackground);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weighty = 1.0;
                gbc.anchor = 17;
                gbc.insets = new Insets(10, 10, 0, 0);
                JLabel label = new JLabel("Start", TimeLineIcons.START_CONSTRAINT, 11);
                this.add((Component)label, gbc);
                gbc.gridx = 1;
                gbc.weightx = 1.0;
                this.myStartConstraint = new ComboBox((Object[])new String[]{"@+id/start", "new..."});
                this.add((Component)this.myStartConstraint, gbc);
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 0.0;
                label = new JLabel("End", TimeLineIcons.END_CONSTRAINT, 11);
                this.add((Component)label, gbc);
                gbc.gridx = 1;
                gbc.weightx = 1.0;
                this.myEndConstraint = new ComboBox((Object[])new String[]{"@+id/start", "new..."});
                this.add((Component)this.myEndConstraint, gbc);
                label = new JLabel("Duration(ms)");
                this.myDuration = new JTextField();
                this.myDuration.setText("XXXXX");
                this.myDuration.setPreferredSize(this.myDuration.getPreferredSize());
                this.myDuration.setText("600");
                gbc.gridx = 3;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                this.add((Component)label, gbc);
                gbc.gridx = 4;
                gbc.weightx = 1.0;
                this.add((Component)this.myDuration, gbc);
                gbc.gridx = 3;
                gbc.gridy = 1;
                gbc.weightx = 0.0;
                label = new JLabel("Staggered");
                this.add((Component)label, gbc);
                gbc.gridx = 4;
                gbc.weightx = 1.0;
                this.myStaggered = new JTextField("0");
                this.add((Component)this.myStaggered, gbc);
            }
        }

        static class OnPanelCreate
        extends JPanel {
            MotionSceneUI myMotionSceneUI;

            OnPanelCreate(MotionSceneUI ui) {
                this.myMotionSceneUI = ui;
                JButton button0nSwipe = new JButton("0nSwipe");
                this.add(button0nSwipe);
                JButton button0nClick = new JButton("0nClick");
                this.add(button0nClick);
                button0nSwipe.addActionListener(e -> this.create0nSwipe(e));
                button0nClick.addActionListener(e -> this.create0nClick(e));
            }

            private void create0nClick(ActionEvent e) {
                this.myMotionSceneUI.addOnClickPanel();
            }

            private void create0nSwipe(ActionEvent e) {
                this.myMotionSceneUI.addOnSwipePanel();
            }
        }
    }

    static class IntFilter
    extends DocumentFilter {
        IntFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, string);
            if (this.test(sb.toString())) {
                super.insertString(fb, offset, string, attr);
            }
        }

        private boolean test(String text) {
            try {
                Integer.parseInt(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, text);
            if (this.test(sb.toString())) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.delete(offset, offset + length);
            if (this.test(sb.toString())) {
                super.remove(fb, offset, length);
            }
        }
    }
}

