/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.utils.CurveFit;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.utils.Oscillator;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Graph
extends JPanel {
    private final Chart myChart;
    int myInsTop = 1;
    int myInsLeft = 30;
    int myInsBottom = 30;
    int myInsRight = 30;
    float[][] myXPoints = new float[0][];
    float[][] myYPoints = new float[0][];
    Color[] myPointColor = new Color[0];
    float myActualMinx;
    float myActualMiny;
    float myActualMaxx;
    float myActualMaxy;
    float myLastMinx;
    float myLastMiny;
    float myLastMaxx;
    float myLastMaxy;
    float myMinx;
    float myMiny;
    float myMaxx;
    float myMaxy;
    float myTickX;
    float myTickY;
    int myTextGap = 2;
    int myFCount = 0;
    Color myBackgroundColor = Chart.ourPrimaryPanelBackground;
    Color myBackgroundColor2 = Chart.ourPrimaryPanelBackground;
    Color myDrawing = new Color(0xAAAAAA);
    Color myGridColor = new Color(0x999999);
    public static final byte LINE_STYLE = 0;
    public static final byte TICK_STYLE = 1;
    public static final byte CIRCLE_STYLE = 2;
    Stroke myStroke = new BasicStroke(1.0f);
    Vector<DrawItem> myDrawItems = new Vector();
    private int[] myStyle = new int[0];
    DrawItem mAxis = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(Graph.this.myDrawing);
            g.drawLine(((Graph)Graph.this).myChart.myChartLeftInset, Graph.this.myInsTop, Graph.this.myInsLeft, h - Graph.this.myInsBottom);
            g.drawLine(Graph.this.myInsLeft, h - Graph.this.myInsBottom, w - Graph.this.myInsRight, h - Graph.this.myInsBottom);
        }
    };
    DrawItem mGrid = new DrawItem(){
        DecimalFormat df = new DecimalFormat("###.#");

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(Graph.this.myGridColor);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int draw_width = w - Graph.this.myInsLeft - Graph.this.myInsRight;
            float e = 1.0E-4f * (Graph.this.myMaxx - Graph.this.myMinx);
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getAscent();
            for (float i2 = Graph.this.myMinx; i2 <= Graph.this.myMaxx + e; i2 += Graph.this.myTickX) {
                int ix = (int)((float)draw_width * (i2 - Graph.this.myMinx) / (Graph.this.myMaxx - Graph.this.myMinx) + (float)Graph.this.myInsLeft);
                g.drawLine(ix, Graph.this.myInsTop, ix, h - Graph.this.myInsBottom);
                String str = this.df.format(i2);
                int sw = fm.stringWidth(str) / 2;
                g.drawString(str, ix - sw, h - Graph.this.myInsBottom + ascent + Graph.this.myTextGap);
            }
            int draw_height = h - Graph.this.myInsTop - Graph.this.myInsLeft;
            e = 1.0E-4f * (Graph.this.myMaxy - Graph.this.myMiny);
            int hightoff = -fm.getHeight() / 2 + ascent;
            for (float i3 = Graph.this.myMiny; i3 <= Graph.this.myMaxy + e; i3 += Graph.this.myTickY) {
                int iy = (int)((float)draw_height * (1.0f - (i3 - Graph.this.myMiny) / (Graph.this.myMaxy - Graph.this.myMiny)) + (float)Graph.this.myInsTop);
                g.drawLine(Graph.this.myInsLeft, iy, w - Graph.this.myInsRight, iy);
                String str = this.df.format(i3);
                int sw = fm.stringWidth(str);
                g.drawString(str, Graph.this.myInsLeft - sw - Graph.this.myTextGap, iy + hightoff);
            }
        }
    };
    DrawItem mAxisVLabel = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
        }
    };
    DrawItem mAxisHLabel = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
        }
    };
    DrawItem mDrawGraph = new DrawItem(){
        int[] xp = new int[0];
        int[] yp = new int[0];

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(Graph.this.myDrawing);
            if (Graph.this.myXPoints.length == 0) {
                return;
            }
            if (this.xp.length != Graph.this.myXPoints[0].length) {
                this.xp = new int[Graph.this.myXPoints[0].length];
                this.yp = new int[Graph.this.myXPoints[0].length];
            }
            int draw_width = w - Graph.this.myInsLeft - Graph.this.myInsRight;
            int draw_height = h - Graph.this.myInsTop - Graph.this.myInsLeft;
            for (int k = 0; k < Graph.this.myXPoints.length; ++k) {
                int pointY;
                if (Graph.this.myXPoints[k] == null || Graph.this.myYPoints[k] == null) continue;
                for (int i2 = 0; i2 < Graph.this.myXPoints[k].length; ++i2) {
                    float x = (float)draw_width * (Graph.this.myXPoints[k][i2] - Graph.this.myMinx) / (Graph.this.myMaxx - Graph.this.myMinx) + (float)Graph.this.myInsLeft;
                    float y = (float)draw_height * (1.0f - (Graph.this.myYPoints[k][i2] - Graph.this.myMiny) / (Graph.this.myMaxy - Graph.this.myMiny)) + (float)Graph.this.myInsTop;
                    this.xp[i2] = (int)((double)x + 0.5);
                    this.yp[i2] = (int)((double)y + 0.5);
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Graph.this.myPointColor[k]);
                g.setStroke(Graph.this.myStroke);
                if (Graph.this.myStyle[k] == 0) {
                    g.drawPolyline(this.xp, this.yp, Graph.this.myXPoints[k].length);
                    continue;
                }
                if (Graph.this.myStyle[k] == 1) {
                    int TICK_SIZE = 2;
                    for (int i3 = 0; i3 < Graph.this.myXPoints[k].length; ++i3) {
                        int pointX = this.xp[i3];
                        pointY = this.yp[i3];
                        g.fillRoundRect(pointX - 2, pointY - 8, 4, 16, 4, 16);
                    }
                    continue;
                }
                int CIRCLE_SIZE = 16;
                for (int i4 = 0; i4 < Graph.this.myXPoints[k].length; ++i4) {
                    int pointX = this.xp[i4];
                    pointY = this.yp[i4];
                    g.fillRoundRect(pointX - 16, pointY - 16, 32, 32, 32, 32);
                }
            }
        }
    };

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.myBackgroundColor = color;
        this.myBackgroundColor2 = color;
    }

    void waveGen(int base) {
        float fb = (float)base / 100.0f;
        float sc = (float)(base % 10000) / 10000.0f + 1.0f;
        float[] xPoints = new float[1024];
        float[] yPoints = new float[xPoints.length];
        for (int i2 = 0; i2 < xPoints.length; ++i2) {
            float p;
            xPoints[i2] = p = 100.0f * (float)i2 / (float)(xPoints.length - 1);
            yPoints[i2] = p / 100.0f;
        }
        this.addGraph(0, xPoints, yPoints, new Color(-12746271), (byte)0);
    }

    public Graph(Chart chart) {
        this.myChart = chart;
        this.myDrawItems.addElement(this.mGrid);
        this.myDrawItems.addElement(this.mAxis);
        this.myDrawItems.addElement(this.mAxisVLabel);
        this.myDrawItems.addElement(this.mAxisHLabel);
        this.myDrawItems.addElement(this.mDrawGraph);
        this.waveGen(0);
        this.calcRange();
    }

    public void addGraph(int n, double[] x, double[] y, Color c, byte style) {
        float[] xf = new float[x.length];
        float[] yf = new float[y.length];
        for (int i2 = 0; i2 < yf.length; ++i2) {
            xf[i2] = (float)x[i2];
            yf[i2] = (float)y[i2];
        }
        this.addGraph(n, xf, yf, c, style);
        this.calcRange();
        this.repaint();
    }

    public void addGraph(int n, float[] x, float[] y, Color c, byte style) {
        if (this.myXPoints.length <= n) {
            float[][] yp = new float[n + 1][];
            float[][] xp = new float[n + 1][];
            Color[] ncol = new Color[n + 1];
            int[] m = new int[n + 1];
            for (int i2 = 0; i2 < this.myXPoints.length; ++i2) {
                xp[i2] = this.myXPoints[i2];
                yp[i2] = this.myYPoints[i2];
                ncol[i2] = this.myPointColor[i2];
                m[i2] = this.myStyle[i2];
            }
            this.myPointColor = ncol;
            this.myXPoints = xp;
            this.myYPoints = yp;
            this.myStyle = m;
        }
        this.myXPoints[n] = x;
        this.myYPoints[n] = y;
        this.myPointColor[n] = c;
        this.myStyle[n] = style;
        this.calcRange();
        this.repaint();
    }

    public void calcRange() {
        this.myActualMinx = Float.MAX_VALUE;
        this.myActualMiny = Float.MAX_VALUE;
        this.myActualMaxx = -3.4028235E38f;
        this.myActualMaxy = -3.4028235E38f;
        for (int g = 0; g < this.myXPoints.length; ++g) {
            if (this.myXPoints[g] == null | this.myYPoints[g] == null) continue;
            for (int i2 = 0; i2 < this.myXPoints[g].length; ++i2) {
                float x = this.myXPoints[g][i2];
                float y = this.myYPoints[g][i2];
                this.myActualMinx = Math.min(this.myActualMinx, x);
                this.myActualMiny = Math.min(this.myActualMiny, y);
                this.myActualMaxx = Math.max(this.myActualMaxx, x);
                this.myActualMaxy = Math.max(this.myActualMaxy, y);
            }
        }
    }

    void calcRangeTicks() {
        double dx = this.myActualMaxx - this.myActualMinx;
        double dy = this.myActualMaxy - this.myActualMiny;
        int sw = this.getWidth();
        int sh = this.getHeight();
        double border = 1.09345;
        if ((double)(Math.abs(this.myLastMinx - this.myActualMinx) + Math.abs(this.myLastMaxx - this.myActualMaxx)) > 0.1 * (double)(this.myActualMaxx - this.myActualMinx)) {
            this.myTickX = (float)Graph.calcTick(sw, dx);
            dx = (double)this.myTickX * Math.ceil(border * dx / (double)this.myTickX);
            double tx = ((double)(this.myActualMinx + this.myActualMaxx) - dx) / 2.0;
            tx = (double)this.myTickX * Math.floor(tx / (double)this.myTickX);
            this.myMinx = this.myActualMinx;
            tx = ((double)(this.myActualMinx + this.myActualMaxx) + dx) / 2.0;
            tx = (double)this.myTickX * Math.ceil(tx / (double)this.myTickX);
            this.myMaxx = this.myActualMaxx;
            this.myLastMinx = this.myActualMinx;
            this.myLastMaxx = this.myActualMaxx;
        }
        if ((double)(Math.abs(this.myLastMiny - this.myActualMiny) + Math.abs(this.myLastMaxy - this.myActualMaxy)) > 0.1 * (double)(this.myActualMaxy - this.myActualMiny)) {
            this.myTickY = (float)Graph.calcTick(sh, dy);
            dy = (double)this.myTickY * Math.ceil(border * dy / (double)this.myTickY);
            double ty = ((double)(this.myActualMiny + this.myActualMaxy) - dy) / 2.0;
            ty = (double)this.myTickY * Math.floor(ty / (double)this.myTickY);
            this.myMiny = (float)ty;
            ty = ((double)(this.myActualMiny + this.myActualMaxy) + dy) / 2.0;
            ty = (double)this.myTickY * Math.ceil(ty / (double)this.myTickY);
            this.myMaxy = (float)ty;
            this.myLastMiny = this.myActualMiny;
            this.myLastMaxy = this.myActualMaxy;
        }
    }

    public void draw(Chart.GraphElements graph) {
        switch (graph.myType) {
            case CYCLES: {
                ArrayList<MotionSceneModel.KeyCycle> cycleList = new ArrayList<MotionSceneModel.KeyCycle>();
                for (Gantt.ViewElement element : this.myChart.myViewElements) {
                    if (!element.myName.equals(graph.myViewId)) continue;
                    for (MotionSceneModel.KeyCycle keyCycle : element.mKeyFrames.myKeyCycles) {
                        if (!keyCycle.myAttributes.containsKey(graph.myElement)) continue;
                        cycleList.add(keyCycle);
                    }
                }
                this.graphKeyCycle(cycleList, graph.myElement);
                break;
            }
            case ATTRIBUTES: {
                ArrayList<MotionSceneModel.KeyAttributes> attrList = new ArrayList<MotionSceneModel.KeyAttributes>();
                for (Gantt.ViewElement element : this.myChart.myViewElements) {
                    if (!element.myName.equals(graph.myViewId)) continue;
                    for (MotionSceneModel.KeyAttributes keyAttr : element.mKeyFrames.myKeyAttributes) {
                        if (!keyAttr.myAttributes.containsKey(graph.myElement)) continue;
                        attrList.add(keyAttr);
                    }
                }
                this.graphKeyAttributes(attrList, graph.myElement);
            }
        }
    }

    private void graphKeyAttributes(ArrayList<MotionSceneModel.KeyAttributes> list, String element) {
        if (list.isEmpty()) {
            return;
        }
        list.sort(new Comparator<MotionSceneModel.KeyAttributes>(){

            @Override
            public int compare(MotionSceneModel.KeyAttributes k1, MotionSceneModel.KeyAttributes k2) {
                return Integer.compare(k1.framePosition, k2.framePosition);
            }
        });
        int first = 0;
        int last = 0;
        if (list.get((int)0).framePosition != 0) {
            ++first;
        }
        if (list.get((int)(list.size() - 1)).framePosition != 100) {
            ++last;
        }
        double[] x = new double[list.size() + first + last];
        double[] y = new double[list.size() + first + last];
        int i2 = first;
        for (MotionSceneModel.KeyAttributes attributes : list) {
            x[i2] = attributes.framePosition;
            y[i2] = attributes.getFloat(element);
            ++i2;
        }
        if (first == 1) {
            x[0] = x[1];
            y[0] = y[1];
        }
        if (last == 1) {
            int n = x.length - 1;
            x[n] = x[n - 1];
            y[n] = y[n - 1];
        }
        this.addGraph(0, x, y, Chart.myUnSelectedLineColor, (byte)1);
        double[][] curves = new double[][]{y};
        CurveFit fit = CurveFit.get(y.length > 2 ? 0 : 1, x, curves);
        int CURVE_POINTS = 200;
        double[] xline = new double[CURVE_POINTS];
        double[] yline = new double[CURVE_POINTS];
        for (int j = 0; j < xline.length; ++j) {
            double xp;
            xline[j] = xp = (double)(100 * j) / (double)(xline.length - 1);
            yline[j] = fit.getPos(xp, 0);
        }
        this.addGraph(0, xline, yline, Chart.myUnSelectedLineColor, (byte)0);
    }

    private void graphKeyCycle(ArrayList<MotionSceneModel.KeyCycle> list, String element) {
        if (list.isEmpty()) {
            return;
        }
        list.sort(new Comparator<MotionSceneModel.KeyCycle>(){

            @Override
            public int compare(MotionSceneModel.KeyCycle k1, MotionSceneModel.KeyCycle k2) {
                return Integer.compare(k1.framePosition, k2.framePosition);
            }
        });
        Oscillator oscillator = new Oscillator();
        float waveOffset = Float.NaN;
        float wavePeriod = Float.NaN;
        for (MotionSceneModel.KeyCycle keyCycle : list) {
        }
    }

    public static double calcTick(int scr, double range) {
        int aprox_x_ticks = scr / 100;
        int type = 1;
        double best = Math.log10(range / (double)aprox_x_ticks);
        double n = Math.log10(range / (double)(aprox_x_ticks * 2));
        if (Graph.frac(n) < Graph.frac(best)) {
            best = n;
            type = 2;
        }
        if (Graph.frac(n = Math.log10(range / (double)(aprox_x_ticks * 5))) < Graph.frac(best)) {
            best = n;
            type = 5;
        }
        return (double)type * Math.pow(10.0, Math.floor(best));
    }

    static double frac(double x) {
        return x - Math.floor(x);
    }

    private void paintBorder(Graphics g, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(Chart.ourBorderLight);
        g.fillRect(0, 0, this.myChart.myChartLeftInset, height);
        g.fillRect(width - this.myChart.myChartRightInset, 0, this.myChart.myChartRightInset, height);
        g.fillRect(width - this.myChart.myChartRightInset, 0, this.myChart.myChartRightInset, height);
        g.fillRect(this.myChart.myChartLeftInset, height - this.myChart.myBottomInsert, width - this.myChart.myChartLeftInset - this.myChart.myChartRightInset, this.myChart.myBottomInsert);
    }

    @Override
    protected void paintComponent(Graphics g) {
        ++this.myFCount;
        this.calcRangeTicks();
        int w = this.getWidth();
        int h = this.getHeight();
        this.paintBorder(g, w, h);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.getBackground(), 0.0f, (float)(h * 2) / 3.0f, this.myBackgroundColor2, true);
        g.setColor(this.myDrawing);
        for (DrawItem drawItem : this.myDrawItems) {
            drawItem.paint(g2d, w, h);
        }
    }

    public static Graph create() {
        JFrame f = new JFrame("enclosing_type");
        f.setBounds(new Rectangle(623, 660));
        f.setDefaultCloseOperation(3);
        JPanel base = new JPanel(new BorderLayout());
        JPanel ctl = new JPanel();
        base.add((Component)ctl, "South");
        JButton button2 = new JButton("Save...");
        Graph p = new Graph(new Chart(null));
        button2.addActionListener(e -> Graph.save(e, p));
        ctl.add(button2);
        base.add(p);
        f.setContentPane(base);
        f.validate();
        f.setVisible(true);
        return p;
    }

    public static void save(ActionEvent e, Graph graph) {
        int w = graph.getWidth();
        int h = graph.getHeight();
        BufferedImage img = new BufferedImage(w, h, 1);
        graph.paint(img.createGraphics());
        JFileChooser chooser2 = new JFileChooser(new File(System.getProperty("user.home")));
        int c = chooser2.showSaveDialog(graph);
        if (c == 1) {
            return;
        }
        try {
            File f = chooser2.getSelectedFile();
            ImageIO.write((RenderedImage)img, "png", f);
            Desktop.getDesktop().open(f.getParentFile());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static interface DrawItem {
        public void paint(Graphics2D var1, int var2, int var3);
    }
}

