/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.motion.AttrName;
import com.android.tools.idea.uibuilder.handlers.motion.MotionSceneString;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MotionSceneModel {
    public static final boolean BROKEN = true;
    public static final boolean DEBUG = false;
    ArrayList<ConstraintSet> myConstraintSets;
    ArrayList<TransitionTag> myTransition;
    TransitionTag myCurrentTransition;
    private VirtualFile myVirtualFile;
    private Project myProject;
    private NlModel myNlModel;
    private String myName;
    private String[] myTransitionNames = null;
    private List<NlComponent> myViews;

    public String getName() {
        return this.myName;
    }

    public Project getProject() {
        return this.myProject;
    }

    public TransitionTag getTransitionTag(int i2) {
        return this.myTransition.get(i2);
    }

    public OnSwipeTag getOnSwipeTag() {
        return this.myCurrentTransition == null ? null : this.myCurrentTransition.myOnSwipeTag;
    }

    public ArrayList<OnClickTag> getOnClickTags() {
        return this.myCurrentTransition == null ? null : this.myCurrentTransition.myOnClickTags;
    }

    public List<NlComponent> getViews() {
        return this.myViews;
    }

    private XmlFile motionSceneFile() {
        return (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
    }

    public String getStartId() {
        if (this.myCurrentTransition == null) {
            return null;
        }
        return this.myCurrentTransition.myConstraintSetStart;
    }

    public String[] getKnownConstraintSetID() {
        ArrayList<String> str = new ArrayList<String>();
        for (ConstraintSet set : this.myConstraintSets) {
            str.add(set.mId);
        }
        return str.toArray(new String[0]);
    }

    public static String stripID(String id) {
        int index = id.indexOf(47);
        if (index < 0) {
            return id;
        }
        return id.substring(index + 1);
    }

    public String getEndId() {
        if (this.myCurrentTransition == null) {
            return null;
        }
        return this.myCurrentTransition.myConstraintSetEnd;
    }

    public ConstraintSet getEndConstraintSet() {
        return this.myCurrentTransition.getConstraintSetEnd();
    }

    public ConstraintSet getStartConstraintSet() {
        return this.myCurrentTransition.getConstraintSetStart();
    }

    public ArrayList<TransitionTag> getTransitions() {
        return this.myTransition;
    }

    public String[] getConstraintSetNames() {
        String[] names = new String[this.myConstraintSets.size()];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = this.myConstraintSets.get((int)i2).mId;
        }
        return names;
    }

    public void setCurrentTransition(int index) {
        this.myCurrentTransition = this.myTransition.get(index);
    }

    public String[] getTransitionsNames() {
        if (this.myTransitionNames != null) {
            return this.myTransitionNames;
        }
        String[] ret = new String[this.myTransition.size()];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            TransitionTag transition = this.myTransition.get(i2);
            String start = MotionSceneModel.stripID(transition.myConstraintSetStart);
            String end = MotionSceneModel.stripID(transition.myConstraintSetEnd);
            ret[i2] = start + " - " + end;
        }
        this.myTransitionNames = ret;
        return ret;
    }

    public String[] getSceneViewsNames() {
        String[] ret = new String[this.myViews.size()];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = this.myViews.get(i2).getId();
        }
        return ret;
    }

    public MotionSceneView getSceneView(String s) {
        if (this.myCurrentTransition == null) {
            return null;
        }
        return this.myCurrentTransition.mViewsMap.get(s);
    }

    public MotionSceneView getMotionSceneView(@NotNull String viewId) {
        return this.myCurrentTransition.mViewsMap.get(viewId);
    }

    @Nullable
    private XmlTag getKeyFrameForTransition(XmlFile xmlFile, TransitionTag transitionTag) {
        String keyNodeName;
        XmlTag tag;
        int i2;
        XmlTag transition = null;
        XmlTag keyFrame = null;
        XmlTag[] tags2 = xmlFile.getRootTag().getSubTags();
        for (i2 = 0; i2 < tags2.length; ++i2) {
            tag = tags2[i2];
            keyNodeName = tag.getName();
            if (!keyNodeName.equals("Transition")) continue;
            transition = tag;
            break;
        }
        if (transition == null) {
            return null;
        }
        tags2 = transition.getSubTags();
        for (i2 = 0; i2 < tags2.length; ++i2) {
            tag = tags2[i2];
            keyNodeName = tag.getName();
            if (!keyNodeName.equals("KeyFrameSet")) continue;
            keyFrame = tag;
            break;
        }
        if (keyFrame == null) {
            keyFrame = transition.createChildTag("KeyFrameSet", null, null, false);
            keyFrame = transition.addSubTag(keyFrame, false);
        }
        return keyFrame;
    }

    private static String trimId(String name) {
        return name.substring(name.indexOf(47) + 1);
    }

    @Nullable
    private XmlTag getConstraintSetTag(XmlFile xmlFile, String name) {
        XmlTag constraintSet = null;
        XmlTag[] tags2 = xmlFile.getRootTag().getSubTags();
        for (int i2 = 0; i2 < tags2.length; ++i2) {
            String constraintSetId;
            XmlTag tag = tags2[i2];
            String keyNodeName = tag.getName();
            if (!keyNodeName.equals("ConstraintSet") || !name.equals(MotionSceneModel.trimId(constraintSetId = tag.getAttribute("android:id").getValue()))) continue;
            constraintSet = tag;
            break;
        }
        return constraintSet;
    }

    public void createConstraint(final String type, final boolean startSet) {
        final XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
        final NlComponent component = this.myNlModel.find(type);
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)new Runnable(){

                @Override
                public void run() {
                    String name = startSet ? MotionSceneModel.this.myCurrentTransition.myConstraintSetStart : MotionSceneModel.this.myCurrentTransition.myConstraintSetEnd;
                    XmlTag constraintSet = MotionSceneModel.this.getConstraintSetTag(xmlFile, name = MotionSceneModel.trimId(name));
                    if (constraintSet != null) {
                        XmlTag constraint = constraintSet.createChildTag("Constraint", null, null, false);
                        constraint = constraintSet.addSubTag(constraint, false);
                        constraint.setAttribute("android:id", "@+id/" + type);
                        MotionSceneModel.this.transferAttributes(component, constraint);
                    }
                }
            });
            if (this.myNlModel != null) {
                MotionSceneModel.saveAndNotify((PsiFile)xmlFile, this.myNlModel);
            }
        });
    }

    private void transferAttributes(NlComponent component, XmlTag constraint) {
        HashSet<String> android = new HashSet<String>(Arrays.asList("layout_width", "layout_height", "layout_marginLeft", "layout_marginRight", "layout_marginStart", "layout_marginEnd", "layout_marginTop", "layout_marginBottom"));
        HashSet<String> sherpa = new HashSet<String>(Arrays.asList("layout_goneMarginLeft", "layout_goneMarginRight", "layout_goneMarginStart", "layout_goneMarginEnd", "layout_goneMarginTop", "layout_goneMarginBottom", "layout_constraintBaseline_toBaselineOf", "layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintWidth_default", "layout_constraintHeight_default", "layout_constraintWidth_min", "layout_constraintWidth_max", "layout_constraintHeight_min", "layout_constraintHeight_max", "layout_constraintDimensionRatio", "layout_constraintVertical_chainStyle", "layout_constraintHorizontal_chainStyle", "layout_constraintVertical_weight", "layout_constraintHorizontal_weight"));
        List<AttributeSnapshot> attr = component.getAttributesImpl();
        for (AttributeSnapshot at : attr) {
            if (sherpa.contains(at.name)) {
                constraint.setAttribute("motion:" + at.name, at.value);
            }
            if (!android.contains(at.name)) continue;
            constraint.setAttribute("android:" + at.name, at.value);
        }
    }

    @Nullable
    public SmartPsiElementPointer<XmlTag> createKeyFrame(String type, int framePosition, String id) {
        return this.createKeyFrame(type, framePosition, id, null);
    }

    @Nullable
    public SmartPsiElementPointer<XmlTag> createKeyFrame(String type, int framePosition, String id, KeyFrame copyFrom) {
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
        switch (type) {
            case "KeyPosition": {
                for (KeyPos keys : this.myCurrentTransition.mViewsMap.get((Object)id).myKeyPositions) {
                    if (keys.framePosition != framePosition) continue;
                    return null;
                }
                break;
            }
            case "KeyAttribute": {
                for (KeyAttributes keys : this.myCurrentTransition.mViewsMap.get((Object)id).myKeyAttributes) {
                    if (keys.framePosition != framePosition) continue;
                    return null;
                }
                break;
            }
        }
        XmlTag createdTag = (XmlTag)WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
            if (this.myTransition.isEmpty()) {
                return null;
            }
            XmlTag transition = (XmlTag)this.myCurrentTransition.getTag().getElement();
            if (transition == null) {
                return null;
            }
            XmlTag keyFrame = null;
            XmlTag[] tags2 = transition.getSubTags();
            for (int i2 = 0; i2 < tags2.length; ++i2) {
                XmlTag tag = tags2[i2];
                String keyNodeName = tag.getName();
                if (!keyNodeName.equals("KeyFrameSet")) continue;
                keyFrame = tag;
                break;
            }
            if (keyFrame == null) {
                keyFrame = xmlFile.getRootTag().createChildTag("KeyFrameSet", null, null, false);
                keyFrame = xmlFile.getRootTag().addSubTag(keyFrame, false);
            }
            XmlTag createdTag1 = keyFrame.createChildTag(type, null, null, false);
            createdTag1 = keyFrame.addSubTag(createdTag1, false);
            if (copyFrom != null) {
                for (AttrName attribute : copyFrom.myAttributes.keySet()) {
                    Object value2 = copyFrom.myAttributes.get(attribute);
                    createdTag1.setAttribute(attribute.getName(), attribute.getNamespace(), value2.toString());
                }
            }
            createdTag1.setAttribute("framePosition", "http://schemas.android.com/apk/res-auto", Integer.toString(framePosition));
            createdTag1.setAttribute("target", "http://schemas.android.com/apk/res-auto", "@id/" + id);
            return createdTag1;
        });
        if (this.myNlModel != null) {
            MotionSceneModel.saveAndNotify((PsiFile)xmlFile, this.myNlModel);
        }
        return SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)createdTag);
    }

    @Nullable
    public OnSwipeTag createOnSwipe() {
        OnSwipeTag onSwipeTag;
        if (this.myCurrentTransition.myOnSwipeTag != null) {
            return this.myCurrentTransition.myOnSwipeTag;
        }
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
        XmlTag createdTag = (XmlTag)WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
            XmlTag transitionTag = (XmlTag)this.myCurrentTransition.getTag().getElement();
            XmlTag onSwipeTag = transitionTag.createChildTag("OnSwipe", null, null, false);
            onSwipeTag = transitionTag.addSubTag(onSwipeTag, false);
            onSwipeTag.setAttribute("dragDirection", "http://schemas.android.com/apk/res-auto", "dragRight");
            onSwipeTag.setAttribute("touchAnchorId", "http://schemas.android.com/apk/res-auto", "@+id/" + this.myViews.get(0).getId());
            onSwipeTag.setAttribute("touchAnchorSide", "http://schemas.android.com/apk/res-auto", "top");
            return onSwipeTag;
        });
        if (this.myNlModel != null) {
            MotionSceneModel.saveAndNotify((PsiFile)xmlFile, this.myNlModel);
        }
        this.myCurrentTransition.myOnSwipeTag = onSwipeTag = new OnSwipeTag(this.myCurrentTransition.myMotionSceneModel, createdTag);
        return onSwipeTag;
    }

    @Nullable
    public OnClickTag createOnClick() {
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
        XmlTag createdTag = (XmlTag)WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
            XmlTag transitionTag = (XmlTag)this.myCurrentTransition.getTag().getElement();
            XmlTag onClickTag = transitionTag.createChildTag("OnClick", null, null, false);
            onClickTag = transitionTag.addSubTag(onClickTag, false);
            onClickTag.setAttribute("target", "http://schemas.android.com/apk/res-auto", "@+id/" + this.myViews.get(0).getId());
            return onClickTag;
        });
        if (this.myNlModel != null) {
            MotionSceneModel.saveAndNotify((PsiFile)xmlFile, this.myNlModel);
        }
        OnClickTag onSwipeTag = new OnClickTag(this.myCurrentTransition.myMotionSceneModel, createdTag);
        this.myCurrentTransition.myOnClickTags.add(onSwipeTag);
        return onSwipeTag;
    }

    public static void saveAndNotify(PsiFile xmlFile, NlModel nlModel) {
        LayoutPullParsers.saveFileIfNecessary(xmlFile);
        nlModel.notifyModified(NlModel.ChangeType.EDIT);
    }

    private static void parse(AttributeParse a, XmlAttribute[] attributes) {
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            XmlAttribute attribute = attributes[i2];
            MotionSceneModel.parse(a, new AttrName(attribute), attribute.getValue());
        }
    }

    private static void parse(AttributeParse a, AttrName name, String value2) {
        a.parse(name, value2);
    }

    public static MotionSceneModel parse(NlComponent component, Project project, VirtualFile virtualFile, XmlFile file) {
        NlModel model2 = component.getModel();
        MotionSceneModel motionSceneModel = new MotionSceneModel();
        motionSceneModel.myName = virtualFile.getName();
        ArrayList<ConstraintSet> constraintSet = new ArrayList<ConstraintSet>();
        motionSceneModel.myNlModel = model2;
        motionSceneModel.myVirtualFile = virtualFile;
        motionSceneModel.myProject = project;
        motionSceneModel.myViews = component.getChildren();
        XmlTag[] tagKeyFrames = file.getRootTag().findSubTags("ConstraintSet");
        for (int i2 = 0; i2 < tagKeyFrames.length; ++i2) {
            XmlTag frame = tagKeyFrames[i2];
            ConstraintSet set = new ConstraintSet(frame);
            MotionSceneModel.parse(set, frame.getAttributes());
            constraintSet.add(set);
            XmlTag[] subTags = frame.getSubTags();
            for (int j = 0; j < subTags.length; ++j) {
                XmlTag subtag = subTags[j];
                if (!"Constraint".equals(subtag.getName())) continue;
                ConstraintView view = new ConstraintView(subtag);
                view.setId(subtag.getAttributeValue("android:id"));
                MotionSceneModel.parse(view, subtag.getAttributes());
                set.myConstraintViews.put(view.mId, view);
            }
        }
        motionSceneModel.myConstraintSets = constraintSet;
        XmlTag[] transitionTags = file.getRootTag().findSubTags("Transition");
        if (transitionTags.length > 0) {
            motionSceneModel.myTransition = new ArrayList();
        }
        for (XmlTag transitionTag : transitionTags) {
            XmlTag[] tags2;
            TransitionTag transition = new TransitionTag(motionSceneModel, transitionTag);
            for (NlComponent view : motionSceneModel.myViews) {
                String id = MotionSceneModel.stripID(view.getId());
                MotionSceneView motionView = transition.mViewsMap.get(id);
                if (motionView == null) {
                    motionView = new MotionSceneView();
                }
                motionView.myModel = motionSceneModel;
                motionView.mid = id;
                transition.mViewsMap.put(motionView.mid, motionView);
            }
            XmlTag tag = transitionTag;
            MotionSceneModel.parse(transition, tag.getAttributes());
            motionSceneModel.myTransition.add(transition);
            motionSceneModel.myCurrentTransition = transition;
            XmlTag[] onSwipeTags = tag.findSubTags("OnSwipe");
            if (onSwipeTags.length > 1) {
                System.err.println("Should only have one tag");
            }
            for (XmlTag onSwipeTag1 : onSwipeTags) {
                OnSwipeTag onSwipeTag;
                transition.myOnSwipeTag = onSwipeTag = new OnSwipeTag(motionSceneModel, onSwipeTag1);
                XmlTag swipeTag = onSwipeTag1;
                MotionSceneModel.parse(onSwipeTag, swipeTag.getAttributes());
                transition.myOnSwipeTag = onSwipeTag;
            }
            for (XmlTag onClickTag : tags2 = tag.findSubTags("OnClick")) {
                OnClickTag onClick = new OnClickTag(motionSceneModel, onClickTag);
                transition.myOnClickTags.add(onClick);
                MotionSceneModel.parse(onClick, onClickTag.getAttributes());
            }
            for (XmlTag tagKeyFrame : tagKeyFrames = tag.findSubTags("KeyFrameSet")) {
                XmlTag[] tagkey;
                for (XmlTag xmlTag : tagkey = tagKeyFrame.getSubTags()) {
                    XmlTag[] customTags = xmlTag.getSubTags();
                    String keyNodeName = xmlTag.getName();
                    KeyFrame frame = null;
                    switch (keyNodeName) {
                        case "KeyPosition": {
                            frame = new KeyPosition(motionSceneModel, xmlTag);
                            break;
                        }
                        case "KeyAttribute": {
                            AttributeParse custom;
                            frame = new KeyAttributes(motionSceneModel, xmlTag);
                            for (XmlTag ctag : customTags) {
                                custom = new CustomAttributes((KeyAttributes)frame, ctag);
                                MotionSceneModel.parse(custom, ctag.getAttributes());
                                ((KeyAttributes)frame).myCustomAttributes.add((CustomAttributes)custom);
                            }
                            break;
                        }
                        case "KeyCycle": {
                            AttributeParse custom;
                            frame = new KeyCycle(motionSceneModel, xmlTag);
                            for (XmlTag ctag : customTags) {
                                custom = new CustomCycleAttributes((KeyCycle)frame);
                                MotionSceneModel.parse(custom, ctag.getAttributes());
                                ((KeyCycle)frame).myCustomAttributes.add((CustomCycleAttributes)custom);
                            }
                            break;
                        }
                        case "KeyTimeCycle": {
                            AttributeParse custom;
                            frame = new KeyTimeCycle(motionSceneModel, xmlTag);
                            for (XmlTag ctag : customTags) {
                                custom = new CustomCycleAttributes((KeyTimeCycle)frame);
                                MotionSceneModel.parse(custom, ctag.getAttributes());
                                ((KeyTimeCycle)frame).myCustomAttributes.add(custom);
                            }
                            break;
                        }
                        default: {
                            System.err.println("Unknown name :" + keyNodeName);
                        }
                    }
                    if (frame != null) {
                        frame.parse(xmlTag.getAttributes());
                        motionSceneModel.addKeyFrame(frame);
                    }
                    transition.addKeyFrame(motionSceneModel, frame);
                }
            }
        }
        return motionSceneModel;
    }

    public static ArrayList<KeyFrame> filterList(ArrayList<? extends KeyFrame> keyList, AttrName name) {
        ArrayList<KeyFrame> ret = new ArrayList<KeyFrame>();
        for (KeyFrame keyFrame : keyList) {
            if (!keyFrame.myAttributes.containsKey(name)) continue;
            ret.add(keyFrame);
        }
        return ret;
    }

    public static AttrName[] getGraphAttributes(ArrayList<? extends KeyFrame> keyList) {
        HashSet<AttrName> set = new HashSet<AttrName>();
        for (KeyFrame keyFrame : keyList) {
            if (keyFrame instanceof KeyAttributes) {
                set.addAll(keyFrame.myAttributes.keySet());
                continue;
            }
            if (!(keyFrame instanceof KeyCycle)) continue;
            set.addAll(keyFrame.myAttributes.keySet());
        }
        return set.toArray(new AttrName[0]);
    }

    void addKeyFrame(String id) {
        MotionSceneView motionView = this.myCurrentTransition.mViewsMap.get(id);
        if (motionView == null) {
            motionView = new MotionSceneView();
            motionView.myModel = this;
            motionView.mid = id;
            this.myCurrentTransition.mViewsMap.put(id, motionView);
        }
    }

    void addKeyFrame(KeyFrame frame) {
        String id = frame.target;
        MotionSceneView motionView = this.myCurrentTransition.mViewsMap.get(id);
        if (motionView == null) {
            motionView = new MotionSceneView();
            motionView.myModel = this;
            motionView.mid = id;
            this.myCurrentTransition.mViewsMap.put(id, motionView);
        }
        if (frame instanceof KeyAttributes) {
            motionView.myKeyAttributes.add((KeyAttributes)frame);
        } else if (frame instanceof KeyPos) {
            motionView.myKeyPositions.add((KeyPos)frame);
        } else if (frame instanceof KeyCycle) {
            motionView.myKeyCycles.add((KeyCycle)frame);
        }
    }

    public static class ConstraintView
    implements AttributeParse,
    TagAccess {
        String mId;
        SmartPsiElementPointer<XmlTag> mTag;
        HashMap<AttrName, Object> myAllAttributes = new HashMap();
        HashMap<String, String> myConstraintViews = new HashMap();

        public ConstraintView(@NotNull XmlTag tag) {
            this.mTag = SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag);
        }

        void setId(String id) {
            this.mId = MotionSceneModel.stripID(id);
        }

        @Nullable
        public String getAttribute(@NotNull AttrName name) {
            Object value2 = this.myAllAttributes.get(name);
            return value2 != null ? value2.toString() : null;
        }

        public void setAttribute(@NotNull AttrName name, @Nullable String value2) {
            if (value2 == null) {
                this.myAllAttributes.remove(name);
            } else {
                this.myAllAttributes.put(name, value2);
            }
        }

        @Override
        public void parse(AttrName name, String value2) {
            this.myAllAttributes.put(name, value2);
        }

        @Override
        public SmartPsiElementPointer<XmlTag> getTag() {
            return this.mTag;
        }
    }

    public static class OnSwipeTag
    extends BaseTag
    implements AttributeParse {
        HashMap<AttrName, Object> myAllAttributes = new HashMap();
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.motionAttr("maxVelocity"), AttrName.motionAttr("maxAcceleration"), AttrName.motionAttr("dragDirection"), AttrName.motionAttr("touchAnchorId"), AttrName.motionAttr("touchAnchorSide")};
        public AttrName[] myPossibleAttr = ourPossibleAttr;

        public AttrName[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public HashMap<AttrName, Object> getAttributes() {
            return this.myAllAttributes;
        }

        OnSwipeTag(@NotNull MotionSceneModel model2, XmlTag tag) {
            super(model2, tag, "OnSwipe");
        }

        @Override
        public void parse(AttrName name, String value2) {
            this.myAllAttributes.put(name, value2);
        }

        @Override
        @Nullable
        public String getValue(@NotNull AttrName key) {
            Object value2 = this.myAllAttributes.get(key);
            return value2 != null ? value2.toString() : null;
        }

        @Override
        @NotNull
        public Set<AttrName> getAttributeNames() {
            return this.myAllAttributes.keySet();
        }

        @Override
        public boolean deleteAttribute(@NotNull AttrName attributeName) {
            if (!super.deleteAttribute(attributeName)) {
                return false;
            }
            this.myAllAttributes.remove(attributeName);
            return true;
        }

        public boolean deleteTag() {
            return this.deleteTag("Delete OnSwing");
        }
    }

    public static class OnClickTag
    extends BaseTag
    implements AttributeParse {
        HashMap<AttrName, Object> myAllAttributes = new HashMap();
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.motionAttr("target"), AttrName.motionAttr("touchAnchorSide")};
        public AttrName[] myPossibleAttr = ourPossibleAttr;

        public AttrName[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public HashMap<AttrName, Object> getAttributes() {
            return this.myAllAttributes;
        }

        OnClickTag(@NotNull MotionSceneModel model2, XmlTag tag) {
            super(model2, tag, "OnClick");
        }

        @Override
        public void parse(AttrName name, String value2) {
            this.myAllAttributes.put(name, value2);
        }

        @Override
        @Nullable
        public String getValue(@NotNull AttrName key) {
            Object value2 = this.myAllAttributes.get(key);
            return value2 != null ? value2.toString() : null;
        }

        @Override
        @NotNull
        public Set<AttrName> getAttributeNames() {
            return this.myAllAttributes.keySet();
        }

        @Override
        public boolean deleteAttribute(@NotNull AttrName attributeName) {
            if (!super.deleteAttribute(attributeName)) {
                return false;
            }
            this.myAllAttributes.remove(attributeName);
            return true;
        }

        public boolean deleteTag() {
            return this.deleteTag("Delete OnClick");
        }
    }

    public static class TransitionTag
    extends BaseTag
    implements AttributeParse {
        private final AttrName[] myPossibleAttr;
        String myConstraintSetEnd;
        String myConstraintSetStart;
        OnSwipeTag myOnSwipeTag = null;
        ArrayList<OnClickTag> myOnClickTags = new ArrayList();
        int duration;
        public ArrayList<KeyPos> myKeyPositions = new ArrayList();
        public ArrayList<KeyAttributes> myKeyAttributes = new ArrayList();
        public ArrayList<KeyCycle> myKeyCycles = new ArrayList();
        public HashMap<String, MotionSceneView> mViewsMap = new HashMap();
        HashMap<AttrName, Object> myAllAttributes = new HashMap();
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.motionAttr("constraintSetStart"), AttrName.motionAttr("constraintSetEnd"), AttrName.motionAttr("duration"), AttrName.motionAttr("staggered")};

        void addKeyFrame(MotionSceneModel model2, KeyFrame frame) {
            String id = frame.target;
            MotionSceneView motionView = this.mViewsMap.get(id);
            if (motionView == null) {
                motionView = new MotionSceneView();
                motionView.myModel = model2;
                motionView.mid = id;
                this.mViewsMap.put(id, motionView);
            }
            if (frame instanceof KeyAttributes) {
                motionView.myKeyAttributes.add((KeyAttributes)frame);
            } else if (frame instanceof KeyPos) {
                motionView.myKeyPositions.add((KeyPos)frame);
            } else if (frame instanceof KeyCycle) {
                motionView.myKeyCycles.add((KeyCycle)frame);
            }
        }

        public AttrName[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public HashMap<AttrName, Object> getAttributes() {
            return this.myAllAttributes;
        }

        TransitionTag(MotionSceneModel model2, XmlTag tag) {
            super(model2, tag, "Transition");
            this.myPossibleAttr = ourPossibleAttr;
        }

        public ConstraintSet getConstraintSetEnd() {
            if (this.myConstraintSetEnd == null) {
                return null;
            }
            for (ConstraintSet set : this.myMotionSceneModel.myConstraintSets) {
                if (!this.myConstraintSetEnd.equals(set.mId)) continue;
                return set;
            }
            return null;
        }

        public ConstraintSet getConstraintSetStart() {
            if (this.myConstraintSetStart == null) {
                return null;
            }
            for (ConstraintSet set : this.myMotionSceneModel.myConstraintSets) {
                if (!this.myConstraintSetStart.equals(set.mId)) continue;
                return set;
            }
            return null;
        }

        @Override
        public void parse(AttrName name, String value2) {
            this.myAllAttributes.put(name, value2);
            if (name.isMotionAttr("constraintSetEnd")) {
                this.myConstraintSetEnd = MotionSceneModel.stripID(value2);
            } else if (name.isMotionAttr("constraintSetStart")) {
                this.myConstraintSetStart = MotionSceneModel.stripID(value2);
            } else if (name.isMotionAttr("duration")) {
                this.duration = Integer.parseInt(value2);
            }
        }

        @Override
        public boolean deleteTag(@NotNull String command) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Set<AttrName> getAttributeNames() {
            return this.myAllAttributes.keySet();
        }

        @Override
        @Nullable
        public String getValue(@NotNull AttrName key) {
            Object value2 = this.myAllAttributes.get(key);
            return value2 != null ? value2.toString() : null;
        }

        @Override
        public boolean setValue(@NotNull AttrName key, @NotNull String value2) {
            if (!super.setValue(key, value2)) {
                return false;
            }
            this.parse(key, value2);
            return true;
        }

        @Override
        public boolean deleteAttribute(@NotNull AttrName attributeName) {
            if (!super.deleteAttribute(attributeName)) {
                return false;
            }
            this.myAllAttributes.remove(attributeName);
            return true;
        }
    }

    public static class ConstraintSet
    implements AttributeParse {
        String mId;
        SmartPsiElementPointer<XmlTag> mTag;
        HashMap<String, ConstraintView> myConstraintViews = new HashMap();

        public ConstraintSet(@NotNull XmlTag tag) {
            this.mId = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
            this.mTag = SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag);
        }

        public String getId() {
            return this.mId;
        }

        public SmartPsiElementPointer<XmlTag> getTag() {
            return this.mTag;
        }

        void setId(String id) {
            this.mId = MotionSceneModel.stripID(id);
        }

        @Nullable
        public ConstraintView getConstraintView(@NotNull String id) {
            return this.myConstraintViews.get(id);
        }

        @Override
        public void parse(AttrName name, String value2) {
            if (name.isId()) {
                this.mId = MotionSceneModel.stripID(value2);
            }
        }
    }

    static interface AttributeParse {
        public void parse(AttrName var1, String var2);
    }

    public static class CustomAttributes
    extends BaseTag
    implements AttributeParse {
        private final KeyAttributes parentKeyAttributes;
        private final HashMap<AttrName, Object> myAttributes = new HashMap();

        @Nullable
        public String getAttributeName() {
            return (String)this.myAttributes.get(AttrName.motionAttr("attributeName"));
        }

        @Nullable
        public String getValueTagName() {
            return Arrays.stream(Type.values()).map(key -> key.getTagName()).filter(tag -> this.myAttributes.containsKey(AttrName.customAttr(tag))).findFirst().orElse(null);
        }

        public String toString() {
            return Arrays.toString(this.myAttributes.keySet().toArray());
        }

        public boolean deleteTag() {
            if (!super.deleteTag("Remove custom attribute")) {
                return false;
            }
            this.parentKeyAttributes.getCustomAttributes().remove(this);
            return true;
        }

        @Override
        @NotNull
        public Set<AttrName> getAttributeNames() {
            return Collections.singleton(AttrName.customAttr(this.getAttributeName()));
        }

        @Override
        @Nullable
        public String getValue(@NotNull AttrName key) {
            Object value2 = this.myAttributes.get(key);
            return value2 != null ? value2.toString() : null;
        }

        @Override
        public boolean setValue(@NotNull AttrName key, @NotNull String value2) {
            if (!super.setValue(key, value2)) {
                return false;
            }
            this.parse(key, value2);
            return true;
        }

        @Override
        public boolean deleteAttribute(@NotNull AttrName attributeName) {
            throw new UnsupportedOperationException();
        }

        public CustomAttributes(@NotNull KeyAttributes frame, @NotNull XmlTag tag) {
            super(frame.getModel(), tag, "");
            this.parentKeyAttributes = frame;
        }

        public HashMap<AttrName, Object> getAttributes() {
            return this.myAttributes;
        }

        @Override
        public void parse(AttrName name, String value2) {
            this.myAttributes.put(name, value2);
        }

        public static enum Type {
            CUSTOM_COLOR("Color", "customColorValue", "#FFF"),
            CUSTOM_INTEGER("Integer", "customIntegerValue", "2"),
            CUSTOM_FLOAT("Float", "customFloatValue", "1.0"),
            CUSTOM_STRING("String", "customStringValue", "Example"),
            CUSTOM_DIMENSION("Dimension", "customDimension", "20dp"),
            CUSTOM_BOOLEAN("Boolean", "customBoolean", "true");

            private final String myStringValue;
            private final String myTagName;
            private final String myDefaultValue;

            @NotNull
            public String getTagName() {
                return this.myTagName;
            }

            @NotNull
            public String getDefaultValue() {
                return this.myDefaultValue;
            }

            public String toString() {
                return this.myStringValue;
            }

            private Type(@NotNull String stringValue, String tagName, String defaultValue) {
                this.myStringValue = stringValue;
                this.myTagName = tagName;
                this.myDefaultValue = defaultValue;
            }
        }
    }

    public static class CustomCycleAttributes
    implements AttributeParse {
        KeyCycle parentKeyCycle;
        HashMap<AttrName, Object> myAttributes = new HashMap();
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.customAttr("attributeName"), AttrName.customAttr("customIntegerValue"), AttrName.customAttr("customFloatValue"), AttrName.customAttr("customDimension")};
        public static String[][] ourDefaults = new String[][]{new String[0], {"1"}, {"1.0"}, {"20dp"}};

        public String[] getDefault(AttrName key) {
            for (int i2 = 0; i2 < ourPossibleAttr.length; ++i2) {
                if (!key.equals(ourPossibleAttr[i2])) continue;
                return ourDefaults.length > i2 ? ourDefaults[i2] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public CustomCycleAttributes(KeyCycle frame) {
            this.parentKeyCycle = frame;
        }

        @Override
        public void parse(AttrName name, String value2) {
            this.myAttributes.put(name, value2);
        }
    }

    public static class KeyTimeCycle
    extends KeyCycle {
        static final String TYPE = "KeyTimeCycle";

        public KeyTimeCycle(MotionSceneModel motionSceneModel, XmlTag tag) {
            super(motionSceneModel, tag);
        }
    }

    public static class KeyCycle
    extends KeyFrame {
        static final String TYPE = "KeyCycle";
        float waveOffset = Float.NaN;
        float wavePeriod = Float.NaN;
        ArrayList<CustomCycleAttributes> myCustomAttributes = new ArrayList();
        String waveShape;
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.motionAttr("target"), AttrName.motionAttr("framePosition"), AttrName.motionAttr("transitionEasing"), AttrName.motionAttr("curveFit"), AttrName.motionAttr("progress"), AttrName.motionAttr("waveShape"), AttrName.motionAttr("wavePeriod"), AttrName.motionAttr("waveOffset"), AttrName.motionAttr("transitionPathRotate"), AttrName.motionAttr("alpha"), AttrName.motionAttr("elevation"), AttrName.motionAttr("rotation"), AttrName.motionAttr("rotationX"), AttrName.motionAttr("rotationY"), AttrName.motionAttr("scaleX"), AttrName.motionAttr("scaleY"), AttrName.motionAttr("translationX"), AttrName.motionAttr("translationY"), AttrName.motionAttr("translationZ")};
        public static String[][] ourDefaults = new String[][]{new String[0], new String[0], {"curve=(0.5,0,0.5,1)"}, {"spline", "linear"}, {"0.5"}, {"sin", "square", "triangle", "sawtooth", "reverseSawtooth", "cos", "bounce"}, {"1"}, {"0"}, {"90"}, {"0.5"}, {"20dp"}, {"45"}, {"10"}, {"10"}, {"1.5"}, {"1.5"}, {"20dp"}, {"20dp"}, {"20dp"}};

        @Override
        public String[] getDefault(AttrName key) {
            for (int i2 = 0; i2 < ourPossibleAttr.length; ++i2) {
                if (!key.equals(ourPossibleAttr[i2])) continue;
                return ourDefaults.length > i2 ? ourDefaults[i2] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public String toString() {
            return this.getName() + Arrays.toString(this.myAttributes.keySet().toArray());
        }

        public KeyCycle(MotionSceneModel motionSceneModel, XmlTag tag) {
            super(motionSceneModel, tag, "Cycle");
            this.mType = TYPE;
            this.myPossibleAttr = ourPossibleAttr;
        }

        @Override
        public void fill(HashMap<AttrName, Object> attributes) {
            attributes.putAll(this.myAttributes);
            if (!Float.isNaN(this.waveOffset)) {
                attributes.put(AttrName.motionAttr("waveOffset"), Float.valueOf(this.waveOffset));
            }
            if (!Float.isNaN(this.wavePeriod)) {
                attributes.put(AttrName.motionAttr("wavePeriod"), Float.valueOf(this.wavePeriod));
            }
            if (this.waveShape != null) {
                attributes.put(AttrName.motionAttr("waveOffset"), this.waveShape);
            }
            super.fill(attributes);
        }

        @Override
        void parse(AttrName node, String value2) {
            if (node.isMotionAttr("waveOffset")) {
                this.waveOffset = this.fparse(value2);
            } else if (node.isMotionAttr("wavePeriod")) {
                this.wavePeriod = Float.parseFloat(value2);
            } else if (node.isMotionAttr("waveShape")) {
                this.waveShape = value2;
            }
            super.parse(node, value2);
        }

        @Override
        public KeyFrame cloneKeyFrame() {
            KeyCycle ret = new KeyCycle(this.myMotionSceneModel, (XmlTag)this.myTag.getElement());
            ret.myAttributes.putAll(this.myAttributes);
            return ret;
        }
    }

    public static class KeyAttributes
    extends KeyFrame {
        static final String TYPE = "KeyAttribute";
        String curveFit = null;
        ArrayList<CustomAttributes> myCustomAttributes = new ArrayList();
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.motionAttr("framePosition"), AttrName.motionAttr("target"), AttrName.motionAttr("transitionEasing"), AttrName.motionAttr("curveFit"), AttrName.motionAttr("sizePercent"), AttrName.motionAttr("progress"), AttrName.motionAttr("orientation"), AttrName.androidAttr("alpha"), AttrName.androidAttr("elevation"), AttrName.androidAttr("rotation"), AttrName.androidAttr("rotationX"), AttrName.androidAttr("rotationY"), AttrName.motionAttr("transitionPathRotate"), AttrName.androidAttr("scaleX"), AttrName.androidAttr("scaleY"), AttrName.androidAttr("translationX"), AttrName.androidAttr("translationY"), AttrName.androidAttr("translationZ"), AttrName.customAttr("Custom...")};
        public static String[][] ourDefaults = new String[][]{new String[0], new String[0], {"curve=(0.5,0,0.5,1)"}, {"spline", "linear"}, {"0.5"}, {"0.5"}, {"90"}, {"0.5"}, {"5dp"}, {"45"}, {"10"}, {"10"}, {"90"}, {"1.5"}, {"1.5"}, {"10dp"}, {"10dp"}, {"10dp"}};
        public static String[] ourPossibleStandardAttr = new String[]{"orientation", "alpha", "elevation", "rotation", "rotationX", "rotationY", "scaleX", "scaleY", "translationX", "translationY", "translationZ"};
        HashSet<String> myAndroidAttributes = null;

        @Override
        @NotNull
        public List<CustomAttributes> getCustomAttributes() {
            return this.myCustomAttributes;
        }

        @Override
        public String[] getDefault(AttrName key) {
            for (int i2 = 0; i2 < ourPossibleAttr.length; ++i2) {
                if (!key.equals(ourPossibleAttr[i2])) continue;
                return ourDefaults.length > i2 ? ourDefaults[i2] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public KeyAttributes(MotionSceneModel motionSceneModel, XmlTag tag) {
            super(motionSceneModel, tag, "Targeted Attributes");
            this.mType = TYPE;
            this.myPossibleAttr = ourPossibleAttr;
        }

        @Override
        public void fill(HashMap<AttrName, Object> attributes) {
            attributes.putAll(this.myAttributes);
            if (this.curveFit != null) {
                attributes.put(AttrName.motionAttr("curveFit"), this.curveFit);
            }
            super.fill(attributes);
        }

        @Override
        void parse(AttrName node, String value2) {
            if (node.isMotionAttr("curveFit")) {
                this.curveFit = value2;
                this.myAttributes.put(node, value2);
            } else if (MotionSceneString.ourStandardSet.contains(node)) {
                this.myAttributes.put(node, value2);
            } else {
                super.parse(node, value2);
            }
        }

        @Override
        public KeyFrame cloneKeyFrame() {
            KeyAttributes ret = new KeyAttributes(this.myMotionSceneModel, (XmlTag)this.myTag.getElement());
            ret.myAttributes.putAll(this.myAttributes);
            return ret;
        }

        @Override
        @Nullable
        public CustomAttributes createCustomAttribute(@NotNull String key, @NotNull CustomAttributes.Type type, @NotNull String value2) {
            XmlTag keyFrame = this.findMyTag();
            if (keyFrame == null) {
                return null;
            }
            List existing2 = this.myCustomAttributes.stream().filter(attr -> key.equals(attr.getAttributeName())).collect(Collectors.toList());
            for (CustomAttributes attr2 : existing2) {
                attr2.deleteTag();
            }
            Computable operation = () -> {
                XmlTag createdTag = keyFrame.createChildTag("CustomAttribute", null, null, false);
                createdTag = keyFrame.addSubTag(createdTag, false);
                createdTag.setAttribute("attributeName", "http://schemas.android.com/apk/res-auto", key);
                createdTag.setAttribute(type.getTagName(), "http://schemas.android.com/apk/res-auto", StringUtil.isNotEmpty((String)value2) ? value2 : type.getDefaultValue());
                CustomAttributes custom = new CustomAttributes(this, createdTag);
                Arrays.stream(createdTag.getAttributes()).forEach(attr -> custom.parse(AttrName.motionAttr(attr.getLocalName()), attr.getValue()));
                this.myCustomAttributes.add(custom);
                return custom;
            };
            CustomAttributes newAttribute = (CustomAttributes)WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (Computable)operation);
            this.completeSceneModelUpdate();
            return newAttribute;
        }
    }

    public static class KeyPosition
    extends KeyPos {
        static final String TYPE = "KeyPosition";
        float percentX = Float.NaN;
        float percentY = Float.NaN;
        public static AttrName[] ourPossibleAttr = new AttrName[]{AttrName.motionAttr("framePosition"), AttrName.motionAttr("target"), AttrName.motionAttr("transitionEasing"), AttrName.motionAttr("curveFit"), AttrName.motionAttr("drawPath"), AttrName.motionAttr("sizePercent"), AttrName.motionAttr("sizePercent"), AttrName.motionAttr("percentY"), AttrName.motionAttr("percentX"), AttrName.motionAttr("type")};
        public static String[][] ourDefaults = new String[][]{new String[0], new String[0], {"cubic(0.5,0,0.5,1)"}, {"spline", "linear"}, {"true", "false"}, {"0.5"}, {"0.0"}, {"0.5"}};

        @Override
        public String[] getDefault(AttrName key) {
            for (int i2 = 0; i2 < ourPossibleAttr.length; ++i2) {
                if (!key.equals(ourPossibleAttr[i2])) continue;
                return ourDefaults.length > i2 ? ourDefaults[i2] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public KeyPosition(MotionSceneModel motionSceneModel, XmlTag tag) {
            super(motionSceneModel, tag);
            this.myPossibleAttr = ourPossibleAttr;
            this.mType = TYPE;
        }

        @Override
        public void fill(HashMap<AttrName, Object> attributes) {
            super.fill(attributes);
            if (!Float.isNaN(this.percentX)) {
                attributes.put(AttrName.motionAttr("path_percent"), Float.valueOf(this.percentX));
            }
            if (!Float.isNaN(this.percentY)) {
                attributes.put(AttrName.motionAttr("perpendicularPath_percent"), Float.valueOf(this.percentY));
            }
        }

        @Override
        public float getFloat(String type) {
            if ("perpendicularPath_percent".equals(type)) {
                return this.percentY;
            }
            if ("path_percent".equals(type)) {
                return this.percentY;
            }
            return super.getFloat(type);
        }

        @Override
        void parse(AttrName node, String value2) {
            super.parse(node, value2);
            if (node.isMotionAttr("path_percent")) {
                this.percentX = Float.parseFloat(value2);
            } else if (node.isMotionAttr("perpendicularPath_percent")) {
                this.percentY = Float.parseFloat(value2);
            }
        }

        @Override
        public KeyFrame cloneKeyFrame() {
            KeyPosition ret = new KeyPosition(this.myMotionSceneModel, (XmlTag)this.myTag.getElement());
            ret.myAttributes.putAll(this.myAttributes);
            return ret;
        }
    }

    public static abstract class KeyPos
    extends KeyFrame {
        String transitionEasing = null;

        public KeyPos(MotionSceneModel motionSceneModel, XmlTag tag) {
            super(motionSceneModel, tag, "Position");
        }

        @Override
        public float getFloat(String type) {
            return super.getFloat(type);
        }

        @Override
        void parse(AttrName name, String value2) {
            if (name.isMotionAttr("transitionEasing")) {
                this.transitionEasing = value2;
            }
            super.parse(name, value2);
        }

        @Override
        public void fill(HashMap<AttrName, Object> attributes) {
            super.fill(attributes);
            if (this.transitionEasing != null) {
                attributes.put(AttrName.motionAttr("framePosition"), this.framePosition);
            }
        }
    }

    public static abstract class KeyFrame
    extends BaseTag {
        protected String mType;
        int framePosition;
        String target;
        HashMap<AttrName, Object> myAttributes = new HashMap();
        protected AttrName[] myPossibleAttr;

        public KeyFrame(@NotNull MotionSceneModel motionSceneModel, @NotNull XmlTag tag, @NotNull String title) {
            super(motionSceneModel, tag, title);
        }

        @Override
        @Nullable
        public String getValue(@NotNull AttrName key) {
            Object value2 = this.myAttributes.get(key);
            return value2 != null ? value2.toString() : null;
        }

        @Override
        @NotNull
        public Set<AttrName> getAttributeNames() {
            return this.myAttributes.keySet();
        }

        public abstract String[] getDefault(AttrName var1);

        public CustomAttributes createCustomAttribute(@NotNull String key, @NotNull CustomAttributes.Type type, @NotNull String value2) {
            throw new UnsupportedOperationException();
        }

        public String getString(String type) {
            if ("target".equals(type)) {
                return this.target;
            }
            return null;
        }

        public AttrName[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public int getFramePosition() {
            return this.framePosition;
        }

        public float getFloat(String type) {
            String val = this.myAttributes.get(AttrName.motionAttr(type)).toString();
            if (val.endsWith("dp")) {
                val = val.substring(0, val.length() - 2);
            }
            return Float.parseFloat(val);
        }

        public void fill(HashMap<AttrName, Object> attributes) {
            attributes.put(AttrName.motionAttr("framePosition"), this.framePosition);
            attributes.put(AttrName.motionAttr("target"), this.target);
            attributes.putAll(this.myAttributes);
        }

        void parse(NamedNodeMap att) {
            int attCount = att.getLength();
            for (int i2 = 0; i2 < attCount; ++i2) {
                Node node = att.item(i2);
                this.parse(new AttrName(node.getNamespaceURI(), node.getNodeName()), att.item(i2).getNodeValue());
            }
        }

        float fparse(String v) {
            if (v.endsWith("dp")) {
                return Float.parseFloat(v.substring(0, v.length() - 2));
            }
            return Float.parseFloat(v);
        }

        void parse(AttrName name, String value2) {
            if (value2 == null) {
                this.myAttributes.remove(name);
                return;
            }
            this.myAttributes.put(name, value2);
            if (name.isMotionAttr("framePosition")) {
                this.framePosition = Integer.parseInt(value2);
            } else if (name.isMotionAttr("target")) {
                this.target = value2.substring(value2.indexOf(47) + 1);
            }
        }

        private String trim(String node) {
            return node.substring(node.indexOf(58) + 1);
        }

        public void parse(XmlAttribute[] attributes) {
            for (int i2 = 0; i2 < attributes.length; ++i2) {
                XmlAttribute attribute = attributes[i2];
                this.parse(new AttrName(attribute), attribute.getValue());
            }
        }

        @Override
        public boolean deleteAttribute(@NotNull AttrName name) {
            if (name.isMotionAttr("target") || name.isMotionAttr("framePosition")) {
                return false;
            }
            if (!super.deleteAttribute(name)) {
                return false;
            }
            this.myAttributes.remove(name);
            return true;
        }

        public boolean deleteTag() {
            String command = "Delete key attributes for: " + this.target;
            return super.deleteTag(command);
        }

        @Override
        public boolean setValue(@NotNull AttrName attr, @NotNull String value2) {
            if (!super.setValue(attr, value2)) {
                return false;
            }
            this.parse(attr, value2);
            return true;
        }

        @Override
        public boolean setValues(@NotNull HashMap<AttrName, String> values) {
            if (!super.setValues(values)) {
                return false;
            }
            for (AttrName key : values.keySet()) {
                this.parse(key, values.get(key));
            }
            return true;
        }

        boolean match(XmlTag xmlTag) {
            String keyNodeName = xmlTag.getName();
            if (!keyNodeName.equals(this.mType)) {
                return false;
            }
            XmlAttribute[] attr = xmlTag.getAttributes();
            for (int k = 0; k < attr.length; ++k) {
                XmlAttribute attribute = attr[k];
                if (attribute.getName().endsWith("framePosition") && Integer.parseInt(attribute.getValue()) != this.framePosition) {
                    return false;
                }
                if (!attribute.getName().endsWith("target") || attribute.getValue().endsWith(this.target)) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return this.mType;
        }

        public String getEasingCurve() {
            return (String)this.myAttributes.get(AttrName.motionAttr("transitionEasing"));
        }

        public abstract KeyFrame cloneKeyFrame();
    }

    public static abstract class BaseTag
    implements TagAccess {
        protected final MotionSceneModel myMotionSceneModel;
        protected final String myTitle;
        protected final SmartPsiElementPointer<XmlTag> myTag;

        public BaseTag(@NotNull MotionSceneModel model2, @NotNull XmlTag tag, @NotNull String title) {
            this.myMotionSceneModel = model2;
            this.myTitle = title;
            this.myTag = SmartPointerManager.getInstance((Project)model2.getProject()).createSmartPsiElementPointer((PsiElement)tag);
        }

        @NotNull
        public String getTitle() {
            return this.myTitle;
        }

        @NotNull
        public MotionSceneModel getModel() {
            return this.myMotionSceneModel;
        }

        public XmlTag findMyTag() {
            return (XmlTag)this.myTag.getElement();
        }

        @Override
        public SmartPsiElementPointer<XmlTag> getTag() {
            return this.myTag;
        }

        protected void completeSceneModelUpdate() {
            MotionSceneModel.saveAndNotify((PsiFile)this.myMotionSceneModel.motionSceneFile(), this.myMotionSceneModel.myNlModel);
        }

        public boolean deleteTag(@NotNull String command) {
            XmlTag tag = this.findMyTag();
            if (tag == null) {
                return false;
            }
            Runnable operation = () -> tag.delete();
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        public boolean setValues(@NotNull HashMap<AttrName, String> values) {
            XmlTag tag = this.findMyTag();
            if (tag == null) {
                return false;
            }
            String command = "Set attributes";
            Runnable operation = () -> {
                for (AttrName key : values.keySet()) {
                    String value2 = (String)values.get(key);
                    tag.setAttribute(key.getName(), key.getNamespace(), value2);
                }
            };
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        protected boolean setValue(@NotNull XmlTag tag, @NotNull AttrName attr, @NotNull String value2) {
            String command = "Set " + attr + " attribute";
            Runnable operation = () -> tag.setAttribute(attr.getName(), attr.getNamespace(), value2);
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        public boolean setValue(@NotNull AttrName attr, @NotNull String value2) {
            XmlTag tag = this.findMyTag();
            if (tag == null) {
                return false;
            }
            return this.setValue(tag, attr, value2);
        }

        @NotNull
        public abstract Set<AttrName> getAttributeNames();

        @NotNull
        public List<CustomAttributes> getCustomAttributes() {
            return Collections.emptyList();
        }

        @Nullable
        public abstract String getValue(@NotNull AttrName var1);

        public boolean deleteAttribute(@NotNull AttrName attr) {
            XmlTag tag = this.findMyTag();
            if (tag == null) {
                return false;
            }
            String command = "Delete " + attr + " attribute";
            Runnable operation = () -> tag.setAttribute(attr.getName(), attr.getNamespace(), null);
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }
    }

    static interface TagAccess {
        public SmartPsiElementPointer<XmlTag> getTag();
    }

    public static class MotionSceneView {
        String mid;
        Icon myIcon;
        MotionSceneModel myModel;
        public ArrayList<KeyPos> myKeyPositions = new ArrayList();
        public ArrayList<KeyAttributes> myKeyAttributes = new ArrayList();
        public ArrayList<KeyCycle> myKeyCycles = new ArrayList();

        @NotNull
        public Icon getIcon() {
            if (this.myIcon == null) {
                this.myIcon = this.findIcon();
            }
            return this.myIcon;
        }

        @NotNull
        private Icon findIcon() {
            NlComponent component = this.myModel.myNlModel.find(this.mid);
            if (component == null) {
                return StudioIcons.LayoutEditor.Palette.VIEW;
            }
            ViewHandlerManager manager = ViewHandlerManager.get(this.myModel.myProject);
            ViewHandler handler = manager.getHandler(component);
            if (handler == null) {
                return StudioIcons.LayoutEditor.Palette.VIEW;
            }
            return handler.getIcon(component);
        }
    }
}

