/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.AttrName;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class OnSwipePanel
extends JPanel {
    private static final boolean DEBUG = false;
    OnSwipTagPanel mOnSwipeUI;

    OnSwipePanel(Dimension size) {
        super(new BorderLayout());
        this.setBackground(Chart.ourSecondaryPanelBackground);
        this.mOnSwipeUI = new OnSwipTagPanel();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.mOnSwipeUI);
        scrollPane.setPreferredSize(size);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane);
    }

    public void setOnSwipeTag(MotionSceneModel.OnSwipeTag tag) {
        this.mOnSwipeUI.setOnSwipeTag(tag);
    }

    public class OnSwipTagPanel
    extends TagPanel {
        private Vector<String> colNames = new Vector<String>(Arrays.asList("Name", "Value"));
        private Vector<Vector<Object>> data = new Vector();
        private DefaultTableModel myTableModel = new OnSwipeTableModel(this.data, this.colNames);
        MotionSceneModel.OnSwipeTag myOnSwipeTag;
        private JBPopupMenu myPopupMenu = new JBPopupMenu("Add Attribute");
        private static final String ATTR_ATTRIBUTE_NAME = "AttributeName";
        public ActionListener myAddItemAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttrName attributeName = (AttrName)((JMenuItem)e.getSource()).getClientProperty(OnSwipTagPanel.ATTR_ATTRIBUTE_NAME);
                String value2 = "";
                if (OnSwipTagPanel.this.myOnSwipeTag != null && OnSwipTagPanel.this.myOnSwipeTag.setValue(attributeName, value2)) {
                    OnSwipTagPanel.this.myTableModel.addRow(new Object[]{attributeName, value2});
                }
            }
        };

        public OnSwipTagPanel() {
            this.myTable = new JBTable((TableModel)this.myTableModel);
            this.myRemoveTagButton = EditorUtils.makeButton(TimeLineIcons.REMOVE_TAG);
            this.setup();
            this.myTable.setSelectionMode(0);
            this.myTable.setDefaultRenderer(EditorUtils.AttributesNamesHolder.class, new EditorUtils.AttributesNamesCellRenderer());
            this.myTable.setDefaultRenderer(String.class, new EditorUtils.AttributesValueCellRenderer());
            this.myTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                    if (!isSelected) {
                        c.setForeground((Color)(column > 0 ? EditorUtils.ourValueColor : EditorUtils.ourNameColor));
                    }
                    return c;
                }
            });
            this.myPopupMenu.add(new JMenuItem("test1"));
            this.myAddRemovePanel.myAddButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    OnSwipTagPanel.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            if (this.myTitle != null) {
                gbc.fill = 1;
                this.add((Component)this.myTitle, gbc);
            }
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 13;
            gbc.fill = 1;
            this.add((Component)this.myTable, gbc);
            ++gbc.gridy;
            gbc.fill = 0;
            gbc.anchor = 17;
            this.add((Component)this.myAddRemovePanel, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 13;
            this.add((Component)this.myRemoveTagButton, gbc);
        }

        @Override
        protected void deleteAttr(int selection) {
            AttrName attributeName = (AttrName)this.myTable.getValueAt(selection, 0);
            if (this.myOnSwipeTag != null && this.myOnSwipeTag.deleteAttribute(attributeName)) {
                this.myTableModel.removeRow(selection);
            }
        }

        @Override
        protected void deleteTag() {
            if (this.myOnSwipeTag != null && this.myOnSwipeTag.deleteTag()) {
                this.setVisible(false);
            }
        }

        private void setupPopup(MotionSceneModel.OnSwipeTag tag, Set<AttrName> strings) {
            this.myOnSwipeTag = tag;
            this.myPopupMenu.removeAll();
            AttrName[] names = tag.getPossibleAttr();
            for (int i2 = 0; i2 < names.length; ++i2) {
                if (strings.contains(names[i2])) continue;
                JMenuItem menuItem = new JMenuItem(names[i2].getName());
                menuItem.putClientProperty(ATTR_ATTRIBUTE_NAME, names[i2]);
                menuItem.addActionListener(this.myAddItemAction);
                this.myPopupMenu.add(menuItem);
            }
        }

        public void setOnSwipeTag(MotionSceneModel.OnSwipeTag tag) {
            this.setVisible(tag != null);
            if (tag == null) {
                this.setVisible(false);
                return;
            }
            HashMap<AttrName, Object> attr = tag.getAttributes();
            this.data.clear();
            for (AttrName s : attr.keySet()) {
                Vector<Object> v = new Vector<Object>(Arrays.asList(s, attr.get(s)));
                this.data.add(v);
            }
            this.myTableModel.fireTableDataChanged();
            this.setupPopup(tag, attr.keySet());
            this.setVisible(true);
        }

        private class OnSwipeTableModel
        extends DefaultTableModel {
            private OnSwipeTableModel(@NotNull Vector data, Vector columnNames) {
                super(data, columnNames);
            }

            @Override
            public void setValueAt(@NotNull Object value2, int rowIndex, int columnIndex) {
                super.setValueAt(value2, rowIndex, columnIndex);
                AttrName key = (AttrName)this.getValueAt(rowIndex, 0);
                OnSwipTagPanel.this.myOnSwipeTag.setValue(key, (String)value2);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }
        }
    }
}

