/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TimeLine
extends JPanel {
    private static float TIMELINE_MIN = 0.0f;
    private static float TIMELINE_MAX = 100.0f;
    private final Chart myChart;
    private Tick tick = new Tick();

    TimeLine(Chart chart) {
        this.myChart = chart;
        this.tick.setRange(TIMELINE_MIN, TIMELINE_MAX);
    }

    public void setGraphWidth(int w) {
        this.tick.calcRangeTicks(w);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        g.setColor(this.getForeground());
        int n = this.tick.getCount();
        if (this.myChart.myXTicksPixels.length <= n) {
            this.myChart.myXTicksPixels = new int[n * 2];
        }
        this.myChart.myXTickCount = this.tick.paint(g2d, w, h, this.myChart.myXTicksPixels);
    }

    public void setInserts(int left2, int right2) {
        this.tick.setInsets(left2, right2, 0, 0);
    }

    public static void main(String[] arg) {
        File dir = new File("");
        TimeLine p = new TimeLine(null);
        JFrame f = new JFrame("timeline");
        f.setContentPane(p);
        f.setBounds(100, 100, 1200, 800);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    static class Tick {
        private float actual_minx;
        private float actual_maxx;
        private float minx;
        private float maxx;
        private float mTickX;
        int ins_left;
        int ins_right;
        int ins_top = 0;
        int ins_botom = 0;
        int mTextGap = 2;
        int mCanvasWidth;
        DecimalFormat df = new DecimalFormat("###.##");
        int mGraphWidth;

        Tick() {
        }

        public void setInsets(int l, int r, int t, int b) {
            this.ins_botom = b;
            this.ins_left = l;
            this.ins_right = r;
            this.ins_top = t;
        }

        public void setRange(float min, float max) {
            this.actual_minx = min;
            this.actual_maxx = max;
        }

        void calcRangeTicks(int canvasWidth) {
            this.mCanvasWidth = canvasWidth;
            double dx = this.actual_maxx - this.actual_minx;
            int sw = canvasWidth;
            double border = 1.09345;
            this.mTickX = (float)Tick.calcTick(sw, dx);
            dx = (double)this.mTickX * Math.ceil(border * dx / (double)this.mTickX);
            double tx = ((double)(this.actual_minx + this.actual_maxx) - dx) / 2.0;
            this.minx = this.actual_minx;
            tx = ((double)(this.actual_minx + this.actual_maxx) + dx) / 2.0;
            tx = (double)this.mTickX * Math.ceil(tx / (double)this.mTickX);
            this.maxx = this.actual_maxx;
        }

        public static double calcTick(int scr, double range) {
            int aprox_x_ticks = scr / 100;
            int type = 1;
            double best = Math.log10(range / (double)aprox_x_ticks);
            double n = Math.log10(range / (double)(aprox_x_ticks * 2));
            if (Tick.frac(n) < Tick.frac(best)) {
                best = n;
                type = 2;
            }
            if (Tick.frac(n = Math.log10(range / (double)(aprox_x_ticks * 5))) < Tick.frac(best)) {
                best = n;
                type = 5;
            }
            return (double)type * Math.pow(10.0, Math.floor(best));
        }

        public int getCount() {
            float e = 1.0E-4f * (this.maxx - this.minx);
            return (int)(0.5 + (double)((this.maxx - this.minx) / this.mTickX));
        }

        public int paint(Graphics2D g, int w, int h, int[] ticks) {
            int draw_width = this.mCanvasWidth - this.ins_left - this.ins_right;
            float e = 1.0E-4f * (this.maxx - this.minx);
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int text_height = fm.getHeight();
            int top = text_height / 2;
            int tcount = 0;
            for (float i2 = this.minx; i2 <= this.maxx + e; i2 += this.mTickX) {
                int ix = (int)((float)draw_width * (i2 - this.minx) / (this.maxx - this.minx) + (float)this.ins_left);
                ticks[tcount++] = ix;
                g.drawLine(ix, top + text_height, ix, h - this.ins_botom);
                String str = this.df.format(i2);
                int sw = fm.stringWidth(str) / 2;
                if (i2 == 0.0f) {
                    str = "%" + str;
                }
                g.drawString(str, ix - sw, ascent + top);
            }
            return tcount;
        }

        static double frac(double x) {
            return x - Math.floor(x);
        }
    }
}

