/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public class TimeLineRows
extends JPanel
implements Gantt.ChartElement {
    private static final boolean DEBUG = false;
    private static final boolean SIMPLE = false;
    Color myBackground = Chart.ourAvgBackground;
    Chart myChart;
    int[] myXPoints = new int[10];
    int[] myYPoints = new int[10];
    ArrayList<ViewRow> myViewRows = new ArrayList();
    public static int ourDiamondSize = JBUI.scale((int)10);
    private boolean myInStateChange;
    private boolean myDisplayInstructions = true;
    static int ourBaseSelected = Chart.ourMySelectedLineColor.getRGB() & 0xFFFFFF | 0x77000000;
    static Color ourTransparent = new Color(ourBaseSelected & 0xFFFFFF, true);
    static Color ourLightColor = new Color(ourBaseSelected, true);
    JComponent mySpacer = new JComponent(){};

    TimeLineRows(Chart chart) {
        VerticalFlowLayout layout2 = new VerticalFlowLayout(0, 0, 0, true, false);
        this.setLayout((LayoutManager)layout2);
        layout2.setHorizontalFill(true);
        layout2.setVerticalFill(false);
        this.myChart = chart;
        this.update(Gantt.ChartElement.Reason.CONSTRUCTION);
        this.myChart.add(this);
    }

    @Override
    public void update(Gantt.ChartElement.Reason reason) {
        if (reason == Gantt.ChartElement.Reason.SELECTION_CHANGED) {
            this.repaint();
            return;
        }
        if (reason == Gantt.ChartElement.Reason.CURSOR_POSITION_CHANGED) {
            this.repaint();
            return;
        }
        if (reason == Gantt.ChartElement.Reason.RESIZE || reason == Gantt.ChartElement.Reason.ZOOM || reason == Gantt.ChartElement.Reason.ADDVIEW) {
            Dimension d = this.getPreferredSize();
            d.width = this.myChart.getGraphWidth();
            if (this.myChart.getmNumberOfViews() > 0) {
                Gantt.ViewElement v = this.myChart.myViewElements.get(this.myChart.getmNumberOfViews() - 1);
                d.height = v.myYStart + v.myHeight + 1;
            }
            if (reason != Gantt.ChartElement.Reason.ADDVIEW && this.myViewRows.size() == this.myChart.myViewElements.size()) {
                int chartWidth = this.myChart.getGraphWidth();
                for (ViewRow row : this.myViewRows) {
                    int pos = row.myRow;
                    Gantt.ViewElement v = this.myChart.myViewElements.get(pos);
                    Dimension dimension2 = row.getPreferredSize();
                    if (dimension2.width == chartWidth && dimension2.height == v.myHeight) continue;
                    row.setPreferredSize(new Dimension(chartWidth, v.myHeight));
                }
                this.revalidate();
                this.repaint();
            } else {
                for (ViewRow row : this.myViewRows) {
                    this.remove(row);
                }
                this.myViewRows.clear();
                this.remove(this.mySpacer);
                int chartWidth = this.myChart.getGraphWidth();
                for (int i2 = 0; i2 < this.myChart.myViewElements.size(); ++i2) {
                    Gantt.ViewElement v = this.myChart.myViewElements.get(i2);
                    ViewRow vr = new ViewRow(v, i2);
                    this.myViewRows.add(vr);
                    vr.setPreferredSize(new Dimension(chartWidth, v.myHeight));
                    this.add(vr);
                }
                this.myDisplayInstructions = false;
                if (this.myChart != null && this.myChart.myModel != null && (this.myChart.myModel.getStartConstraintSet() == null || this.myChart.myModel.getEndConstraintSet() == null || this.myChart.myModel.getStartConstraintSet().myConstraintViews.isEmpty() || this.myChart.myModel.getEndConstraintSet().myConstraintViews.isEmpty())) {
                    this.myDisplayInstructions = true;
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!Float.isNaN(this.myChart.getTimeCursorMs())) {
            int x = this.myChart.getCursorPosition();
            g.setColor(Chart.getColorForPosition(this.myChart.getFramePosition()));
            g.fillRect(x, 0, 1, this.getHeight());
        }
        if (this.myDisplayInstructions) {
            g.setColor(Chart.myGridColor);
            int w = this.getWidth();
            int h = this.getHeight();
            String str = "Please add Constraints at 0% and 100%";
            Rectangle2D b = g.getFontMetrics().getStringBounds(str, g);
            g.drawString(str, (w - (int)b.getWidth()) / 2, (h - (int)b.getHeight()) / 2);
        }
    }

    private void paintBorder(Graphics g, int width, int height) {
        g.setColor(this.myBackground);
        g.fillRect(0, 0, width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.paintBorder(g, width, height);
    }

    class ViewRow
    extends JPanel {
        final Gantt.ViewElement myViewElement;
        KeyFrameTable myKeyFrameTable = new KeyFrameTable();
        ConstraintTable myConstraintTable = new ConstraintTable();
        CreateConstraintTable myCreateConstraintTable = new CreateConstraintTable();
        LayoutsSelectionTable myLayoutsSelectionTable = new LayoutsSelectionTable();
        int myRow;
        boolean myRowHasMarks = false;

        public ViewRow(Gantt.ViewElement v, int row) {
            this.myViewElement = v;
            this.myRow = row;
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        ViewRow.this.pop(e);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    ViewRow.this.mouseClick(e);
                }
            };
            this.addMouseMotionListener(ml);
            this.addMouseListener(ml);
        }

        public void pop(MouseEvent e) {
            int deleteIndex;
            int pasteIndex;
            int cutIndex;
            ArrayList<String> list = new ArrayList<String>();
            MotionSceneModel.KeyFrame keyFrame = (MotionSceneModel.KeyFrame)this.myKeyFrameTable.find(e.getX(), e.getY(), 20, TimeLineRows.this.myChart.mySelectedKeyFrameTag);
            int location = e.getX();
            int tmpPos = -1;
            int tmpAtt = -1;
            int tmpCyc = -1;
            if (keyFrame == null) {
                tmpPos = list.size();
                list.add("Create KeyPosition");
                tmpAtt = list.size();
                list.add("Create KeyAttribute");
                tmpCyc = list.size();
                list.add("Create KeyCycle");
            } else {
                switch (keyFrame.mType) {
                    case "KeyPosition": {
                        tmpPos = list.size();
                        list.add("Create KeyAttribute");
                        tmpCyc = list.size();
                        list.add("Create KeyCycle");
                        break;
                    }
                    case "KeyAttribute": {
                        tmpPos = list.size();
                        list.add("Create KeyPosition");
                        tmpCyc = list.size();
                        list.add("Create Cycle");
                        break;
                    }
                    case "KeyCycle": {
                        tmpPos = list.size();
                        list.add("Create KeyPosition");
                        tmpAtt = list.size();
                        list.add("Create KeyAttribute");
                    }
                }
            }
            int keyPositionIndex = tmpPos;
            int keyCycleIndex = tmpCyc;
            int keyAttributeIndex = tmpAtt;
            int copyIndex = keyFrame != null ? list.size() : -1;
            int n = cutIndex = keyFrame != null ? list.size() + 1 : -1;
            if (keyFrame != null) {
                list.add("copy");
                list.add("cut");
            }
            int n2 = pasteIndex = TimeLineRows.this.myChart.myCopyBuffer != null ? list.size() : -1;
            if (TimeLineRows.this.myChart.myCopyBuffer != null) {
                list.add("paste");
            }
            int n3 = deleteIndex = keyFrame != null ? list.size() : -1;
            if (keyFrame != null) {
                list.add("delete");
            }
            boolean noStartConstraints = TimeLineRows.this.myChart.myModel.getStartConstraintSet() == null || TimeLineRows.this.myChart.myModel.getStartConstraintSet().myConstraintViews.isEmpty();
            boolean noEndConstraints = TimeLineRows.this.myChart.myModel.getEndConstraintSet() == null || TimeLineRows.this.myChart.myModel.getEndConstraintSet().myConstraintViews.isEmpty();
            JBList displayedList = new JBList(list);
            JBPopupListener.Adapter listener2 = new JBPopupListener.Adapter((JList)displayedList, pasteIndex, location, deleteIndex, keyFrame, cutIndex, copyIndex, keyPositionIndex, keyAttributeIndex, keyCycleIndex){
                final /* synthetic */ JList val$displayedList;
                final /* synthetic */ int val$pasteIndex;
                final /* synthetic */ int val$location;
                final /* synthetic */ int val$deleteIndex;
                final /* synthetic */ MotionSceneModel.KeyFrame val$keyFrame;
                final /* synthetic */ int val$cutIndex;
                final /* synthetic */ int val$copyIndex;
                final /* synthetic */ int val$keyPositionIndex;
                final /* synthetic */ int val$keyAttributeIndex;
                final /* synthetic */ int val$keyCycleIndex;
                {
                    this.val$displayedList = jList;
                    this.val$pasteIndex = n;
                    this.val$location = n2;
                    this.val$deleteIndex = n3;
                    this.val$keyFrame = keyFrame;
                    this.val$cutIndex = n4;
                    this.val$copyIndex = n5;
                    this.val$keyPositionIndex = n6;
                    this.val$keyAttributeIndex = n7;
                    this.val$keyCycleIndex = n8;
                }

                public void onClosed(LightweightWindowEvent event) {
                    JBPopup popup2 = event.asPopup();
                    System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>.. " + event.isOk());
                    if (!event.isOk()) {
                        return;
                    }
                    int index = this.val$displayedList.getSelectedIndex();
                    System.out.println("displayedList.getSelectedIndex() " + index);
                    if (index == this.val$pasteIndex) {
                        ViewRow.this.paste(this.val$location);
                    } else if (index == this.val$deleteIndex) {
                        ViewRow.this.delete(this.val$keyFrame);
                    } else if (index == this.val$cutIndex) {
                        ViewRow.this.copy(this.val$keyFrame);
                        ViewRow.this.delete(this.val$keyFrame);
                    } else if (index == this.val$copyIndex) {
                        ViewRow.this.copy(this.val$keyFrame);
                    } else if (index == this.val$keyPositionIndex) {
                        ViewRow.this.createKeyFrame("KeyPosition", this.val$location);
                    } else if (index == this.val$keyAttributeIndex) {
                        ViewRow.this.createKeyFrame("KeyAttribute", this.val$location);
                    } else if (index == this.val$keyCycleIndex) {
                        ViewRow.this.createKeyFrame("KeyCycle", this.val$location);
                    }
                }
            };
            JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)displayedList).setTitle("KeyFrame").addListener((JBPopupListener)listener2).createPopup();
            JComponent component = (JComponent)e.getSource();
            popup2.show(new RelativePoint((Component)component, new Point(0, 0)));
        }

        public void copy(MotionSceneModel.KeyFrame key) {
            TimeLineRows.this.myChart.myCopyBuffer = key.cloneKeyFrame();
        }

        public void delete(MotionSceneModel.KeyFrame key) {
            key.deleteTag("delete tag");
        }

        public void paste(int location) {
            MotionSceneModel.KeyFrame key = TimeLineRows.this.myChart.myCopyBuffer.cloneKeyFrame();
            int width = this.getWidth() - TimeLineRows.this.myChart.myChartLeftInset - TimeLineRows.this.myChart.myChartRightInset;
            int framePosition = (location - TimeLineRows.this.myChart.myChartLeftInset) * 100 / width;
            this.myViewElement.mKeyFrames.myModel.createKeyFrame(key.mType, framePosition, this.myViewElement.myName, key);
        }

        void createKeyFrame(String frameType, int location) {
            String name = this.myViewElement.myName;
            MotionSceneModel model2 = this.myViewElement.mKeyFrames.myModel;
            int width = this.getWidth() - TimeLineRows.this.myChart.myChartLeftInset - TimeLineRows.this.myChart.myChartRightInset;
            int fpos = (location - TimeLineRows.this.myChart.myChartLeftInset) * 100 / width;
            if (fpos == 0) {
                fpos = 1;
            } else if (fpos == 100) {
                fpos = 99;
            }
            TimeLineRows.this.myChart.mySelectedKeyFrameTag = this.myViewElement.mKeyFrames.myModel.createKeyFrame(frameType, fpos, name);
            TimeLineRows.this.myChart.mySelectedKeyView = name;
        }

        private void mouseClick(MouseEvent e) {
            this.select(e.getX(), e.getY());
        }

        private void select(int x, int y) {
            MotionSceneModel.KeyFrame keyFrame = (MotionSceneModel.KeyFrame)this.myKeyFrameTable.find(x, y, 20, TimeLineRows.this.myChart.mySelectedKeyFrameTag);
            MotionSceneModel.ConstraintView constraint = (MotionSceneModel.ConstraintView)this.myConstraintTable.find(x, y, 20, TimeLineRows.this.myChart.mySelectedConstraintTag);
            CreateConstraint create2 = (CreateConstraint)this.myCreateConstraintTable.find(x, y, 20, TimeLineRows.this.myChart.mySelectedConstraintTag);
            CreateConstraint layout2 = (CreateConstraint)this.myLayoutsSelectionTable.find(x, y, 20, TimeLineRows.this.myChart.mySelectedConstraintTag);
            int width = this.getWidth() - TimeLineRows.this.myChart.myChartLeftInset - TimeLineRows.this.myChart.myChartRightInset;
            int framePosition = (x - TimeLineRows.this.myChart.myChartLeftInset) * 100 / width;
            framePosition = Math.max(0, Math.min(100, framePosition));
            if (constraint != TimeLineRows.this.myChart.mySelectedConstraint) {
                TimeLineRows.this.myChart.select(constraint);
                if (constraint != null) {
                    TimeLineRows.this.myChart.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
                    TimeLineRows.this.myChart.setCursorPosition((float)framePosition / 100.0f);
                    return;
                }
            }
            if (keyFrame != TimeLineRows.this.myChart.mySelectedKeyFrame) {
                TimeLineRows.this.myChart.select(keyFrame);
                if (keyFrame != null) {
                    TimeLineRows.this.myChart.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
                    TimeLineRows.this.myChart.setCursorPosition((float)keyFrame.framePosition / 100.0f);
                    return;
                }
            } else if (keyFrame != null) {
                TimeLineRows.this.myChart.setCursorPosition((float)keyFrame.framePosition / 100.0f);
            }
            if (create2 != null) {
                TimeLineRows.this.myChart.myModel.createConstraint(create2.getName(), create2.isStart());
                TimeLineRows.this.myChart.setCursorPosition((float)framePosition / 100.0f);
                return;
            }
            if (layout2 != null) {
                TimeLineRows.this.myChart.selectView(layout2.getName());
                TimeLineRows.this.myChart.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
                TimeLineRows.this.myChart.update(Gantt.ChartElement.Reason.CURSOR_POSITION_CHANGED);
                return;
            }
        }

        public void drawBowtie(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos + half - 1;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos;
            TimeLineRows.this.myXPoints[2] = x + half;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[3] = x;
            TimeLineRows.this.myYPoints[3] = pos + half + 1;
            TimeLineRows.this.myXPoints[4] = x - half;
            TimeLineRows.this.myYPoints[4] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[5] = x - half;
            TimeLineRows.this.myYPoints[5] = pos;
            g.drawPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 6);
        }

        public void drawDiamond(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos + half;
            TimeLineRows.this.myXPoints[2] = x;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[3] = x - half;
            TimeLineRows.this.myYPoints[3] = pos + half;
            if (selected) {
                g.drawPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 4);
            } else {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 4);
            }
        }

        public void drawCircle(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            if (selected) {
                g.drawRoundRect(x - half, pos, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            } else {
                g.fillRoundRect(x - half, pos, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            }
        }

        public void drawTriangle(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[2] = x - half;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            if (selected) {
                g.drawPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 3);
            } else {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 3);
            }
        }

        public void drawBase(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            Color orig = g.getColor();
            if (selected) {
                g.setColor(Chart.ourMySelectedLineColor);
                g.drawRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            } else {
                g.drawRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            }
            g.setColor(orig);
        }

        public void drawGroup(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[2] = x - half;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            if (selected) {
                g.drawPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 3);
            } else {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 3);
            }
        }

        public void drawPentagon(Graphics g, boolean selected, int x, int pos, int lines) {
            int half = ourDiamondSize / 2;
            int sixth = ourDiamondSize / 5;
            int quarter = ourDiamondSize / 4;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos - half;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos;
            TimeLineRows.this.myXPoints[2] = x + sixth;
            TimeLineRows.this.myYPoints[2] = pos + half;
            TimeLineRows.this.myXPoints[3] = x - sixth;
            TimeLineRows.this.myYPoints[3] = pos + half;
            TimeLineRows.this.myXPoints[4] = x - half;
            TimeLineRows.this.myYPoints[4] = pos;
            if (selected) {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 5);
            } else {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 5);
            }
            Color c = g.getColor();
            g.setColor(Color.GRAY);
            if ((lines & 1) != 0) {
                g.drawLine(x - quarter + 2, pos - half + quarter + 1, x + quarter - 3, pos - half + quarter + 1);
            }
            if ((lines & 2) != 0) {
                g.drawLine(x - half + 2, pos, x + half - 3, pos);
            }
            if ((lines & 4) != 0) {
                g.drawLine(x - quarter + 2, pos + half - quarter - 1, x + quarter - 3, pos + half - quarter - 1);
            }
            g.setColor(c);
        }

        public void drawStartConstraint(Graphics g, Color selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            int inset = ourDiamondSize / 3;
            TimeLineRows.this.myXPoints[0] = x - half;
            TimeLineRows.this.myYPoints[0] = pos - half;
            TimeLineRows.this.myXPoints[1] = x;
            TimeLineRows.this.myYPoints[1] = pos - half;
            TimeLineRows.this.myXPoints[2] = x + half;
            TimeLineRows.this.myYPoints[2] = pos;
            TimeLineRows.this.myXPoints[3] = x + half;
            TimeLineRows.this.myYPoints[3] = pos + half;
            TimeLineRows.this.myXPoints[4] = x - half;
            TimeLineRows.this.myYPoints[4] = pos + half;
            g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 5);
            Color c = g.getColor();
            if (selected != null) {
                g.setColor(selected);
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 5);
            }
            TimeLineRows.this.myXPoints[0] = x - half + inset;
            TimeLineRows.this.myYPoints[0] = pos - half + inset;
            TimeLineRows.this.myXPoints[1] = x + half - inset;
            TimeLineRows.this.myYPoints[1] = pos;
            TimeLineRows.this.myXPoints[2] = x - half + inset;
            TimeLineRows.this.myYPoints[2] = pos + half - inset;
            g.setColor(Color.WHITE);
            g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 3);
            g.setColor(c);
        }

        public void drawAddConstraint(Graphics g, int x, int pos) {
            Color c = g.getColor();
            int half = ourDiamondSize / 2;
            int inset = ourDiamondSize / 8;
            g.setColor(Chart.ourAddConstraintColor);
            g.fillRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            g.setColor(Chart.ourAddConstraintPlus);
            g.fillRect(x - inset, pos - half + inset, inset * 2, ourDiamondSize - inset * 2);
            g.fillRect(x - half + inset, pos - inset, ourDiamondSize - inset * 2, inset * 2);
            g.setColor(c);
        }

        public void drawEndConstraint(Graphics g, Color selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            int inset = ourDiamondSize / 3;
            TimeLineRows.this.myXPoints[0] = x - half;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x;
            TimeLineRows.this.myYPoints[1] = pos - half;
            TimeLineRows.this.myXPoints[2] = x + half;
            TimeLineRows.this.myYPoints[2] = pos - half;
            TimeLineRows.this.myXPoints[3] = x + half;
            TimeLineRows.this.myYPoints[3] = pos + half;
            TimeLineRows.this.myXPoints[4] = x - half;
            TimeLineRows.this.myYPoints[4] = pos + half;
            g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 5);
            Color c = g.getColor();
            if (selected != null) {
                g.setColor(selected);
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 5);
            }
            TimeLineRows.this.myXPoints[0] = x - half + inset;
            TimeLineRows.this.myYPoints[0] = pos - half + inset;
            TimeLineRows.this.myXPoints[1] = x + half - inset;
            TimeLineRows.this.myYPoints[1] = TimeLineRows.this.myYPoints[0];
            TimeLineRows.this.myXPoints[2] = TimeLineRows.this.myXPoints[1];
            TimeLineRows.this.myYPoints[2] = pos + half - inset;
            TimeLineRows.this.myXPoints[3] = TimeLineRows.this.myXPoints[0];
            TimeLineRows.this.myYPoints[3] = TimeLineRows.this.myYPoints[2];
            if (selected != null) {
                g.setColor(selected);
                g.drawRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            }
            g.setColor(Color.WHITE);
            g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 4);
            g.setColor(c);
        }

        public void drawSquare(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos + half;
            TimeLineRows.this.myXPoints[2] = x;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[3] = x - half;
            TimeLineRows.this.myYPoints[3] = pos + half;
            if (selected) {
                g.drawRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, 2, 2);
            } else {
                g.fillRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, 2, 2);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.myRow % 2 == 0 ? Chart.ourPrimaryPanelBackground : Chart.ourSecondaryPanelBackground);
            this.myKeyFrameTable.clear();
            this.myConstraintTable.clear();
            this.myCreateConstraintTable.clear();
            this.myLayoutsSelectionTable.clear();
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.myRow % 2 == 1 ? Chart.ourPrimaryPanelBackground : Chart.ourSecondaryPanelBackground);
            g.setColor(Chart.ourBorder);
            for (int i2 = 0; i2 < TimeLineRows.this.myChart.myXTickCount; ++i2) {
                int xLines = TimeLineRows.this.myChart.myXTicksPixels[i2];
                g.fillRect(xLines, 0, 1, panelHeight);
            }
            boolean DRAW_RECTS = false;
            g.setColor(Color.GRAY);
            int y = 0;
            this.myRowHasMarks = false;
            y += this.myViewElement.myHeightView;
            if (this.myViewElement.myHeightPosition > 0) {
                y += this.myViewElement.myHeightPosition;
            }
            if (this.myViewElement.myHeightAttribute > 0) {
                y += this.myViewElement.myHeightAttribute;
            }
            if (this.myViewElement.myHeightCycle > 0) {
                y += this.myViewElement.myHeightCycle;
            }
            Graphics2D g2d = (Graphics2D)g;
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f, 1, 1));
            int half = ourDiamondSize / 2;
            int pos = 2;
            if (TimeLineRows.this.myChart != null) {
                int x;
                Object marked;
                boolean selected;
                int xpos;
                MotionSceneModel.ConstraintView constraint;
                int width = this.getWidth() - TimeLineRows.this.myChart.myChartLeftInset - TimeLineRows.this.myChart.myChartRightInset;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int xp = JBUI.scale((int)10);
                int yp = pos + ourDiamondSize;
                this.myLayoutsSelectionTable.add(xp, yp, this.myViewElement.myName);
                boolean viewSelected = TimeLineRows.this.myChart.mySelection == Chart.Selection.VIEW && this.myViewElement.myName.equals(TimeLineRows.this.myChart.mySelectedKeyView);
                this.drawBase(g, viewSelected, xp, yp);
                g.setColor(Chart.myUnSelectedLineColor);
                if (TimeLineRows.this.myChart.myModel != null && TimeLineRows.this.myChart.myModel.getStartConstraintSet() != null && TimeLineRows.this.myChart.myModel.getStartConstraintSet().myConstraintViews != null) {
                    constraint = TimeLineRows.this.myChart.myModel.getStartConstraintSet().myConstraintViews.get(this.myViewElement.myName);
                    xpos = TimeLineRows.this.myChart.myChartLeftInset + 0 * width / 100;
                    if (constraint != null) {
                        selected = TimeLineRows.this.myChart.mySelectedConstraint == constraint;
                        this.myConstraintTable.add(xpos - ourDiamondSize, pos + ourDiamondSize, constraint);
                        this.drawStartConstraint(g, selected ? Chart.ourMySelectedLineColor : null, xpos - ourDiamondSize, pos + ourDiamondSize);
                        this.myRowHasMarks = true;
                    } else {
                        this.drawAddConstraint(g, xpos - ourDiamondSize, pos + ourDiamondSize);
                        this.myCreateConstraintTable.add(xpos - ourDiamondSize, pos + ourDiamondSize, this.myViewElement.myName, true);
                    }
                }
                if (TimeLineRows.this.myChart.myModel != null && TimeLineRows.this.myChart.myModel.getEndConstraintSet() != null && TimeLineRows.this.myChart.myModel.getEndConstraintSet().myConstraintViews != null) {
                    constraint = TimeLineRows.this.myChart.myModel.getEndConstraintSet().myConstraintViews.get(this.myViewElement.myName);
                    xpos = TimeLineRows.this.myChart.myChartLeftInset + 100 * width / 100;
                    if (constraint != null) {
                        this.myConstraintTable.add(xpos + ourDiamondSize, pos + ourDiamondSize, constraint);
                        selected = TimeLineRows.this.myChart.mySelectedConstraint == constraint;
                        this.drawEndConstraint(g, selected ? Chart.ourMySelectedLineColor : null, xpos + ourDiamondSize, pos + ourDiamondSize);
                        this.myRowHasMarks = true;
                    } else {
                        this.drawAddConstraint(g, xpos + ourDiamondSize, pos + ourDiamondSize);
                        this.myCreateConstraintTable.add(xpos + ourDiamondSize, pos + ourDiamondSize, this.myViewElement.myName, false);
                    }
                }
                this.myRowHasMarks |= !this.myViewElement.mKeyFrames.myKeyAttributes.isEmpty();
                this.myRowHasMarks |= !this.myViewElement.mKeyFrames.myKeyCycles.isEmpty();
                this.myRowHasMarks |= !this.myViewElement.mKeyFrames.myKeyPositions.isEmpty();
                if (this.myViewElement.myHeightPosition == 0 && this.myViewElement.myHeightCycle == 0 && this.myViewElement.myHeightAttribute == 0) {
                    marked = new int[101];
                    for (MotionSceneModel.KeyPos key : this.myViewElement.mKeyFrames.myKeyPositions) {
                        marked[key.framePosition] = true;
                    }
                    for (MotionSceneModel.KeyAttributes key : this.myViewElement.mKeyFrames.myKeyAttributes) {
                        Object object = marked;
                        int n = key.framePosition;
                        object[n] = object[n] | 2;
                    }
                    for (MotionSceneModel.KeyCycle key : this.myViewElement.mKeyFrames.myKeyCycles) {
                        Object object = marked;
                        int n = key.framePosition;
                        object[n] = object[n] | 4;
                    }
                    pos = (this.myViewElement.myHeightView - ourDiamondSize) / 2 + 3;
                    for (int i3 = 0; i3 < ((Object)marked).length; ++i3) {
                        Object mark = marked[i3];
                        if (mark == false) continue;
                        int x2 = TimeLineRows.this.myChart.myChartLeftInset + i3 * width / 100;
                        this.drawPentagon(g, true, x2, pos, (int)mark);
                    }
                    return;
                }
                pos = this.myViewElement.myHeightPosition > 0 ? this.myViewElement.myHeightView + (this.myViewElement.myHeightPosition - ourDiamondSize) / 2 : (this.myViewElement.myHeightView - ourDiamondSize) / 2;
                marked = this.myViewElement.mKeyFrames.myKeyPositions.iterator();
                while (marked.hasNext()) {
                    MotionSceneModel.KeyPos key = (MotionSceneModel.KeyPos)marked.next();
                    int x3 = TimeLineRows.this.myChart.myChartLeftInset + key.framePosition * width / 100;
                    if (key == TimeLineRows.this.myChart.mySelectedKeyFrame) {
                        g.setColor(Chart.ourMySelectedLineColor);
                        this.drawDiamond(g, true, x3, pos);
                        g.setColor(Chart.myUnSelectedLineColor);
                    } else {
                        this.drawDiamond(g, false, x3, pos);
                    }
                    this.myKeyFrameTable.add(x3, pos + half, key);
                }
                int delta_y = (this.getHeight() - ourDiamondSize) / 4;
                if (this.myViewElement.myHeightAttribute > 0) {
                    pos = this.myViewElement.myHeightView + this.myViewElement.myHeightPosition;
                    pos += (this.myViewElement.myHeightAttribute - ourDiamondSize) / 2;
                } else {
                    pos += delta_y;
                }
                for (MotionSceneModel.KeyAttributes key : this.myViewElement.mKeyFrames.myKeyAttributes) {
                    x = TimeLineRows.this.myChart.myChartLeftInset + key.framePosition * width / 100;
                    if (key == TimeLineRows.this.myChart.mySelectedKeyFrame) {
                        g.setColor(Chart.ourMySelectedLineColor);
                        this.drawTriangle(g, true, x, pos);
                        g.setColor(Chart.myUnSelectedLineColor);
                    } else {
                        this.drawTriangle(g, false, x, pos);
                    }
                    this.myKeyFrameTable.add(x, pos + half, key);
                }
                if (this.myViewElement.myHeightCycle > 0) {
                    pos = this.myViewElement.myHeightView + this.myViewElement.myHeightPosition + this.myViewElement.myHeightAttribute;
                    pos += (this.myViewElement.myHeightCycle - ourDiamondSize) / 2;
                } else {
                    pos += delta_y;
                }
                for (MotionSceneModel.KeyCycle key : this.myViewElement.mKeyFrames.myKeyCycles) {
                    x = TimeLineRows.this.myChart.myChartLeftInset + key.framePosition * width / 100;
                    if (key == TimeLineRows.this.myChart.mySelectedKeyFrame) {
                        g.setColor(Chart.ourMySelectedLineColor);
                        this.drawBowtie(g, true, x, pos);
                        g.setColor(Chart.myUnSelectedLineColor);
                    } else {
                        this.drawBowtie(g, false, x, pos);
                    }
                    this.myKeyFrameTable.add(x, pos + half, key);
                }
            }
        }
    }

    static class CreateConstraintTable
    extends BaseTable<CreateConstraint> {
        ArrayList<CreateConstraint> pool = new ArrayList();
        ArrayList<CreateConstraint> inUse = new ArrayList();

        CreateConstraintTable() {
        }

        @Override
        public void clear() {
            super.clear();
            this.pool.addAll(this.inUse);
            this.inUse.clear();
        }

        public CreateConstraint get(String name, boolean isStart) {
            CreateConstraint ret = this.pool.remove(0);
            ret.myName = name;
            ret.myStart = isStart;
            return ret;
        }

        void add(int x, int y, String name, boolean isStart) {
            CreateConstraint create2 = this.pool.isEmpty() ? new CreateConstraint(name, isStart) : this.get(name, isStart);
            this.inUse.add(create2);
            super.add(x, y, create2);
        }
    }

    static class LayoutsSelectionTable
    extends BaseTable<CreateConstraint> {
        ArrayList<CreateConstraint> pool = new ArrayList();
        ArrayList<CreateConstraint> inUse = new ArrayList();

        LayoutsSelectionTable() {
        }

        @Override
        public void clear() {
            super.clear();
            this.pool.addAll(this.inUse);
            this.inUse.clear();
        }

        public CreateConstraint get(String name, boolean isStart) {
            CreateConstraint ret = this.pool.remove(0);
            ret.myName = name;
            ret.myStart = isStart;
            return ret;
        }

        @Override
        void add(int x, int y, String name) {
            CreateConstraint create2 = this.pool.isEmpty() ? new CreateConstraint(name, false) : this.get(name, false);
            this.inUse.add(create2);
            super.add(x, y, create2);
        }
    }

    static class CreateConstraint
    implements MotionSceneModel.TagAccess {
        String myName;
        boolean myStart;

        static CreateConstraint get(String name, boolean start) {
            return new CreateConstraint(name, start);
        }

        private CreateConstraint(String name, boolean start) {
            this.myName = name;
            this.myStart = start;
        }

        String getName() {
            return this.myName;
        }

        boolean isStart() {
            return this.myStart;
        }

        @Override
        public SmartPsiElementPointer<XmlTag> getTag() {
            return null;
        }
    }

    static class ConstraintTable
    extends BaseTable<MotionSceneModel.ConstraintView> {
        ConstraintTable() {
        }
    }

    static class KeyFrameTable
    extends BaseTable<MotionSceneModel.KeyFrame> {
        KeyFrameTable() {
        }
    }

    static class BaseTable<T extends MotionSceneModel.TagAccess> {
        int max = 5;
        int maxSq = this.max * this.max;
        int[] location = new int[this.max * 2];
        ArrayList<T> keyFrames = new ArrayList(this.max);
        int addPoint = 0;

        BaseTable() {
        }

        public void clear() {
            this.addPoint = 0;
            this.keyFrames.clear();
        }

        void add(int x, int y, T keyFrame) {
            if (this.max == this.addPoint) {
                this.max *= 2;
                this.location = Arrays.copyOf(this.location, this.max * 2);
            }
            this.location[this.addPoint * 2] = x;
            this.location[this.addPoint * 2 + 1] = y;
            this.keyFrames.add(this.addPoint, keyFrame);
            ++this.addPoint;
        }

        T find(int x, int y, int max, SmartPsiElementPointer<XmlTag> previousKeyFrameTag) {
            int closeSq = Integer.MAX_VALUE;
            ArrayList<T> possibleFrames = new ArrayList<T>();
            for (int i2 = 0; i2 < this.keyFrames.size(); ++i2) {
                int kf_x = this.location[i2 * 2];
                int kf_y = this.location[i2 * 2 + 1];
                int dx = Math.abs(kf_x - x);
                if ((dx *= dx) > this.maxSq) continue;
                int dy = Math.abs(kf_y - y);
                if ((dy *= dy) > this.maxSq || closeSq < dy + dx || possibleFrames.contains(this.keyFrames.get(i2))) continue;
                possibleFrames.add(this.keyFrames.get(i2));
                closeSq = dy + dx;
            }
            if (possibleFrames.isEmpty()) {
                return null;
            }
            int foundIndex = -1;
            for (int i3 = 0; i3 < possibleFrames.size(); ++i3) {
                if (((MotionSceneModel.TagAccess)possibleFrames.get(i3)).getTag() != previousKeyFrameTag) continue;
                foundIndex = i3;
                break;
            }
            int nextIndex = (foundIndex + 1) % possibleFrames.size();
            return (T)((MotionSceneModel.TagAccess)possibleFrames.get(nextIndex));
        }
    }
}

