/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttController;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.NotNull;

public class TrackControls
extends JPanel {
    private final Chart mChart;
    JButton myCircle = new CommonButton(TimeLineIcons.SLOW_MOTION);
    JButton myPrevKeyFrame = new CommonButton(TimeLineIcons.BACKWARD);
    JButton myPlayButton = new CommonButton(TimeLineIcons.PLAY);
    JButton myNextKeyFrame = new CommonButton(TimeLineIcons.FORWARD);
    JButton myLoop = new CommonButton(TimeLineIcons.LOOP);
    public static final int NO_OF_BUTTONS = 5;
    JButton[] myButtons = new JButton[]{this.myCircle, this.myPrevKeyFrame, this.myPlayButton, this.myNextKeyFrame, this.myLoop};
    static GanttEventListener.Actions[] actions = new GanttEventListener.Actions[]{GanttEventListener.Actions.SLOW_MOTION, GanttEventListener.Actions.START_ACTION, GanttEventListener.Actions.PLAY_ACTION, GanttEventListener.Actions.END_ACTION, GanttEventListener.Actions.LOOP_ACTION};
    private GanttController myGanttInterface;
    ButtonUI mButtonUI = new BasicButtonUI();

    TrackControls(Chart chart) {
        super(new GridLayout(1, 5, 0, 0));
        this.mChart = chart;
        this.setPreferredSize(new Dimension(Chart.ourViewListWidth, Gantt.HEADER_HEIGHT));
        this.mChart.add(new Gantt.ChartElement(){

            @Override
            public void update(Gantt.ChartElement.Reason reason) {
                block0 : switch (reason) {
                    case MODE_CHANGE: {
                        switch (TrackControls.this.mChart.getMode()) {
                            case PLAY: {
                                TrackControls.this.myPlayButton.setIcon(TimeLineIcons.PAUSE);
                                break block0;
                            }
                            case PAUSE: 
                            case TRANSITION: {
                                TrackControls.this.myPlayButton.setIcon(TimeLineIcons.PLAY);
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }

            @Override
            public void repaint() {
            }

            @Override
            public void invalidate() {
            }
        });
        Font f = this.myButtons[0].getFont().deriveFont(10.0f);
        for (int i2 = 0; i2 < this.myButtons.length; ++i2) {
            final GanttEventListener.Actions action2 = actions[i2];
            JButton button2 = this.myButtons[i2];
            button2.setFont(f);
            this.add(button2);
            button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackControls.this.buttonPressed(e, action2);
                }
            });
        }
        this.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)1, (int)1));
    }

    private void buttonPressed(ActionEvent e, GanttEventListener.Actions action2) {
        if (action2 == GanttEventListener.Actions.SLOW_MOTION) {
            this.popupSlowSpee(e, action2);
        }
        if (this.myGanttInterface != null) {
            this.myGanttInterface.buttonPressed(e, action2);
        }
    }

    private void popupSlowSpee(ActionEvent e, GanttEventListener.Actions action2) {
        Object[] list = new String[]{"0.25 x", "0.5 x", "1 x", "2 x", "4 x"};
        final float[] speed = new float[]{0.25f, 0.5f, 1.0f, 2.0f, 4.0f};
        JBList displayedList = new JBList(list);
        JBPopupListener.Adapter listener2 = new JBPopupListener.Adapter((JList)displayedList, e, action2){
            final /* synthetic */ JList val$displayedList;
            final /* synthetic */ ActionEvent val$e;
            final /* synthetic */ GanttEventListener.Actions val$action;
            {
                this.val$displayedList = jList;
                this.val$e = actionEvent;
                this.val$action = actions2;
            }

            public void onClosed(LightweightWindowEvent event) {
                JBPopup popup2 = event.asPopup();
                ((TrackControls)TrackControls.this).mChart.myPlayBackSpeed = speed[this.val$displayedList.getLeadSelectionIndex()];
                TrackControls.this.myGanttInterface.buttonPressed(this.val$e, this.val$action);
            }
        };
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)displayedList).setTitle("Speed").addListener((JBPopupListener)listener2).createPopup();
        JComponent component = (JComponent)e.getSource();
        popup2.show(new RelativePoint((Component)component, new Point(0, 0)));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myButtons == null) {
            return;
        }
        for (int i2 = 0; i2 < this.myButtons.length; ++i2) {
            JButton button2 = this.myButtons[i2];
            button2.setBackground(bg);
        }
    }

    void setGantt(@NotNull GanttController gantt) {
        this.myGanttInterface = gantt;
    }
}

