/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.uibuilder.handlers.motion.AttrName;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ViewList
extends JPanel
implements Gantt.ChartElement {
    DefaultMutableTreeNode myRootNode = new DefaultMutableTreeNode();
    JTree myTree = new Tree((TreeNode)this.myRootNode);
    Chart myChart;
    boolean myInternal;
    private boolean myIgnoreTreeSelections;
    private static boolean USER_STUDY = true;
    private static final Icon mySpacerIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)0, (int)0));
    JPanel myAddPanel = new JPanel(null){

        @Override
        public void doLayout() {
            if (ViewList.this.mySelectedView == null) {
                ViewList.this.myAddButton.setVisible(false);
            } else {
                ViewList.this.myAddButton.setVisible(true);
                ViewList.this.myAddButton.setLocation(0, ((ViewList)ViewList.this).mySelectedView.getViewElement().myYStart);
                ViewList.this.myAddButton.setSize(16, 16);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    };
    JButton myAddButton = new JButton(TimeLineIcons.ADD_KEYFRAME);
    private ViewNode mySelectedView;
    TreeCellRenderer cellRenderer = new MyDefaultTreeCellRenderer();

    ViewList(Chart chart) {
        super(new BorderLayout(2, 2));
        this.myChart = chart;
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer(this.cellRenderer);
        this.update(Gantt.ChartElement.Reason.CONSTRUCTION);
        this.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)0, (int)1));
        this.myChart.add(this);
        this.myAddPanel.add(this.myAddButton);
        this.myAddButton.setUI(new BasicButtonUI());
        this.myAddButton.setMargin(null);
        this.myAddButton.setBorderPainted(false);
        this.myAddButton.setOpaque(false);
        this.myAddButton.addActionListener(e -> this.keyFramePopup(e));
        this.myAddPanel.setPreferredSize(new Dimension(16, 20));
        this.add((Component)this.myTree, "Center");
        this.add((Component)this.myAddPanel, "East");
        JPanel space = new JPanel();
        space.setPreferredSize(new Dimension(Chart.ourViewListWidth, 0));
        this.add((Component)space, "North");
        this.myTree.setUI(new CustomTreeUI());
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ViewList.this.myInternal = true;
                if (event.getPath().getPathCount() == 3) {
                    CategoryNode categoryNode = (CategoryNode)event.getPath().getPathComponent(2);
                }
                ViewList.this.myChart.update(Gantt.ChartElement.Reason.RESIZE);
                ViewList.this.myInternal = false;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                ViewList.this.myInternal = true;
                ViewList.this.myChart.update(Gantt.ChartElement.Reason.RESIZE);
                ViewList.this.myInternal = false;
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ViewList.this.myInternal = true;
                ViewList.this.treeSelection(e);
                ViewList.this.myInternal = false;
            }
        });
    }

    private void keyFramePopup(ActionEvent e) {
        Object[] list = new String[]{"Position", "Attributes", "Cycles"};
        if (this.myChart != null && this.myChart.myModel != null) {
            boolean noEndConstraints;
            boolean noStartConstraints = this.myChart.myModel.getStartConstraintSet() == null || this.myChart.myModel.getStartConstraintSet().myConstraintViews.isEmpty();
            boolean bl = noEndConstraints = this.myChart.myModel.getEndConstraintSet() == null || this.myChart.myModel.getEndConstraintSet().myConstraintViews.isEmpty();
            if (noStartConstraints && noEndConstraints) {
                list = new String[]{"set Start Constraint", "set End Constraint"};
            } else if (noStartConstraints) {
                list = new String[]{"set Start Constraint"};
            } else if (noEndConstraints) {
                list = new String[]{"set End Constraint"};
            }
        }
        JBList displayedList = new JBList(list);
        JBPopupListener.Adapter listener2 = new JBPopupListener.Adapter((JList)displayedList){
            final /* synthetic */ JList val$displayedList;
            {
                this.val$displayedList = jList;
            }

            public void onClosed(LightweightWindowEvent event) {
                JBPopup popup2 = event.asPopup();
                boolean noStartConstraints = ViewList.this.myChart.myModel.getStartConstraintSet() == null || ViewList.this.myChart.myModel.getStartConstraintSet().myConstraintViews.isEmpty();
                boolean noEndConstraints = ViewList.this.myChart.myModel.getEndConstraintSet() == null || ViewList.this.myChart.myModel.getEndConstraintSet().myConstraintViews.isEmpty();
                Gantt.ViewElement v = ViewList.this.mySelectedView.getViewElement();
                String name = v.myName;
                if (noStartConstraints && noEndConstraints) {
                    if (this.val$displayedList.getSelectedIndex() == 0) {
                        ViewList.this.myChart.myModel.createConstraint(name, true);
                        ViewList.this.myChart.setCursorPosition(0.0f);
                    } else {
                        ViewList.this.myChart.myModel.createConstraint(name, false);
                        ViewList.this.myChart.setCursorPosition(1.0f);
                    }
                } else if (noStartConstraints) {
                    ViewList.this.myChart.myModel.createConstraint(name, true);
                    ViewList.this.myChart.setCursorPosition(0.0f);
                } else if (noEndConstraints) {
                    ViewList.this.myChart.myModel.createConstraint(name, false);
                    ViewList.this.myChart.setCursorPosition(1.0f);
                } else {
                    ViewList.this.createKeyFrame(this.val$displayedList.getSelectedIndex());
                }
            }
        };
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)displayedList).setTitle("Create KeyFrame").addListener((JBPopupListener)listener2).createPopup();
        JComponent component = (JComponent)e.getSource();
        popup2.show(new RelativePoint((Component)component, new Point(0, 0)));
    }

    void createKeyFrame(int frameType) {
        Gantt.ViewElement v = this.mySelectedView.getViewElement();
        String name = v.myName;
        MotionSceneModel model2 = v.mKeyFrames.myModel;
        int fpos = (int)(this.myChart.getTimeCursorMs() * 100.0f / (float)this.myChart.myAnimationTotalTimeMs);
        if (fpos == 0) {
            fpos = 1;
        } else if (fpos == 100) {
            fpos = 99;
        }
        String type = (new String[]{"KeyPosition", "KeyAttribute", "KeyCycle"})[frameType];
        this.myChart.mySelectedKeyFrameTag = v.mKeyFrames.myModel.createKeyFrame(type, fpos, name);
        this.myChart.mySelectedKeyView = name;
    }

    void treeSelection(TreeSelectionEvent e) {
        if (this.myIgnoreTreeSelections) {
            return;
        }
        this.mySelectedView = null;
        if (e.getPath().getPath().length > 1) {
            this.mySelectedView = (ViewNode)e.getPath().getPath()[1];
            this.myChart.mySelectedKeyView = e.getPath().getPath()[1].toString();
            this.myChart.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
        }
        this.myAddPanel.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSelection(@NotNull List<String> ids) {
        this.myIgnoreTreeSelections = true;
        try {
            TreeSelectionModel model2 = this.myTree.getSelectionModel();
            model2.clearSelection();
            for (String id : ids) {
                ViewNode node = this.getViewNode(id);
                if (node == null) continue;
                model2.addSelectionPath(TreePathUtil.convertArrayToTreePath((Object[])new DefaultMutableTreeNode[]{this.myRootNode, node}));
            }
            this.myChart.mySelectedKeyView = ids.isEmpty() ? null : ids.get(0);
            this.myChart.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
        }
        finally {
            this.myIgnoreTreeSelections = false;
        }
    }

    @Nullable
    private ViewNode getViewNode(@NotNull String id) {
        for (int i2 = 0; i2 < this.myTree.getRowCount(); ++i2) {
            ViewNode node;
            TreePath path = this.myTree.getPathForRow(i2);
            Object last = path.getLastPathComponent();
            if (!(last instanceof ViewNode) || !id.equals((node = (ViewNode)last).getViewElement().toString())) continue;
            return node;
        }
        return null;
    }

    private void graph(Chart.GraphElements toGraph) {
        this.myChart.myGraphElements = toGraph;
        this.myChart.update(Gantt.ChartElement.Reason.GRAPH_SELECTED);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myAddButton != null) {
            this.myAddPanel.setBackground(bg);
        }
        if (this.myTree != null) {
            this.myTree.setBackground(bg);
        }
    }

    @Override
    public void update(Gantt.ChartElement.Reason reason) {
        if (reason == Gantt.ChartElement.Reason.SELECTION_CHANGED) {
            this.updateSizes();
            return;
        }
        if (reason == Gantt.ChartElement.Reason.ZOOM) {
            return;
        }
        if (!this.myInternal && reason == Gantt.ChartElement.Reason.ADDVIEW) {
            TreePath currPath;
            int i2;
            HashSet<String> expanded = new HashSet<String>();
            for (i2 = 0; i2 < this.myTree.getRowCount() - 1; ++i2) {
                TreePath nextPath;
                currPath = this.myTree.getPathForRow(i2);
                if (!currPath.isDescendant(nextPath = this.myTree.getPathForRow(i2 + 1))) continue;
                expanded.add(Arrays.toString(currPath.getPath()));
            }
            this.reload();
            for (i2 = 0; i2 < this.myTree.getRowCount() - 1; ++i2) {
                currPath = this.myTree.getPathForRow(i2);
                String s = Arrays.toString(currPath.getPath());
                if (!expanded.contains(s)) continue;
                this.myTree.expandPath(currPath);
            }
        }
        int count = this.myRootNode.getChildCount();
        this.updateSizes();
        TreePath[] selection = this.myTree.getSelectionPaths();
        this.mySelectedView = selection != null && selection.length > 0 && selection[0].getPath().length > 1 ? (ViewNode)selection[0].getPath()[1] : null;
        this.myAddPanel.doLayout();
    }

    private void updateSizes() {
        boolean viewNo = false;
        Gantt.ViewElement viewElement = null;
        for (int i2 = 0; i2 < this.myTree.getRowCount(); ++i2) {
            TreePath path = this.myTree.getPathForRow(i2);
            Rectangle rectangle = this.myTree.getPathBounds(path);
            Object last = path.getLastPathComponent();
            if (last instanceof ViewNode) {
                viewElement = ((ViewNode)last).getViewElement();
                viewElement.myYStart = rectangle.y;
                viewElement.myHeight = rectangle.height;
                viewElement.myHeightView = rectangle.height;
                viewElement.myHeightCycle = 0;
                viewElement.myHeightAttribute = 0;
                viewElement.myHeightPosition = 0;
            } else if (last instanceof CategoryNode) {
                CategoryNode categoryNode = (CategoryNode)last;
                switch (categoryNode.myType) {
                    case Cycles: {
                        viewElement.myHeightCycle = rectangle.height;
                        break;
                    }
                    case Attributes: {
                        viewElement.myHeightAttribute = rectangle.height;
                        break;
                    }
                    case Position: {
                        viewElement.myHeightPosition = rectangle.height;
                    }
                }
            }
            if (rectangle == null || last instanceof ViewNode) continue;
            viewElement.myHeight += rectangle.height;
        }
    }

    void reload() {
        this.myRootNode.removeAllChildren();
        DefaultTreeModel model2 = (DefaultTreeModel)this.myTree.getModel();
        for (Gantt.ViewElement viewElement : this.myChart.myViewElements) {
            ViewNode node = new ViewNode(viewElement);
            this.myRootNode.add(node);
            if (viewElement.mKeyFrames == null) continue;
            if (!viewElement.mKeyFrames.myKeyPositions.isEmpty()) {
                node.add(new CategoryNode(viewElement, viewElement.mKeyFrames.myKeyPositions, CategoryNode.Type.Position));
            }
            if (!viewElement.mKeyFrames.myKeyAttributes.isEmpty()) {
                node.add(new CategoryNode(viewElement, viewElement.mKeyFrames.myKeyAttributes, CategoryNode.Type.Attributes));
            }
            if (viewElement.mKeyFrames.myKeyCycles.isEmpty()) continue;
            node.add(new CategoryNode(viewElement, viewElement.mKeyFrames.myKeyCycles, CategoryNode.Type.Cycles));
        }
        model2.reload();
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public static final JBEmptyBorder TEXT_PADDING_BORDER = JBUI.Borders.empty((int)2, (int)0);

        MyDefaultTreeCellRenderer() {
            this.setBorder((Border)TEXT_PADDING_BORDER);
            this.setBackgroundNonSelectionColor((Color)StudioColorsKt.getSecondaryPanelBackground());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            JComponent c = (JComponent)super.getTreeCellRendererComponent(tree, node.getChildCount() == 0 ? "" : value2, sel, expanded, leaf, row, hasFocus);
            Object root = tree.getModel().getRoot();
            if (root.equals(node)) {
                this.setIcon(EmptyIcon.ICON_0);
                return c;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof Gantt.ViewElement) {
                this.setIcon(((Gantt.ViewElement)userObject).getIcon());
            } else if (node.getParent() == root) {
                this.setIcon(StudioIcons.LayoutEditor.Palette.VIEW);
            } else if (node instanceof GraphMode) {
                this.setIcon(mySpacerIcon);
            } else {
                this.setIcon(EmptyIcon.ICON_0);
            }
            this.setText(userObject.toString());
            this.setBackgroundSelectionColor(UIUtil.getTreeSelectionBackground((boolean)hasFocus));
            return c;
        }
    }

    static class ViewNode
    extends DefaultMutableTreeNode {
        public ViewNode(Gantt.ViewElement element) {
            super(element);
        }

        Gantt.ViewElement getViewElement() {
            return (Gantt.ViewElement)this.userObject;
        }
    }

    static class GraphMode
    extends DefaultMutableTreeNode {
        ArrayList<MotionSceneModel.KeyFrame> myKeyList;

        GraphMode(ArrayList<MotionSceneModel.KeyFrame> keyList, CategoryNode.Type type, AttrName name) {
            super(name.getName());
            this.myKeyList = keyList;
        }
    }

    static class CategoryNode
    extends DefaultMutableTreeNode {
        Type myType;
        Gantt.ViewElement myView;
        ArrayList<? extends MotionSceneModel.KeyFrame> myKeyList;

        CategoryNode(Gantt.ViewElement viewElement, ArrayList<? extends MotionSceneModel.KeyFrame> keyList, Type type) {
            super(type == Type.Position ? "Position" : (type == Type.Attributes ? "Attributes" : "Cycles"));
            this.myKeyList = keyList;
            this.myView = viewElement;
            this.myType = type;
            Object[] list = MotionSceneModel.getGraphAttributes(keyList);
            Arrays.sort(list);
            switch (type) {
                case Position: {
                    viewElement.myHasPosition = true;
                    break;
                }
                case Attributes: {
                    viewElement.myHasAttribute = true;
                    break;
                }
                case Cycles: {
                    viewElement.myHasCycle = true;
                }
            }
            for (int i2 = 0; i2 < list.length; ++i2) {
                Object name = list[i2];
                this.add(new GraphMode(MotionSceneModel.filterList(keyList, (AttrName)name), type, (AttrName)name));
            }
        }

        static enum Type {
            Position,
            Attributes,
            Cycles;

        }
    }

    public class CustomTreeUI
    extends BasicTreeUI {
        @Override
        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value2, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value2, row, depth, expanded, size);
                    dimensions.width = ViewList.this.getWidth() - this.getRowX(row, depth) - 1;
                    return dimensions;
                }
            };
        }

        @Override
        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left2, int right2) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }
    }
}

