/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceGroupDragHandler;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PreferenceScreenDragHandler
extends PreferenceGroupDragHandler {
    private final SceneComponent myInitialGroup;
    private final Map<SceneComponent, Rectangle> myInitialPreferenceToBoundsMap;

    PreferenceScreenDragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler, @NotNull SceneComponent group, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        super(editor2, handler, group, preferences, type);
        this.myInitialGroup = group;
        this.myInitialPreferenceToBoundsMap = this.getPreferenceToBoundsMap(group);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String message2 = super.update(x, y, modifiers);
        if (message2 != null) {
            return message2;
        }
        if (this.myGroup.getChildren().isEmpty()) {
            return null;
        }
        Optional<SceneComponent> category = this.myInitialPreferenceToBoundsMap.keySet().stream().filter(preference -> preference.getNlComponent().getTagName().equals("PreferenceCategory") && this.myInitialPreferenceToBoundsMap.get(preference).contains(x, y)).findFirst();
        if (category.isPresent()) {
            if (this.myGroup != category.get()) {
                this.myGroup = category.get();
                this.myPreferenceToBoundsMap = this.getPreferenceToBoundsMap(this.myGroup);
                this.layout = this.myGroup;
            }
        } else if (this.myGroup != this.myInitialGroup) {
            this.myGroup = this.myInitialGroup;
            this.myPreferenceToBoundsMap = this.myInitialPreferenceToBoundsMap;
            this.layout = this.myInitialGroup;
        }
        this.updateActivePreference();
        return null;
    }

    @Override
    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        if (!this.myGroup.getChildren().isEmpty()) {
            super.drawDropPreviewLine(graphics);
        }
    }

    @Override
    void drawDropRecipientLines(@NotNull NlGraphics graphics) {
        List<SceneComponent> preferences = this.myGroup.getChildren();
        if (preferences.isEmpty()) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        Rectangle bounds = this.getBounds(this.myGroup);
        if (this.lastY >= this.getMidpointY(preferences.get(0)) || this.myGroup.getNlComponent().getTagName().equals("PreferenceCategory")) {
            graphics.drawTopDp(bounds);
        }
        graphics.drawLeftDp(bounds);
        graphics.drawRightDp(bounds);
        if (this.lastY < this.getMidpointY(preferences.get(preferences.size() - 1))) {
            graphics.drawBottomDp(bounds);
        }
    }

    @Override
    void drawDropZoneLines(@NotNull NlGraphics graphics) {
        this.drawDropZoneLines(graphics, this.myGroup.getNlComponent().getTagName().equals("PreferenceCategory") ? 0 : 1);
    }
}

