/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layeredimage;

import com.android.tools.pixelprobe.Image;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightFillLayout;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.images.editor.ImageEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredImageEditorPanel
extends JPanel
implements DesignerEditorPanelFacade {
    private final ThreeComponentsSplitter myContentSplitter;
    private final JComponent myContentComponent;
    private final Image myImage;

    LayeredImageEditorPanel(@NotNull ImageEditor editor2, @Nullable Image image) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.myImage = image;
        JComponent editorComponent = editor2.getComponent();
        this.myContentComponent = editor2.getContentComponent();
        Component toolbar = editorComponent.getComponent(0);
        editorComponent.remove(0);
        JPanel contentPanel = new JPanel((LayoutManager)new LightFillLayout());
        contentPanel.add(toolbar);
        contentPanel.add(editorComponent);
        this.myContentSplitter = new ThreeComponentsSplitter();
        this.myContentSplitter.setDividerWidth(0);
        this.myContentSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myContentSplitter.setInnerComponent((JComponent)contentPanel);
        this.add((Component)this.myContentSplitter, "Center");
    }

    @NotNull
    Image getImage() {
        return this.myImage;
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myContentSplitter;
    }

    void dispose() {
        Disposer.dispose((Disposable)this.myContentSplitter);
    }

    JComponent getPreferredFocusedComponent() {
        return this.myContentComponent;
    }
}

