/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layeredimage;

import com.android.tools.idea.uibuilder.layeredimage.EmptyVirtualFile;
import com.android.tools.idea.uibuilder.layeredimage.LayeredImageEditor;
import com.android.utils.SdkUtils;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LayeredImageEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "layeredimageeditor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".psd");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider("images");
        assert (provider != null);
        FileEditor editor2 = provider.createEditor(project, (VirtualFile)new EmptyVirtualFile(file));
        return new LayeredImageEditor(project, file, editor2);
    }

    @NotNull
    public String getEditorTypeId() {
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

