/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.Cube;
import com.android.tools.idea.uibuilder.layout3d.Matrix;
import com.android.tools.idea.uibuilder.layout3d.Rasterize;
import com.android.tools.idea.uibuilder.layout3d.TriData;
import com.android.tools.idea.uibuilder.layout3d.ViewMatrix;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Display3D
extends JPanel {
    private boolean myRetinaDisplay = false;
    BufferedImage myImage;
    float[] myZBuffer = new float[1];
    TriData mTriData = new Cube();
    TriData myTransFormCache;
    ViewMatrix myViewMatrix = new ViewMatrix();
    Matrix myInvMatrix;
    boolean isImageInvalid = true;
    static final boolean mPerspective = false;
    Vector<ActionListener> myViewChangeListener = new Vector();

    public String getOrientationString(Rectangle rect) {
        return this.myViewMatrix.getOrientationString(rect);
    }

    public Rectangle parseOrientationString(String pref) {
        Rectangle rec = this.myViewMatrix.parseOrientationString(pref);
        this.myInvMatrix = this.myViewMatrix.invers();
        this.isImageInvalid = true;
        this.repaint();
        return rec;
    }

    public void addViewChangeListener(ActionListener listener2) {
        this.myViewChangeListener.add(listener2);
    }

    private void fireViewChanged() {
        for (ActionListener listener2 : this.myViewChangeListener) {
            listener2.actionPerformed(new ActionEvent(this, 0, "view"));
        }
    }

    public Display3D() {
        Float scale;
        this.setup();
        Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
        if (obj instanceof Float && (scale = (Float)obj).intValue() == 2) {
            this.myRetinaDisplay = true;
        }
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case 's': {
                        BufferedImage img = Display3D.this.save(7680, 4096);
                        try {
                            ImageIO.write((RenderedImage)img, "png", new File("capture" + System.currentTimeMillis() / 1000L % 10000L + "png"));
                            break;
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Display3D.this.myViewMatrix.trackBallUP(e.getX(), e.getY());
                Display3D.this.myInvMatrix = Display3D.this.myViewMatrix.invers();
                Display3D.this.fireViewChanged();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Display3D.this.myViewMatrix.trackBallDown(e.getX(), e.getY());
                Display3D.this.myInvMatrix = Display3D.this.myViewMatrix.invers();
            }
        });
        this.addMouseWheelListener(e -> {
            double sw = this.myViewMatrix.getScreenWidth();
            this.myViewMatrix.setScreenWidth(sw * (e.getPreciseWheelRotation() + 10.0) / 10.0);
            this.myViewMatrix.calcMatrix();
            this.myInvMatrix = this.myViewMatrix.invers();
            this.isImageInvalid = true;
            this.repaint();
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Display3D.this.myViewMatrix.trackBallMove(e.getX(), e.getY());
                Display3D.this.myInvMatrix = Display3D.this.myViewMatrix.invers();
                Display3D.this.isImageInvalid = true;
                Display3D.this.repaint();
            }
        });
    }

    public BufferedImage save(int w, int h) {
        this.myImage = UIUtil.createImage((int)w, (int)h, (int)1);
        this.myZBuffer = new float[w * h];
        this.isImageInvalid = true;
        this.myViewMatrix.setScreenDim(w, h);
        this.myViewMatrix.calcMatrix();
        this.myInvMatrix = this.myViewMatrix.invers();
        int[] rgbData = ((DataBufferInt)this.myImage.getRaster().getDataBuffer()).getData();
        if (this.isImageInvalid) {
            if (this.myTransFormCache == null) {
                this.myTransFormCache = new TriData(this.mTriData);
            }
            this.mTriData.transform(this.myInvMatrix, this.myTransFormCache);
            Arrays.fill(this.myZBuffer, Float.MAX_VALUE);
            Arrays.fill(rgbData, -16777216);
            if (this.mTriData.myTexture != null) {
                Rasterize.toZBuff(this.myZBuffer, rgbData, w, h, this.myTransFormCache, this.mTriData.myTexture, this.mTriData.myTextureWidth, this.mTriData.myTextureHeight, this.myViewMatrix.m);
            } else {
                Rasterize.simple(this.myZBuffer, rgbData, w, h, this.myTransFormCache);
            }
            this.isImageInvalid = false;
        }
        return this.myImage;
    }

    public void setTriData(TriData data) {
        this.mTriData = data;
        this.setup();
        this.repaint();
    }

    public void setup() {
        this.myViewMatrix = new ViewMatrix();
        this.myTransFormCache = null;
        if (this.myRetinaDisplay) {
            this.myViewMatrix.look('\u0001', this.mTriData, this.getWidth() * 2, this.getHeight() * 2);
        } else {
            this.myViewMatrix.look('\u0001', this.mTriData, this.getWidth(), this.getHeight());
        }
        this.myViewMatrix.setScreenWidth(1920.0);
        this.myViewMatrix.calcMatrix();
        this.myInvMatrix = this.myViewMatrix.invers();
        this.isImageInvalid = true;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.myRetinaDisplay) {
            w *= 2;
            h *= 2;
        }
        if (this.myImage == null || this.myImage.getWidth() != w || this.myImage.getHeight() != h) {
            this.myImage = UIUtil.createImage((int)w, (int)h, (int)1);
            this.myZBuffer = new float[w * h];
            this.isImageInvalid = true;
            this.myViewMatrix.setScreenDim(w, h);
            this.myViewMatrix.calcMatrix();
            this.myInvMatrix = this.myViewMatrix.invers();
        }
        int[] rgbData = ((DataBufferInt)this.myImage.getRaster().getDataBuffer()).getData();
        if (this.isImageInvalid) {
            if (this.myTransFormCache == null) {
                this.myTransFormCache = new TriData(this.mTriData);
            }
            this.mTriData.transform(this.myInvMatrix, this.myTransFormCache);
            Arrays.fill(this.myZBuffer, Float.MAX_VALUE);
            Arrays.fill(rgbData, -16777216);
            if (this.mTriData.myTexture != null) {
                Rasterize.toZBuff(this.myZBuffer, rgbData, w, h, this.myTransFormCache, this.mTriData.myTexture, this.mTriData.myTextureWidth, this.mTriData.myTextureHeight, this.myViewMatrix.m);
            } else {
                Rasterize.simple(this.myZBuffer, rgbData, w, h, this.myTransFormCache);
            }
            this.isImageInvalid = false;
        }
        g.drawImage(this.myImage, 0, 0, this.getWidth(), this.getHeight(), null);
    }
}

