/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.Matrix;
import com.android.tools.idea.uibuilder.layout3d.ViewMatrix;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.Arrays;

public class TriData {
    protected float[] myVert;
    protected float[] myTexture_uv;
    protected int[] myIndex;
    protected int[] mySurfaceType;
    int[] myTexture;
    int myTextureWidth;
    int myTextureHeight;

    public TriData() {
    }

    public void bounds(float[] min, float[] max) {
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            float x = this.myVert[i2];
            float y = this.myVert[i2 + 1];
            float z = this.myVert[i2 + 2];
            if (min != null) {
                min[0] = Math.min(x, min[0]);
                min[1] = Math.min(x, min[1]);
                min[2] = Math.min(x, min[2]);
            }
            if (max == null) continue;
            max[0] = Math.max(x, max[0]);
            max[1] = Math.max(x, max[1]);
            max[2] = Math.max(x, max[2]);
        }
    }

    public void print() {
        class F
        extends DecimalFormat {
            public F() {
                super("      ##0.000");
            }

            public String f(double number) {
                String ret = super.format(number);
                return ret.substring(ret.length() - 7);
            }
        }
        F df = new F();
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            System.out.print(i2 / 3 + "[ " + df.f(this.myVert[i2]));
            System.out.print(", " + df.f(this.myVert[i2 + 1]));
            System.out.println(", " + df.f(this.myVert[i2 + 2]) + "]");
        }
    }

    public TriData(TriData clone) {
        if (clone.myTexture_uv != null) {
            this.myTexture_uv = Arrays.copyOf(clone.myTexture_uv, clone.myTexture_uv.length);
        }
        this.mySurfaceType = clone.mySurfaceType;
        this.myVert = Arrays.copyOf(clone.myVert, clone.myVert.length);
        this.myIndex = Arrays.copyOf(clone.myIndex, clone.myIndex.length);
    }

    public void scale(float[] s) {
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            int n = i2;
            this.myVert[n] = this.myVert[n] * s[0];
            int n2 = i2 + 1;
            this.myVert[n2] = this.myVert[n2] * s[1];
            int n3 = i2 + 2;
            this.myVert[n3] = this.myVert[n3] * s[2];
        }
    }

    public void scale(double[] s) {
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            int n = i2;
            this.myVert[n] = (float)((double)this.myVert[n] * s[0]);
            int n2 = i2 + 1;
            this.myVert[n2] = (float)((double)this.myVert[n2] * s[1]);
            int n3 = i2 + 2;
            this.myVert[n3] = (float)((double)this.myVert[n3] * s[2]);
        }
    }

    public void transform(Matrix m) {
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            m.mult3(this.myVert, i2, this.myVert, i2);
        }
    }

    public void transform(Matrix m, TriData out) {
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            m.mult3(this.myVert, i2, out.myVert, i2);
        }
    }

    public void transformP(Matrix m, TriData out, float cx, float cy, float scrDist) {
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            m.mult3(this.myVert, i2, out.myVert, i2);
            out.myVert[i2] = cx + (out.myVert[i2] - cx) * scrDist / out.myVert[i2 + 2];
            out.myVert[i2 + 1] = cy + (out.myVert[i2 + 1] - cy) * scrDist / out.myVert[i2 + 2];
        }
    }

    public void ptransform(ViewMatrix vm, Matrix m, TriData out) {
        float dist = (float)vm.screenDistance();
        float cx = (float)vm.myScreenDim[0] / 2.0f;
        float cy = (float)vm.myScreenDim[1] / 2.0f;
        for (int i2 = 0; i2 < this.myVert.length; i2 += 3) {
            m.mult3(this.myVert, i2, out.myVert, i2);
            out.myVert[i2] = cx + (out.myVert[i2] - cx) * dist / out.myVert[i2 + 2];
            out.myVert[i2 + 1] = cy + (out.myVert[i2 + 1] - cy) * dist / out.myVert[i2 + 2];
        }
    }

    public void read(String fileName) {
        try {
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            int num_verts = Integer.parseInt(lnr.readLine());
            System.out.println("verts =" + num_verts);
            this.myVert = new float[num_verts * 3];
            int k = 0;
            for (int i2 = 0; i2 < num_verts; ++i2) {
                String[] s = lnr.readLine().split("\\s");
                for (int j = 0; j < s.length; ++j) {
                    this.myVert[k++] = Float.parseFloat(s[j]);
                }
            }
            int num_tri = Integer.parseInt(lnr.readLine());
            System.out.println("tri =" + num_tri);
            this.myIndex = new int[3 * num_tri];
            k = 0;
            for (int i3 = 0; i3 < num_tri; ++i3) {
                String[] s = lnr.readLine().split("\\s");
                for (int j = 0; j < s.length; ++j) {
                    this.myIndex[k++] = Integer.parseInt(s[j]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

