/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionBar {
    private final List<SceneComponent> myItems = new ArrayList<SceneComponent>();
    private final List<SceneComponent> myOverflowItems = new ArrayList<SceneComponent>();
    private final Rectangle myItemBounds;
    private final Rectangle myOverflowItemBounds;

    ActionBar(@NotNull SceneComponent group) {
        this.addToItemsOrOverflowItems(group);
        this.myItems.sort((item1, item2) -> Integer.compare(item1.getDrawX(), item2.getDrawX()));
        this.myOverflowItems.sort((item1, item2) -> Integer.compare(item1.getDrawY(), item2.getDrawY()));
        this.myItemBounds = ActionBar.getBounds(this.myItems);
        this.myOverflowItemBounds = ActionBar.getBounds(this.myOverflowItems);
    }

    private void addToItemsOrOverflowItems(@NotNull SceneComponent group) {
        group.getChildren().stream().filter(item -> item.getDrawWidth() != -1 && item.getDrawHeight() != -1).forEach(item -> {
            if (NlComponentHelperKt.getViewInfo(item.getNlComponent()) == null) {
                this.addToItemsOrOverflowItems((SceneComponent)item);
                return;
            }
            switch (NlComponentHelperKt.getViewInfo(item.getNlComponent()).getViewType()) {
                case ACTION_BAR_MENU: {
                    this.myItems.add((SceneComponent)item);
                    break;
                }
                case ACTION_BAR_OVERFLOW_MENU: {
                    this.myOverflowItems.add((SceneComponent)item);
                    break;
                }
            }
        });
    }

    @Nullable
    private static Rectangle getBounds(@NotNull List<SceneComponent> items2) {
        if (items2.isEmpty()) {
            return null;
        }
        SceneComponent firstItem = items2.get(0);
        Rectangle bounds = firstItem.fillRect(null);
        Rectangle temp = new Rectangle();
        items2.subList(1, items2.size()).forEach(item -> bounds.add(item.fillRect(temp)));
        return bounds;
    }

    @NotNull
    List<SceneComponent> getItems() {
        return this.myItems;
    }

    @NotNull
    List<SceneComponent> getOverflowItems() {
        return this.myOverflowItems;
    }

    @Nullable
    Rectangle getItemBounds() {
        return this.myItemBounds;
    }

    @Nullable
    Rectangle getOverflowItemBounds() {
        return this.myOverflowItemBounds;
    }

    boolean contains(int x, int y) {
        return this.myItemBounds.contains(x, y) || this.myOverflowItemBounds.contains(x, y);
    }
}

