/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.AutoCompleteViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingActionButtonCreator
extends AutoCompleteViewCreator {
    public FloatingActionButtonCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        super(mockup, model2, screenView, selection);
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return SdkConstants.FLOATING_ACTION_BUTTON.defaultName();
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        ViewAndColorForm viewAndColorForm = new ViewAndColorForm("Set color as background tint", this.createColorSelectedListener(doneCallback));
        BufferedImage image = this.getMockup().getImage();
        if (image == null) {
            return null;
        }
        this.extractColor(viewAndColorForm, image);
        return viewAndColorForm.getComponent();
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        super.addAttributes(transaction);
        if (this.myColor != null && this.myColor.value != null) {
            if (this.myColor.name != null && !this.myColor.name.isEmpty()) {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "backgroundTint", "@color/" + this.myColor.name);
            } else {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "backgroundTint", String.format("#%06X", this.myColor.value.getRGB()));
            }
        }
    }
}

