/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.intellij.openapi.Disposable;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        super(mockup, model2, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component = this.getMockup().getComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_RECYCLER_VIEW_V7)) {
            this.addListItemAttribute(component);
            return component;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component) {
        String newLayoutResource = this.createNewIncludedLayout();
        NlWriteCommandActionUtil.run(component, "Add listitem attribute", () -> component.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource));
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        AndroidFacet facet = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet, ResourceFolderType.LAYOUT, null, null, null, true, null, null, null, false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        DesignSurface surface = this.getScreenView().getSurface();
        final LayoutlibSceneManager manager = (LayoutlibSceneManager)surface.getSceneManager();
        if (manager != null) {
            final NlModel model2 = NlModel.create((Disposable)newFile.getProject(), facet, newFile.getVirtualFile(), surface.getComponentRegistrar());
            manager.addRenderListener(new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    manager.removeRenderListener(this);
                    if (model2.getComponents().isEmpty()) {
                        return;
                    }
                    NlComponent component = (NlComponent)model2.getComponents().get(0);
                    AttributesTransaction transaction = component.startAttributeTransaction();
                    IncludeTagCreator.this.addShowInAttribute(transaction);
                    IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                    IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                    NlWriteCommandActionUtil.run(component, "", transaction::commit);
                }
            });
        }
        return IncludeTagCreator.getResourceName(newFile);
    }

    @NotNull
    private static String getResourceName(@NotNull XmlFile newFile) {
        return AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        String showInName = IncludeTagCreator.getResourceName(this.getModel().getFile());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }
}

