/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.tools;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.mockup.editor.MockupViewPanel;
import com.android.tools.idea.uibuilder.mockup.editor.SelectionLayer;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropTool
extends JPanel
implements MockupEditor.Tool {
    private final MockupEditor myMockupEditor;
    @Nullable
    private Mockup myMockup;
    private final MockupViewPanel.SelectionListener mySelectionListener;
    private boolean myActive;
    private MockupViewPanel myMockupViewPanel;
    private MatchComponentRatio myMatchComponentRatioAction;

    public CropTool(MockupEditor mockupEditor) {
        super(new FlowLayout(2, 3, 1));
        this.myMockupEditor = mockupEditor;
        this.myMockupViewPanel = mockupEditor.getMockupViewPanel();
        this.myMockupEditor.addListener(this::update);
        this.add(this.createCropButton());
        this.update(mockupEditor.getMockup());
        this.mySelectionListener = new MySelectionListener();
    }

    private void update(@Nullable Mockup mockup) {
        this.myMockup = mockup;
        this.setCropLabel(mockup);
    }

    private static void saveSelectionToMockup(@NotNull Rectangle selection, @NotNull Mockup mockup) {
        mockup.setCropping(selection.x, selection.y, selection.width, selection.height);
        MockupFileHelper.writePositionToXML(mockup);
    }

    @NotNull
    private JComponent createCropButton() {
        this.myMatchComponentRatioAction = new MatchComponentRatio();
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ToggleCrop(), this.myMatchComponentRatioAction});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("AndroidDesignerCropTool", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(1);
        return actionToolbar.getComponent();
    }

    private void setCropLabel(@Nullable Mockup mockup) {
        if (mockup != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMockupEditor.setSelectionText(mockup.getComputedCropping()));
        }
    }

    @Override
    public void enable(@NotNull MockupEditor mockupEditor) {
        this.myActive = true;
        this.myMockupViewPanel.addSelectionListener(this.mySelectionListener);
        this.myMockupViewPanel.setDisplayOnlyCroppedRegion(false);
        this.myMockupViewPanel.setSelectionMode(true);
        this.myMockupViewPanel.setSelectionToMockupCrop();
        this.setCropActionsEnabled(false);
        this.update(mockupEditor.getMockup());
        mockupEditor.addBottomControls(this.createApplyButton());
    }

    @NotNull
    private JComponent createApplyButton() {
        JPanel panel2 = new JPanel();
        JButton apply2 = new JButton("Finish Crop");
        apply2.addActionListener(e -> this.myMockupEditor.disableTool(this));
        panel2.add(new JLabel("<html>Select area to fit inside the selected component</html>"));
        panel2.add(apply2);
        return panel2;
    }

    @Override
    public void disable(@NotNull MockupEditor mockupEditor) {
        this.myActive = false;
        this.setCropActionsEnabled(false);
        this.myMockupViewPanel.removeSelectionListener(this.mySelectionListener);
        this.myMockupViewPanel.resetState();
    }

    private void setCropActionsEnabled(boolean enabled) {
        this.myMatchComponentRatioAction.getTemplatePresentation().setEnabled(enabled);
        this.myMatchComponentRatioAction.setSelected(null, false);
    }

    private class MySelectionListener
    implements MockupViewPanel.SelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void selectionStarted(MockupViewPanel mockupViewPanel, int x, int y) {
        }

        @Override
        public void selectionEnded(MockupViewPanel mockupViewPanel, Rectangle selection) {
            if (CropTool.this.myMockup != null) {
                CropTool.saveSelectionToMockup(selection, CropTool.this.myMockup);
            }
        }
    }

    private class MatchComponentRatio
    extends ToggleAction {
        public static final String TITLE = "Match component ratio";

        public MatchComponentRatio() {
            super(TITLE, TITLE, AndroidIcons.Mockup.MatchWidget);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(CropTool.this.myActive && CropTool.this.myMockup != null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return CropTool.this.myActive && CropTool.this.myMockupViewPanel != null && CropTool.this.myMockupViewPanel.getSelectionLayer().isFixedRatio();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (CropTool.this.myMockup == null) {
                return;
            }
            NlComponent component = CropTool.this.myMockup.getComponent();
            SelectionLayer selectionLayer = CropTool.this.myMockupViewPanel.getSelectionLayer();
            selectionLayer.setFixedRatio(state);
            if (state) {
                selectionLayer.setAspectRatio(NlComponentHelperKt.getW(component), NlComponentHelperKt.getH(component));
                CropTool.saveSelectionToMockup(selectionLayer.getSelection(), CropTool.this.myMockup);
            }
        }
    }

    private class ToggleCrop
    extends ToggleAction {
        public ToggleCrop() {
            this.getTemplatePresentation().setIcon(AndroidIcons.Mockup.Crop);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return CropTool.this.myActive;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (state) {
                CropTool.this.myMockupEditor.enableTool(CropTool.this);
            } else {
                CropTool.this.myMockupEditor.disableTool(CropTool.this);
            }
        }
    }
}

