/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.common.model.NlComponent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum FillPolicy {
    NONE,
    BOTH,
    WIDTH,
    HEIGHT,
    OPPOSITE,
    WIDTH_IN_VERTICAL,
    HEIGHT_IN_HORIZONTAL;

    static final Map<String, FillPolicy> ourNameToPolicy;

    public boolean fillHorizontally(boolean inVerticalContext) {
        return this == BOTH || this == WIDTH || inVerticalContext && (this == OPPOSITE || this == WIDTH_IN_VERTICAL);
    }

    public boolean fillVertically(boolean inVerticalContext) {
        return this == BOTH || this == HEIGHT || !inVerticalContext && (this == OPPOSITE || this == HEIGHT_IN_HORIZONTAL);
    }

    public static FillPolicy get(String fill2) {
        FillPolicy fillPolicy = null;
        if (!fill2.isEmpty()) {
            fillPolicy = ourNameToPolicy.get(fill2);
        }
        if (fillPolicy == null) {
            fillPolicy = NONE;
        }
        return fillPolicy;
    }

    @NotNull
    public static FillPolicy getFillPreference(@NotNull NlComponent component) {
        return BOTH;
    }

    static {
        ourNameToPolicy = new HashMap<String, FillPolicy>();
        for (FillPolicy pref : FillPolicy.values()) {
            ourNameToPolicy.put(pref.toString().toLowerCase(Locale.US), pref);
        }
    }
}

