/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.SdkConstants;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\f\u0010\f\u001a\u00020\n*\u00020\u000bH\u0007\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\u0010\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"CUSTOM_DENSITY_ID", "", "updateConfigurationScreenSize", "", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "xDimension", "", "yDimension", "currentActivityIsDerivedFromAppCompatActivity", "", "Lcom/android/tools/idea/common/model/NlModel;", "moduleDependsOnAppCompat", "overrideConfigurationDensity", "density", "Lcom/android/resources/Density;", "overrideConfigurationScreenSize", "intellij.android.designer"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";

    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension) {
        Device original = configuration.getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device = deviceBuilder.build();
        for (State state : device.getAllStates()) {
            Screen screen = state.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi = screen.getPixelDensity().getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(ScreenSize.getScreenSize((Double)diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            screen.setScreenRound(device.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device.getDefaultHardware().getScreen().getChin());
        }
        State newState = xDimension > yDimension ? device.getState("Landscape") : device.getState("Portrait");
        configuration.setEffectiveDevice(device, newState);
    }

    public static final void overrideConfigurationScreenSize(@NotNull NlModel $receiver, int xDimension, int yDimension) {
        Device original = $receiver.getConfiguration().getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device = deviceBuilder.build();
        for (State state : device.getAllStates()) {
            Screen screen = state.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi = screen.getPixelDensity().getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(ScreenSize.getScreenSize((Double)diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            screen.setScreenRound(device.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device.getDefaultHardware().getScreen().getChin());
        }
        VirtualFile better = null;
        State newState = null;
        if (xDimension > yDimension) {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Landscape", null, null);
            newState = device.getState("Landscape");
        } else {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Portrait", null, null);
            newState = device.getState("Portrait");
        }
        if (better != null) {
            VirtualFile virtualFile = $receiver.getConfiguration().getFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile old = virtualFile;
            Project project = $receiver.getProject();
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, better, -1);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor selectedEditor = manager.getSelectedEditor(old);
            manager.openEditor(descriptor2, true);
            if (selectedEditor instanceof DesignerEditor) {
                manager.setSelectedEditor(better, ((DesignerEditor)selectedEditor).getEditorId());
            } else if (selectedEditor != null) {
                manager.setSelectedEditor(better, TextEditorProvider.getInstance().getEditorTypeId());
            }
            AndroidFacet facet = AndroidFacet.getInstance($receiver.getConfiguration().getModule());
            if (facet != null) {
                Configuration configuration = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(better);
                configuration.setEffectiveDevice(device, newState);
            }
        } else {
            $receiver.getConfiguration().setEffectiveDevice(device, newState);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $receiver, @NotNull Density density) {
        void $this$mapTo$iv$iv;
        Device original = $receiver.getConfiguration().getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device = deviceBuilder.build();
        Iterable $this$map$iv = device.getAllStates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Screen screen = it.getHardware().getScreen();
            collection.add(screen);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Screen it = (Screen)element$iv;
            boolean bl = false;
            it.setPixelDensity(density);
        }
        $receiver.getConfiguration().setEffectiveDevice(device, device.getDefaultState());
    }

    @Deprecated(message="Use NlModel.module.dependsOnAppCompat()", replaceWith=@ReplaceWith(imports={}, expression="com.android.tools.idea.util.dependsOnAppCompat()"))
    public static final boolean moduleDependsOnAppCompat(@NotNull NlModel $receiver) {
        return DependencyManagementUtil.dependsOnAppCompat($receiver.getModule());
    }

    public static final boolean currentActivityIsDerivedFromAppCompatActivity(@NotNull NlModel $receiver) {
        PsiClass activityClass;
        String activityClassName;
        Configuration configuration = $receiver.getConfiguration();
        String string = configuration.getActivity();
        if (string == null) {
            return true;
        }
        String string2 = activityClassName = string;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.startsWith$default((String)string2, (String)".", (boolean)false, (int)2, null)) {
            MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot($receiver.getModule());
            String pkg = StringUtil.notNullize((String)manifest.getPackage());
            activityClassName = pkg + activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$receiver.getProject());
        for (activityClass = facade.findClass(activityClassName, $receiver.getModule().getModuleScope()); activityClass != null && !SdkConstants.CLASS_APP_COMPAT_ACTIVITY.isEquals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }
}

