/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.palette.Palette;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class CategoryListModel
extends AbstractListModel<Palette.Group> {
    private final List<Palette.Group> myGroups = new ArrayList<Palette.Group>();
    private final List<Integer> myMatchCounts = new ArrayList<Integer>();

    public void update(@NotNull List<Palette.Group> groups, @NotNull List<Integer> matchCounts) {
        assert (SwingUtilities.isEventDispatchThread()) : "Updates must be on EDT";
        this.myGroups.clear();
        this.myMatchCounts.clear();
        this.myGroups.addAll(groups);
        this.myMatchCounts.addAll(matchCounts);
        this.fireContentsChanged(this, 0, this.myGroups.size() - 1);
    }

    public boolean contains(@NotNull Palette.Group group) {
        return this.myGroups.contains(group);
    }

    @Override
    public int getSize() {
        return this.myGroups.size();
    }

    public boolean hasExplicitGroups() {
        return this.getSize() > 1;
    }

    @Override
    public Palette.Group getElementAt(int index) {
        return this.myGroups.get(index);
    }

    public boolean hasMatchCounts() {
        return !this.myMatchCounts.isEmpty();
    }

    public int getMatchCountAt(int index) {
        if (this.myMatchCounts.isEmpty()) {
            return -1;
        }
        return this.myMatchCounts.get(index);
    }
}

