/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.ListWithMargin;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ItemList
extends ListWithMargin<Palette.Item> {
    private final DependencyManager myDependencyManager;

    public ItemList(@NotNull DependencyManager dependencyManager) {
        this.myDependencyManager = dependencyManager;
        this.setCellRenderer(new ItemCellRenderer());
    }

    @Override
    protected int getRightMarginWidth() {
        return StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD.getIconWidth();
    }

    private boolean displayFittedTextIfNecessary(int index) {
        return !UIUtil.isClientPropertyTrue((Object)((Object)this), (Object)ExpandableItemsHandler.EXPANDED_RENDERER) && !this.getExpandableItemsHandler().getExpandedItems().contains(index);
    }

    private boolean displayDownloadIcon(@NotNull Palette.Item item, int index) {
        return this.myDependencyManager.needsLibraryLoad(item) && this.displayFittedTextIfNecessary(index);
    }

    private static class TextCellRenderer
    extends ColoredListCellRenderer<Palette.Item> {
        private TextCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Palette.Item> list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            ItemList itemList = (ItemList)((Object)list);
            Icon icon2 = item.getIcon();
            String text = item.getTitle();
            if (itemList.displayFittedTextIfNecessary(index)) {
                int leftMargin = icon2.getIconWidth() + this.myIconTextGap + this.getIpad().right + this.getIpad().left;
                int rightMargin = StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD.getIconWidth();
                text = AdtUiUtils.shrinkToFit((String)text, s -> list.getFontMetrics(list.getFont()).stringWidth((String)s) <= list.getWidth() - leftMargin - rightMargin);
            }
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null);
            this.mySelectionForeground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            this.setIcon(selected && hasFocus ? ColoredIconGenerator.INSTANCE.generateWhiteIcon(icon2) : icon2);
            this.append(text);
        }
    }

    private static class ItemCellRenderer
    implements ListCellRenderer<Palette.Item> {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JBLabel myDownloadIcon = new JBLabel();
        private final TextCellRenderer myTextRenderer = new TextCellRenderer();

        private ItemCellRenderer() {
            this.myPanel.add((Component)((Object)this.myTextRenderer), "Center");
            this.myPanel.add((Component)this.myDownloadIcon, "East");
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends Palette.Item> list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            this.myTextRenderer.getListCellRendererComponent(list, item, index, selected, hasFocus);
            this.myPanel.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null);
            this.myPanel.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
            this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
            ItemList itemList = (ItemList)((Object)list);
            this.myDownloadIcon.setVisible(itemList.displayDownloadIcon(item, index));
            this.myDownloadIcon.setIcon(selected && hasFocus ? StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD_SELECTED : StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD);
            return this.myPanel;
        }
    }
}

