/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.ptable.PTableItem;
import com.google.common.collect.Table;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddPropertyItem
extends PTableItem {
    private final Table<String, String, NlPropertyItem> myProperties;
    private String myName = "";
    private NlProperty myProperty = EmptyProperty.INSTANCE;

    public AddPropertyItem(@NotNull Table<String, String, NlPropertyItem> properties) {
        this.myProperties = properties;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myProperty.getValue();
    }

    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @NotNull
    public List<String> getUnspecifiedProperties() {
        ArrayList<String> items2 = new ArrayList<String>();
        for (String namespace : this.myProperties.rowKeySet()) {
            if (namespace.equals("http://schemas.android.com/tools")) continue;
            for (NlPropertyItem property2 : this.myProperties.row((Object)namespace).values()) {
                NlProperty designProperty;
                if (property2.getValue() == null) {
                    AddPropertyItem.addProperty(items2, namespace, property2.getName());
                }
                if ((designProperty = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/tools", (Object)property2.getName())) != null && designProperty.getValue() != null) continue;
                AddPropertyItem.addProperty(items2, "http://schemas.android.com/tools", property2.getName());
            }
        }
        return items2;
    }

    private static void addProperty(@NotNull List<String> items2, @NotNull String namespace, @NotNull String name) {
        String prefix = "";
        switch (namespace) {
            case "http://schemas.android.com/apk/res/android": {
                prefix = "android:";
                break;
            }
            case "http://schemas.android.com/apk/res-auto": {
                prefix = "app:";
                break;
            }
            case "http://schemas.android.com/tools": {
                prefix = "tools:";
            }
        }
        items2.add(prefix + name);
    }

    @NotNull
    public NlProperty findPropertyByQualifiedName(@NotNull String name) {
        NlProperty property2;
        String namespace = "";
        String propertyName = name;
        List names = StringUtil.split((String)name, (String)":", (boolean)false);
        if (names.size() > 1) {
            namespace = AddPropertyItem.convertNamespacePrefix((String)names.get(0));
            propertyName = (String)names.get(1);
        }
        if ((property2 = (NlProperty)this.myProperties.get((Object)namespace, (Object)propertyName)) == null && namespace.equals("http://schemas.android.com/tools")) {
            property2 = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (property2 == null) {
                property2 = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            return property2 != null ? property2.getDesignTimeProperty() : EmptyProperty.INSTANCE;
        }
        return property2 != null && property2.getValue() == null ? property2 : EmptyProperty.INSTANCE;
    }

    private static String convertNamespacePrefix(@NotNull String prefix) {
        switch (prefix) {
            case "android:": {
                return "http://schemas.android.com/apk/res/android";
            }
            case "app:": {
                return "http://schemas.android.com/apk/res-auto";
            }
            case "tools:": {
                return "http://schemas.android.com/tools";
            }
        }
        return "";
    }

    @Override
    public boolean isEditable(int column) {
        return column == 0 || this.isPropertyNameSelected();
    }

    @Override
    public int getColumnToEdit() {
        return this.isPropertyNameSelected() ? 1 : 0;
    }

    @Override
    public void setValue(@Nullable Object value2) {
        if (!this.isPropertyNameSelected()) {
            this.myName = value2 == null ? "" : value2.toString().trim();
            this.updateProperty();
        } else {
            this.myProperty.setValue(value2);
        }
    }

    public void updateProperty() {
        this.myProperty = this.findPropertyByQualifiedName(this.myName);
    }

    public boolean isPropertyNameSelected() {
        return this.myProperty != EmptyProperty.INSTANCE;
    }
}

