/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.ImmutableList;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.annotations.NotNull;

public class NlDesignProperties {
    private final AttributeDefinition myContextDefinition = NlDesignProperties.getDefinitionByName("context");
    private final AttributeDefinition myListItemDefinition = NlDesignProperties.getDefinitionByName("listitem");
    private final AttributeDefinition myShowInItemDefinition = NlDesignProperties.getDefinitionByName("showIn");
    private final AttributeDefinition myOpenDrawerItemDefinition = NlDesignProperties.getDefinitionByName("openDrawer");
    private final AttributeDefinition myLayoutDefinition = NlDesignProperties.getDefinitionByName("layout");
    private final AttributeDefinition myParentTagDefinition = NlDesignProperties.getDefinitionByName("parentTag");
    private final AttributeDefinition myMockupDefinition = NlDesignProperties.getDefinitionByName("mockup");
    private final AttributeDefinition myMockupCropDefinition = NlDesignProperties.getDefinitionByName("mockup_crop");
    private final AttributeDefinition myMockupOpacityDefinition = NlDesignProperties.getDefinitionByName("mockup_opacity");

    @NotNull
    public List<NlPropertyItem> getKnownProperties(@NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        return ImmutableList.of((Object)NlDesignProperties.create(this.myContextDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myListItemDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myShowInItemDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myOpenDrawerItemDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myLayoutDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myParentTagDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myLayoutDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myMockupDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myMockupCropDefinition, components, propertiesManager), (Object)NlDesignProperties.create(this.myMockupOpacityDefinition, components, propertiesManager));
    }

    private static NlPropertyItem create(@NotNull AttributeDefinition definition, @NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        return NlPropertyItem.create(new XmlName(definition.getName(), "http://schemas.android.com/tools"), definition, components, propertiesManager);
    }

    private static AttributeDefinition getDefinitionByName(@NotNull String name) {
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(name);
        assert (definition != null);
        Converter converter = ToolsAttributeUtil.getConverter(definition);
        if (converter instanceof StaticEnumConverter) {
            Collection<String> variants = ((StaticEnumConverter)converter).getVariants(null);
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            for (String variant : variants) {
                values.put(variant.toString(), null);
            }
            definition.setValueMappings(values);
        }
        return definition;
    }
}

