/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property2.support.NeleIdRenameProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlIdPropertyItem
extends NlPropertyItem {
    protected NlIdPropertyItem(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @Nullable PropertiesManager propertiesManager) {
        super(name, attributeDefinition, components, propertiesManager);
    }

    @Override
    @Nullable
    public String getValue() {
        return NlIdPropertyItem.stripIdPrefix(super.getValue());
    }

    private static String stripIdPrefix(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return id;
    }

    @Override
    @Nullable
    public String resolveValue(@Nullable String value2) {
        return value2;
    }

    @Override
    public void setValue(Object value2) {
        XmlAttribute attribute;
        String newValue;
        String newId = value2 != null ? NlIdPropertyItem.stripIdPrefix(value2.toString()) : "";
        String oldId = this.getValue();
        XmlTag tag = this.getTag();
        String string = newValue = !StringUtil.isEmpty((String)newId) && !newId.startsWith("@android:id/") ? "@+id/" + newId : newId;
        if (oldId != null && !oldId.isEmpty() && !newId.isEmpty() && newValue != null && !oldId.equals(newId) && tag != null && tag.isValid() && (attribute = tag.getAttribute("id", "http://schemas.android.com/apk/res/android")) != null) {
            Module module = this.getModel().getModule();
            Project project = module.getProject();
            XmlAttributeValue valueElement = attribute.getValueElement();
            if (valueElement != null && valueElement.isValid()) {
                NeleIdRenameProcessor processor = new NeleIdRenameProcessor(project, valueElement, newValue);
                processor.run();
                return;
            }
        }
        super.setValue(newValue);
    }
}

