/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet, @Nullable PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        assert (!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        if (components.isEmpty()) {
            return ImmutableTable.of();
        }
        Project project = facet.getModule().getProject();
        return (Table)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.getPropertiesImpl(facet, propertiesManager, components));
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesImpl(@NotNull AndroidFacet facet, @Nullable PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        assert (!components.isEmpty());
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            return ImmutableTable.of();
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        Project project = facet.getModule().getProject();
        ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
        int minApi = AndroidModuleInfo.getInstance(facet).getMinSdkVersion().getFeatureLevel();
        for (NlComponent component : components) {
            String className;
            XmlTag tag = component.getTagDeprecated();
            if (!tag.isValid()) {
                return ImmutableTable.of();
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                return ImmutableTable.of();
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                AttributeDefinition attrDef;
                XmlName name = NlProperties.getXmlName(desc, tag);
                if ("http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) && apiLookup != null && apiLookup.getFieldVersion("android/R$attr", name.getLocalName()) > minApi) continue;
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attributeDefinition = attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(name.getLocalName());
                if (!NlPropertyItem.isDefinitionAcceptable(name, attrDef)) continue;
                NlPropertyItem property2 = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property2.getName(), (Object)property2);
            }
            PsiElement declaration = elementDescriptor.getDeclaration();
            PsiClass tagClass = declaration instanceof PsiClass ? (PsiClass)declaration : null;
            String string = className = tagClass != null ? tagClass.getQualifiedName() : null;
            if (NlComponentHelperKt.getHasNlComponentInfo(component)) {
                String viewClassName;
                ViewInfo view = NlComponentHelperKt.getViewInfo(component);
                String string2 = viewClassName = view != null ? view.getClassName() : null;
                if (localAttrDefs != null && viewClassName != null && className != null && !viewClassName.equals(className)) {
                    NlProperties.addAttributesFromInflatedStyleable((Table<String, String, NlPropertyItem>)properties, localAttrDefs, tagClass, viewClassName, propertiesManager, components);
                }
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    AttributeDefinition definition;
                    XmlName popup2 = new XmlName("popupBackground", "http://schemas.android.com/apk/res/android");
                    AttributeDefinition attributeDefinition = definition = systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null;
                    if (!NlPropertyItem.isDefinitionAcceptable(popup2, definition)) break;
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(popup2, definition, components, propertiesManager));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.initStarState(combinedProperties);
        return combinedProperties;
    }

    private static void addAttributesFromInflatedStyleable(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AttributeDefinitions localAttrDefs, @NotNull PsiClass xmlClass, @NotNull String inflatedClassName, @NotNull PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        PsiManager psiManager = PsiManager.getInstance((Project)xmlClass.getProject());
        for (PsiClass inflatedClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)inflatedClassName); inflatedClass != null && inflatedClass != xmlClass; inflatedClass = inflatedClass.getSuperClass()) {
            StyleableDefinition styleable;
            String styleableName = inflatedClass.getName();
            StyleableDefinition styleableDefinition = styleable = styleableName != null ? localAttrDefs.getStyleableByName(styleableName) : null;
            if (styleable == null) continue;
            for (AttributeDefinition attrDef : styleable.getAttributes()) {
                if (properties.contains((Object)"http://schemas.android.com/apk/res/android", (Object)attrDef.getName())) continue;
                XmlName name = NlProperties.getXmlName(attrDef.getName(), "http://schemas.android.com/apk/res-auto");
                NlPropertyItem property2 = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property2.getName(), (Object)property2);
            }
        }
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property2 = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property2.getFirst(), property2.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred, @Nullable PropertiesManager propertiesManager) {
        String removed;
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        ArrayList<String> favorites = new ArrayList<String>();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            favorites.add(starredProperty);
        }
        if (starred) {
            favorites.add(propertyNameWithPrefix);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, Joiner.on((char)';').join(favorites));
        String added = starred ? propertyNameWithPrefix : "";
        String string = removed = !starred ? propertyNameWithPrefix : "";
        if (propertiesManager != null) {
            propertiesManager.logFavoritesChange(added, removed, favorites);
        }
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (namespace == null) {
            return propertyName;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                return "tools:" + propertyName;
            }
            case "http://schemas.android.com/apk/res/android": {
                return propertyName;
            }
        }
        return "app:" + propertyName;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix.startsWith("tools:")) {
            return Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            return Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
        }
        return Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
    }

    @NotNull
    private static XmlName getXmlName(@NotNull XmlAttributeDescriptor descriptor2, @NotNull XmlTag context) {
        String namespace = null;
        if (descriptor2 instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor2).getNamespace(context);
        }
        return new XmlName(descriptor2.getName(), namespace);
    }

    @NotNull
    private static XmlName getXmlName(@NotNull String qualifiedName, @NotNull String defaultNamespace2) {
        if (qualifiedName.startsWith("android:")) {
            return new XmlName(StringUtil.trimStart((String)qualifiedName, (String)"android:"), "http://schemas.android.com/apk/res/android");
        }
        return new XmlName(qualifiedName, defaultNamespace2);
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }
}

