/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlMarginPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.ptable.PTableItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesGrouper {
    private static List<String> MOST_IMPORTANT_ATTRIBUTES = ImmutableList.of((Object)"id", (Object)"layout_width", (Object)"layout_height");

    public List<PTableItem> group(@NotNull List<NlPropertyItem> properties, @NotNull List<NlComponent> components) {
        ArrayList<PTableItem> result2 = new ArrayList<PTableItem>(properties.size());
        NlPropertyAccumulator themePropertiesAccumulator = new NlPropertyAccumulator("Theme", "", p -> p != null && (p.isThemeAttribute() || p.getName().equalsIgnoreCase("theme")));
        NlMarginPropertyAccumulator paddingPropertiesAccumulator = new NlMarginPropertyAccumulator("Padding", "padding", "paddingLeft", "paddingRight", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom");
        NlMarginPropertyAccumulator layoutViewPropertiesAccumulator = new NlMarginPropertyAccumulator("Layout_Margin", "layout_margin", "layout_marginLeft", "layout_marginRight", "layout_marginStart", "layout_marginEnd", "layout_marginTop", "layout_marginBottom");
        NlPropertyAccumulator.PropertyNamePrefixAccumulator constraintPropertiesAccumulator = new NlPropertyAccumulator.PropertyNamePrefixAccumulator("Constraints", "layout_constraint");
        NlPropertyAccumulator[] accumulators = new NlPropertyAccumulator[]{themePropertiesAccumulator, paddingPropertiesAccumulator, layoutViewPropertiesAccumulator, constraintPropertiesAccumulator};
        for (NlPropertyItem p2 : properties) {
            NlPropertyAccumulator accumulator;
            boolean added = false;
            NlPropertyAccumulator[] nlPropertyAccumulatorArray = accumulators;
            int n = nlPropertyAccumulatorArray.length;
            for (int j = 0; j < n && !(added = (accumulator = nlPropertyAccumulatorArray[j]).process(p2)); ++j) {
            }
            if (added) continue;
            result2.add(p2);
        }
        int insertionPoint = NlPropertiesGrouper.findInsertionPoint(result2);
        for (NlPropertyAccumulator accumulator : accumulators) {
            if (!accumulator.hasItems()) continue;
            result2.add(insertionPoint, accumulator.getGroupNode());
        }
        return result2;
    }

    @Nullable
    public static String getCommonTagName(@NotNull List<NlComponent> components) {
        String commonTagName = null;
        for (NlComponent component : components) {
            String tagName = component.getTagName();
            if (commonTagName == null) {
                commonTagName = tagName;
                continue;
            }
            if (tagName.equals(commonTagName)) continue;
            return null;
        }
        return commonTagName;
    }

    private static int findInsertionPoint(@NotNull List<PTableItem> properties) {
        for (int index = 0; index < MOST_IMPORTANT_ATTRIBUTES.size(); ++index) {
            if (properties.size() > index && properties.get(index).getName().equals(MOST_IMPORTANT_ATTRIBUTES.get(index))) continue;
            return index;
        }
        return MOST_IMPORTANT_ATTRIBUTES.size();
    }
}

