/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ToggleXmlPropertyEditor;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.inspector.NlInspectorProviders;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesManager
extends PropertiesManager<NlPropertiesManager>
implements RenderListener {
    private NlInspectorProviders myInspectorProviders;

    public NlPropertiesManager(@NotNull AndroidFacet facet, @Nullable DesignSurface designSurface, @NotNull Disposable parentDisposable) {
        super(facet, designSurface, NlPropertyEditors.getInstance(facet.getModule().getProject()), parentDisposable);
    }

    @NotNull
    protected NlPropertiesPanel getPropertiesPanel() {
        return (NlPropertiesPanel)super.getPropertiesPanel();
    }

    public void activatePropertySheet() {
        this.getPropertiesPanel().activatePropertySheet();
    }

    public void activateInspector() {
        this.getPropertiesPanel().activateInspector();
    }

    @Override
    public void registerCallbacks(@NotNull ToolWindowCallback toolWindow) {
        this.getPropertiesPanel().registerToolWindow(toolWindow);
    }

    @Override
    @NotNull
    public List<AnAction> getGearActions() {
        return ImmutableList.of((Object)((Object)new ToggleXmlPropertyEditor(this)));
    }

    @Override
    @NotNull
    public List<AnAction> getAdditionalActions() {
        return Collections.singletonList(new ViewAllPropertiesAction(this.getPropertiesPanel()));
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter2) {
        this.getPropertiesPanel().setFilter(filter2);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        return this.getPropertiesPanel().getFilterKeyListener();
    }

    @Override
    protected void setSceneView(@Nullable SceneView sceneView) {
        if (sceneView == this.mySceneView) {
            return;
        }
        assert (sceneView == null || sceneView instanceof ScreenView) : "NlPropertiesManager can only handle ScreenViews";
        if (this.mySceneView != null) {
            ((ScreenView)this.mySceneView).getSceneManager().removeRenderListener(this);
        }
        super.setSceneView(sceneView);
        if (this.mySceneView != null) {
            ((ScreenView)this.mySceneView).getSceneManager().addRenderListener(this);
        }
    }

    @NotNull
    public InspectorPanel getInspector() {
        return this.getPropertiesPanel().getInspector();
    }

    @Override
    public void propertyChanged(@NotNull NlProperty property2, @Nullable String oldValue, @Nullable String newValue) {
        if (property2.getComponents().size() == 1 && "merge".equals(property2.getComponents().get(0).getTagName()) && "http://schemas.android.com/tools".equals(property2.getNamespace()) && "parentTag".equals(property2.getName())) {
            if (this.myInspectorProviders != null) {
                this.myInspectorProviders.resetCache();
            }
            this.updateSelection();
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor") && (NlPropertyItem.isReference(oldValue) || NlPropertyItem.isReference(newValue))) {
            this.updateSelection();
        }
    }

    @Override
    public void resourceChanged(@NotNull ResourceItem item, @Nullable String oldValue, @Nullable String newValue) {
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor") && (NlPropertyItem.isReference(oldValue) || NlPropertyItem.isReference(newValue))) {
            this.updateSelection();
        }
    }

    @Override
    public void logPropertyChange(@NotNull NlProperty property2) {
        NlUsageTracker.getInstance(this.getDesignSurface()).logPropertyChange(property2, this.getPropertiesPanel().getPropertiesViewMode(), this.getPropertiesPanel().getFilterMatchCount());
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        String propertyName;
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component);
        String string = propertyName = handler != null ? handler.getPreferredProperty() : null;
        if (propertyName == null) {
            return false;
        }
        this.getPropertiesPanel().activatePreferredEditor(propertyName, this.myLoading);
        return true;
    }

    @Override
    public void setToolContext(@Nullable DesignSurface designSurface) {
        super.setToolContext(designSurface);
        this.getPropertiesPanel().setToolContext(designSurface);
    }

    @Override
    public void showAccessoryPanel(@NotNull DesignSurface surface, boolean show) {
        this.getPropertiesPanel().showAccessoryPanel(show);
    }

    @Override
    public void onRenderCompleted() {
        this.getPropertiesPanel().modelRendered();
    }

    @NotNull
    protected NlPropertiesPanel createPropertiesPanel() {
        return new NlPropertiesPanel(this);
    }

    @NotNull
    public NlInspectorProviders getInspectorProviders(@NotNull Disposable parentDisposable) {
        if (this.myInspectorProviders == null) {
            this.myInspectorProviders = new NlInspectorProviders(this, parentDisposable);
        }
        return this.myInspectorProviders;
    }
}

