/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.PropertiesPanel;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.property.NlPTable;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyTableBuilder;
import com.android.tools.idea.uibuilder.property.NlXmlPropertyBuilder;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.inspector.NlInspectorPanel;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.CausedFocusEvent;

public class NlPropertiesPanel
extends PropertiesPanel<NlPropertiesManager>
implements ViewAllPropertiesAction.Model {
    static final String PROPERTY_MODE = "properties.mode";
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 50;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 25;
    private final NlPropertiesManager myPropertiesManager;
    private final TableRowSorter<PTableModel> myRowSorter;
    private final MyFilter myFilter;
    private final MyFilterKeyListener myFilterKeyListener;
    private final PTable myTable;
    private final JPanel myTablePanel;
    private final PTableModel myModel;
    private final InspectorPanel<NlPropertiesManager> myInspectorPanel;
    private final JBCardLayout myCardLayout;
    private final JPanel myCardPanel;
    private final PropertyChangeListener myPropertyChangeListener = this::scrollIntoView;
    private List<NlComponent> myComponents;
    private List<NlPropertyItem> myProperties;
    @NotNull
    private PropertiesViewMode myPropertiesViewMode;
    private ToolWindowCallback myToolWindow;
    private AccessoryPanel myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.EAST_PANEL, false);

    public NlPropertiesPanel(@NotNull NlPropertiesManager propertiesManager) {
        this(propertiesManager, new NlPTable(new PTableModel()), null);
    }

    NlPropertiesPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull PTable table2, @Nullable InspectorPanel inspectorPanel) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myPropertiesManager = propertiesManager;
        this.myRowSorter = new TableRowSorter();
        this.myFilter = new MyFilter();
        this.myFilterKeyListener = new MyFilterKeyListener();
        this.myModel = table2.getModel();
        this.myTable = table2;
        this.myTable.getEmptyText().setText("No selected component");
        JComponent fewerPropertiesLink = this.createViewAllPropertiesLinkPanel(false);
        fewerPropertiesLink.setBorder(BorderFactory.createEmptyBorder(8, 4, 2, 0));
        this.myTablePanel = new JPanel(new BorderLayout());
        this.myTablePanel.setVisible(false);
        this.myTablePanel.setBackground(this.myTable.getBackground());
        this.myTablePanel.add((Component)((Object)this.myTable), "North");
        this.myTablePanel.add((Component)fewerPropertiesLink, "South");
        this.myTablePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NlPropertiesPanel.this.myTable.editingStopped(new ChangeEvent(NlPropertiesPanel.this.myTablePanel));
            }
        });
        this.myInspectorPanel = inspectorPanel != null ? inspectorPanel : new NlInspectorPanel(this.myPropertiesManager, this.createViewAllPropertiesLinkPanel(true));
        Disposer.register((Disposable)this.myPropertiesManager, (Disposable)this);
        this.myCardLayout = new JBCardLayout();
        this.myCardPanel = new JPanel((LayoutManager)this.myCardLayout);
        this.myCardPanel.add(PropertiesViewMode.ACCESSORY.name(), this.myAccessoryPanel);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myInspectorPanel, (int)20, (int)31);
        scrollPane.setBorder(null);
        this.myCardPanel.add(PropertiesViewMode.INSPECTOR.name(), scrollPane);
        JScrollPane tableScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTablePanel);
        tableScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        tableScrollPane.getVerticalScrollBar().setBlockIncrement(25);
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myCardPanel.add(PropertiesViewMode.TABLE.name(), tableScrollPane);
        this.myPropertiesViewMode = NlPropertiesPanel.getPropertiesViewModeInitially();
        this.myCardLayout.show((Container)this.myCardPanel, this.myPropertiesViewMode.name());
        this.myComponents = Collections.emptyList();
        this.myProperties = Collections.emptyList();
        this.add((Component)this.myCardPanel, "Center");
    }

    public void dispose() {
        JBCardLayout layout2 = (JBCardLayout)this.myCardPanel.getLayout();
        layout2.first((Container)this.myCardPanel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.myPropertyChangeListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.myPropertyChangeListener);
    }

    @NotNull
    public NlPropertiesManager getPropertiesManager() {
        return this.myPropertiesManager;
    }

    public void registerToolWindow(@NotNull ToolWindowCallback toolWindow) {
        this.myToolWindow = toolWindow;
    }

    public int getFilterMatchCount() {
        if (this.myTable.getRowSorter() == null) {
            return -1;
        }
        return this.myTable.getRowCount();
    }

    public void setFilter(@NotNull String filter2) {
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        if (filter2.isEmpty()) {
            this.myTable.setRowSorter(null);
        } else {
            this.myFilter.setPattern(filter2);
            this.myRowSorter.setModel(this.myModel);
            this.myRowSorter.setRowFilter(this.myFilter);
            this.myRowSorter.setSortKeys(null);
            this.myTable.setRowSorter(this.myRowSorter);
        }
        this.myTable.restoreSelection(selectedRow, selectedItem);
        this.myInspectorPanel.setFilter(filter2);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        return this.myFilterKeyListener;
    }

    private void enterInFilter(@NotNull KeyEvent event) {
        PTableItem item;
        if (!(this.myTable.getRowCount() == 1 || (item = (PTableItem)this.myTable.getValueAt(0, 1)).isExpanded() && this.myTable.getRowCount() == item.getChildren().size() + 1)) {
            return;
        }
        if (this.myTable.isCellEditable(0, 1)) {
            this.myTable.editCellAt(0, 1);
            this.myTable.transferFocus();
        } else {
            this.myModel.expand(this.myTable.convertRowIndexToModel(0));
            this.myTable.requestFocus();
            this.myTable.setRowSelectionInterval(0, 0);
        }
        event.consume();
    }

    public void activatePropertySheet() {
        this.setAllPropertiesPanelVisible(true);
    }

    public void activateInspector() {
        this.setAllPropertiesPanelVisible(false);
    }

    @Override
    public void setItems(@NotNull List<NlComponent> components, @NotNull Table<String, String, NlPropertyItem> properties) {
        this.myComponents = components;
        this.myProperties = NlPropertiesPanel.extractPropertiesForTable(properties);
        Project project = this.myPropertiesManager.getProject();
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor")) {
            this.myTablePanel.setVisible(new NlXmlPropertyBuilder(this.myPropertiesManager, this.myTable, components, properties).build());
        } else {
            this.myTablePanel.setVisible(new NlPropertyTableBuilder(project, this.myTable, components, this.myProperties).build());
        }
        this.updateDefaultProperties(this.myPropertiesManager);
        this.myInspectorPanel.setComponent(components, properties, this.myPropertiesManager);
        this.setFilter(this.myFilter.myPattern);
    }

    @NotNull
    private static List<NlPropertyItem> extractPropertiesForTable(@NotNull Table<String, String, NlPropertyItem> properties) {
        Map androidProperties = properties.row((Object)"http://schemas.android.com/apk/res/android");
        Map autoProperties = properties.row((Object)"http://schemas.android.com/apk/res-auto");
        Map designProperties = properties.row((Object)"http://schemas.android.com/tools");
        Map bareProperties = properties.row((Object)"");
        ArrayList<NlPropertyItem> result2 = new ArrayList<NlPropertyItem>(properties.size());
        result2.addAll(autoProperties.values());
        for (Map.Entry entry : androidProperties.entrySet()) {
            if (autoProperties.containsKey(entry.getKey())) continue;
            result2.add((NlPropertyItem)entry.getValue());
        }
        result2.addAll(designProperties.values());
        result2.addAll(bareProperties.values());
        return result2;
    }

    @Override
    public void modelRendered() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor")) {
                this.myPropertiesManager.updateSelection();
            } else {
                this.updateDefaultProperties(this.myPropertiesManager);
            }
            this.myInspectorPanel.refresh();
        });
    }

    private void updateDefaultProperties(@NotNull PropertiesManager<?> propertiesManager) {
        if (this.myComponents.isEmpty() || this.myProperties.isEmpty()) {
            return;
        }
        Map<ResourceReference, ResourceValue> defaultValues = propertiesManager.getDefaultProperties(this.myComponents);
        String style = propertiesManager.getDefaultStyle(this.myComponents);
        if (style == null && defaultValues.isEmpty()) {
            return;
        }
        for (NlPropertyItem property2 : this.myProperties) {
            if (property2.getName().equals("style") && StringUtil.isEmpty((String)property2.getNamespace()) && !StringUtil.isEmpty((String)style)) {
                style = style.startsWith("android:") ? "?android:attr/" + StringUtil.trimStart((String)style, (String)"android:") : "?attr/" + style;
                property2.setDefaultValue(style);
                continue;
            }
            property2.setDefaultValue(this.getDefaultProperty(defaultValues, property2));
        }
    }

    @Nullable
    private String getDefaultProperty(@NotNull Map<ResourceReference, ResourceValue> defaultValues, @NotNull NlProperty property2) {
        String namespaceUri = property2.getNamespace();
        if (namespaceUri == null) {
            return null;
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
        if (namespace == null) {
            return null;
        }
        XmlTag tag = property2.getTag();
        if (tag == null || !tag.isValid()) {
            return null;
        }
        ResourceValue value2 = defaultValues.get(ResourceReference.attr((ResourceNamespace)namespace, (String)property2.getName()));
        if (value2 == null) {
            return null;
        }
        ResourceNamespace.Resolver resolver = ResourceHelper.getNamespaceResolver((XmlElement)tag);
        ResourceNamespace defaultNamespace2 = ResourceRepositoryManager.getInstance(this.myPropertiesManager.getFacet()).getNamespace();
        if (value2.getResourceType() == ResourceType.STYLE_ITEM) {
            ResourceReference reference2 = value2.getReference();
            if (reference2 == null) {
                return null;
            }
            ResourceUrl url = reference2.getRelativeResourceUrl(defaultNamespace2, resolver);
            return url.type != ResourceType.ATTR ? url.toString() : ResourceUrl.createThemeReference((String)url.namespace, (ResourceType)url.type, (String)url.name).toString();
        }
        return value2.asReference().getRelativeResourceUrl(defaultNamespace2, resolver).toString();
    }

    @NotNull
    private JComponent createViewAllPropertiesLinkPanel(boolean viewAllProperties) {
        HyperlinkLabel textLink = new HyperlinkLabel();
        textLink.setHyperlinkText(viewAllProperties ? "View all attributes" : "View fewer attributes");
        textLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        textLink.setFocusable(false);
        HyperlinkLabel iconLink = new HyperlinkLabel();
        iconLink.setIcon(StudioIcons.LayoutEditor.Properties.TOGGLE_PROPERTIES);
        iconLink.setFocusable(false);
        iconLink.setUseIconAsLink(true);
        iconLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        JPanel linkPanel = new JPanel(new FlowLayout(0, 0, 0));
        linkPanel.setOpaque(false);
        linkPanel.add((Component)textLink);
        linkPanel.add((Component)iconLink);
        return linkPanel;
    }

    private void setAllPropertiesPanelVisible(@NotNull HyperlinkEvent event, boolean viewAllProperties) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setAllPropertiesPanelVisible(viewAllProperties);
        }
    }

    @Override
    public boolean isAllPropertiesPanelMode() {
        return this.myPropertiesViewMode == PropertiesViewMode.TABLE;
    }

    public void setToolContext(@Nullable DesignSurface surface) {
        this.myAccessoryPanel.setSurface((NlDesignSurface)surface);
    }

    @Override
    public void setAllPropertiesPanelVisible(boolean viewAllProperties) {
        Object next = viewAllProperties ? this.myTable : this.myInspectorPanel;
        this.setAllPropertiesPanelVisibleInternal(viewAllProperties, ((Component)next)::requestFocus);
    }

    @Override
    public boolean isAccessoryPanelVisible() {
        return this.myPropertiesViewMode == PropertiesViewMode.ACCESSORY;
    }

    private void setAllPropertiesPanelVisibleInternal(boolean viewAllProperties, @Nullable Runnable onDone) {
        this.myPropertiesViewMode = viewAllProperties ? PropertiesViewMode.TABLE : PropertiesViewMode.INSPECTOR;
        this.myCardLayout.swipe((Container)this.myCardPanel, this.myPropertiesViewMode.name(), JBCardLayout.SwipeDirection.AUTO, onDone);
        PropertiesComponent.getInstance().setValue(PROPERTY_MODE, this.myPropertiesViewMode.name());
    }

    public void showAccessoryPanel(boolean show) {
        if (!show && this.myPropertiesViewMode != PropertiesViewMode.ACCESSORY) {
            return;
        }
        this.myPropertiesViewMode = show ? PropertiesViewMode.ACCESSORY : PropertiesViewMode.INSPECTOR;
        Object next = show ? this.myAccessoryPanel : this.myInspectorPanel;
        this.myCardLayout.swipe((Container)this.myCardPanel, this.myPropertiesViewMode.name(), JBCardLayout.SwipeDirection.AUTO, ((Component)next)::requestFocus);
    }

    @NotNull
    public PropertiesViewMode getPropertiesViewMode() {
        return this.myPropertiesViewMode;
    }

    @NotNull
    private static PropertiesViewMode getPropertiesViewModeInitially() {
        PropertiesViewMode mode;
        String name = PropertiesComponent.getInstance().getValue(PROPERTY_MODE, PropertiesViewMode.INSPECTOR.name());
        try {
            mode = PropertiesViewMode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            mode = PropertiesViewMode.INSPECTOR;
            Logger.getInstance(NlPropertiesPanel.class).warn("There is no PropertiesViewMode called " + name + ", uses " + mode.name() + " instead", (Throwable)e);
            PropertiesComponent.getInstance().setValue(PROPERTY_MODE, mode.name());
        }
        return mode;
    }

    @Override
    public void activatePreferredEditor(@NotNull String propertyName, boolean afterload) {
        Runnable selectEditor = () -> {
            if (this.myToolWindow != null) {
                this.myToolWindow.restore();
            }
            this.myInspectorPanel.activatePreferredEditor(propertyName, afterload);
        };
        if (!this.isAllPropertiesPanelMode()) {
            selectEditor.run();
        } else {
            this.setAllPropertiesPanelVisibleInternal(false, selectEditor);
        }
    }

    private void scrollIntoView(@NotNull PropertyChangeEvent event) {
        if (this.needToScrollInView(event)) {
            Component newFocusedComponent = (Component)event.getNewValue();
            JComponent parent = (JComponent)newFocusedComponent.getParent();
            Rectangle bounds = newFocusedComponent.getBounds();
            if (newFocusedComponent == this.myTable) {
                bounds = this.myTable.getCellRect(this.myTable.getSelectedRow(), 1, true);
                bounds.x = 0;
            }
            parent.scrollRectToVisible(bounds);
        }
    }

    private boolean needToScrollInView(@NotNull PropertyChangeEvent event) {
        AWTEvent awtEvent = EventQueue.getCurrentEvent();
        if (!"focusOwner".equals(event.getPropertyName()) || !(event.getNewValue() instanceof Component)) {
            return false;
        }
        Component newFocusedComponent = (Component)event.getNewValue();
        if (!(this.isAncestorOf(newFocusedComponent) && newFocusedComponent.getParent() instanceof JComponent && awtEvent instanceof CausedFocusEvent)) {
            return false;
        }
        CausedFocusEvent focusEvent = (CausedFocusEvent)awtEvent;
        switch (focusEvent.getCause()) {
            case TRAVERSAL: 
            case TRAVERSAL_UP: 
            case TRAVERSAL_DOWN: 
            case TRAVERSAL_FORWARD: 
            case TRAVERSAL_BACKWARD: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public InspectorPanel getInspector() {
        return this.myInspectorPanel;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return false;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return false;
    }

    public void performCopy(@NotNull DataContext dataContext) {
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        return false;
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        return false;
    }

    public void performCut(@NotNull DataContext dataContext) {
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return false;
    }

    public void performPaste(@NotNull DataContext dataContext) {
    }

    public PTable getTable() {
        return this.myTable;
    }

    private class MyFilterKeyListener
    extends KeyAdapter {
        private MyFilterKeyListener() {
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (!NlPropertiesPanel.this.myFilter.myPattern.isEmpty() && event.getKeyCode() == 10 && event.getModifiers() == 0) {
                if (NlPropertiesPanel.this.myPropertiesViewMode == PropertiesViewMode.TABLE) {
                    NlPropertiesPanel.this.enterInFilter(event);
                } else {
                    NlPropertiesPanel.this.myInspectorPanel.enterInFilter(event);
                }
            }
        }
    }

    static class MyFilter
    extends RowFilter<PTableModel, Integer> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern = "";

        MyFilter() {
        }

        void setPattern(@NotNull String pattern) {
            this.myPattern = pattern;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends PTableModel, ? extends Integer> entry) {
            PTableItem item = (PTableItem)entry.getValue(0);
            if (this.isMatch(item.getName())) {
                return true;
            }
            if (item.getParent() != null && this.isMatch(item.getParent().getName())) {
                return true;
            }
            if (!(item instanceof PTableGroupItem)) {
                return false;
            }
            PTableGroupItem group = (PTableGroupItem)item;
            for (PTableItem child : group.getChildren()) {
                if (!this.isMatch(child.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean isMatch(@NotNull String text) {
            return this.myComparator.matchingFragments(this.myPattern, text) != null;
        }
    }

    public static enum PropertiesViewMode {
        TABLE,
        INSPECTOR,
        ACCESSORY;

    }
}

