/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.property.NlPTableGroupItem;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellRenderer;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Predicate;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class NlPropertyAccumulator {
    private static final TableCellRenderer EMPTY_VALUE_RENDERER = NlPropertyAccumulator.createTableCellRenderer();
    private final String myGroupName;
    private final String myPrefix;
    private final Predicate<NlPropertyItem> myFilter;
    private PTableGroupItem myGroupNode;

    public NlPropertyAccumulator(@NotNull String groupName, @NotNull String prefix) {
        this.myGroupName = groupName;
        this.myPrefix = prefix;
        this.myFilter = null;
    }

    public NlPropertyAccumulator(@NotNull String groupName, @NotNull String prefix, @NotNull Predicate<NlPropertyItem> isApplicable) {
        this.myGroupName = groupName;
        this.myPrefix = prefix;
        this.myFilter = isApplicable;
    }

    protected boolean isApplicable(@NotNull NlPropertyItem p) {
        assert (this.myFilter != null);
        return this.myFilter.test(p);
    }

    public boolean process(@NotNull NlPropertyItem p) {
        if (!this.isApplicable(p)) {
            return false;
        }
        if (this.myGroupNode == null) {
            this.myGroupNode = this.createGroupNode(this.myGroupName, this.myPrefix);
        }
        this.myGroupNode.addChild(p);
        return true;
    }

    public boolean hasItems() {
        return this.myGroupNode != null && !this.myGroupNode.getChildren().isEmpty();
    }

    @NotNull
    public PTableGroupItem getGroupNode() {
        return this.myGroupNode == null ? this.createGroupNode(this.myGroupName, this.myPrefix) : this.myGroupNode;
    }

    @NotNull
    protected PTableGroupItem createGroupNode(@NotNull String groupName, @NotNull String prefix) {
        return new AccumulatorGroupNode(groupName, prefix);
    }

    private static TableCellRenderer createTableCellRenderer() {
        return new PTableCellRenderer(){

            @Override
            protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem value2, boolean selected, boolean hasFocus, int row, int column) {
            }
        };
    }

    public static class PropertyNamePrefixAccumulator
    extends NlPropertyAccumulator {
        public PropertyNamePrefixAccumulator(@NotNull String groupName, @NotNull String prefix) {
            super(groupName, prefix, p -> p != null && p.getName().startsWith(prefix));
        }
    }

    static class AccumulatorGroupNode
    extends NlPTableGroupItem {
        private final String myName;
        private final String myPrefix;

        AccumulatorGroupNode(@NotNull String name, @NotNull String prefix) {
            this.myName = name;
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        @NotNull
        public String getChildLabel(@NotNull PTableItem item) {
            String label = StringUtil.trimStart((String)item.getName(), (String)this.myPrefix);
            if (label.isEmpty()) {
                return "all";
            }
            return StringUtil.decapitalize((String)label);
        }

        @Override
        @NotNull
        public TableCellRenderer getCellRenderer() {
            return EMPTY_VALUE_RENDERER;
        }
    }
}

