/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlIdPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.StarState;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertyItem
extends PTableItem
implements NlProperty {
    private static final Set<String> ATTRS_WITHOUT_DEFINITIONS = ImmutableSet.of((Object)"style", (Object)"class", (Object)"layout");
    @NotNull
    protected final List<NlComponent> myComponents;
    @Nullable
    protected final PropertiesManager myPropertiesManager;
    @Nullable
    protected final AttributeDefinition myDefinition;
    @NotNull
    private final String myName;
    @Nullable
    private final String myNamespace;
    @Nullable
    private String myDefaultValue;
    @NotNull
    private StarState myStarState;

    public static NlPropertyItem create(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @Nullable PropertiesManager propertiesManager) {
        if (attributeDefinition != null && attributeDefinition.getFormats().contains(AttributeFormat.FLAGS)) {
            return new NlFlagPropertyItem(name, attributeDefinition, components, propertiesManager);
        }
        if (name.getLocalName().equals("id")) {
            return new NlIdPropertyItem(name, attributeDefinition, components, propertiesManager);
        }
        return new NlPropertyItem(name, attributeDefinition, components, propertiesManager);
    }

    public static boolean isDefinitionAcceptable(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition) {
        return attributeDefinition != null || ATTRS_WITHOUT_DEFINITIONS.contains(name.getLocalName()) || "http://schemas.android.com/tools".equals(name.getNamespaceKey());
    }

    protected NlPropertyItem(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @Nullable PropertiesManager propertiesManager) {
        assert (!components.isEmpty());
        if (!NlPropertyItem.isDefinitionAcceptable(name, attributeDefinition)) {
            throw new IllegalArgumentException("Missing attribute definition for " + name.getLocalName());
        }
        this.myComponents = components;
        this.myPropertiesManager = propertiesManager;
        this.myName = name.getLocalName();
        this.myNamespace = name.getNamespaceKey();
        this.myDefinition = attributeDefinition;
        this.myStarState = StarState.STAR_ABLE;
    }

    protected NlPropertyItem(@NotNull NlPropertyItem property2, @NotNull String namespace) {
        assert (!property2.myComponents.isEmpty());
        this.myComponents = property2.myComponents;
        this.myPropertiesManager = property2.myPropertiesManager;
        this.myName = property2.myName;
        this.myNamespace = namespace;
        this.myDefinition = property2.myDefinition;
        this.myStarState = StarState.STAR_ABLE;
        if (property2.getParent() != null) {
            PTableGroupItem group = (PTableGroupItem)property2.getParent();
            group.addChild(this, property2);
        }
    }

    public boolean sameDefinition(@Nullable NlPropertyItem other) {
        return other != null && Objects.equal((Object)this.myName, (Object)other.myName) && Objects.equal((Object)this.myNamespace, (Object)other.myNamespace) && this.myDefinition == other.myDefinition;
    }

    @Override
    @NotNull
    public List<NlComponent> getComponents() {
        return this.myComponents;
    }

    @Override
    @NotNull
    public StarState getStarState() {
        return this.myStarState;
    }

    public void setInitialStarred() {
        this.myStarState = StarState.STARRED;
    }

    @Override
    public void setStarState(@NotNull StarState starState) {
        this.myStarState = starState;
        if (this.myPropertiesManager != null) {
            NlProperties.saveStarState(this.myNamespace, this.myName, starState == StarState.STARRED, this.myPropertiesManager);
            this.myPropertiesManager.starStateChanged();
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getValue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String prev = null;
        for (NlComponent component : this.myComponents) {
            String value2 = component.getAttribute(this.myNamespace, this.myName);
            if (value2 == null) {
                return null;
            }
            if (prev == null) {
                prev = value2;
                continue;
            }
            if (value2.equals(prev)) continue;
            return null;
        }
        return prev;
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        return this.resolveValue(this.getValue());
    }

    @Override
    public boolean isDefaultValue(@Nullable String value2) {
        if (value2 == null) {
            return true;
        }
        if (this.myDefaultValue == null) {
            return false;
        }
        return value2.equals(this.myDefaultValue);
    }

    @Override
    @Nullable
    public String resolveValue(@Nullable String value2) {
        if (this.myDefaultValue != null && this.isDefaultValue(value2)) {
            value2 = this.myDefaultValue;
        }
        return value2 != null ? this.resolveValueUsingResolver(value2) : null;
    }

    @Override
    public void mouseMoved(@NotNull PTable table2, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        NlAttributeRenderer renderer = NlPropertyRenderers.getInstance().get(this);
        renderer.mouseMoved(table2, event, rectRightColumn);
    }

    public void delete() {
        PTableGroupItem group = (PTableGroupItem)this.getParent();
        if (group != null) {
            group.deleteChild(this);
        }
    }

    public static boolean isReference(@Nullable String value2) {
        return value2 != null && (value2.startsWith("?") || value2.startsWith("@") && !NlPropertyItem.isId(value2));
    }

    @NotNull
    private String resolveValueUsingResolver(@NotNull String value2) {
        ResourceResolver resolver;
        if (NlPropertyItem.isReference(value2) && (resolver = this.getResolver()) != null) {
            ResourceValue resource = resolver.findResValue(value2, false);
            if (resource == null) {
                resource = resolver.findResValue(value2, true);
            }
            if (resource != null) {
                ResourceValue resolved;
                if (resource.getValue() != null) {
                    String string = value2 = resource.getResourceType() == ResourceType.FONT ? resource.getName() : resource.getValue();
                    if (resource.isFramework()) {
                        value2 = NlPropertyItem.addAndroidPrefix(value2);
                    }
                }
                if ((resolved = resolver.resolveResValue(resource)) != null && resolved.getValue() != null) {
                    String string = value2 = resolved.getResourceType() == ResourceType.FONT ? resolved.getName() : resolved.getValue();
                    if (resource.isFramework()) {
                        value2 = NlPropertyItem.addAndroidPrefix(value2);
                    }
                }
            }
        }
        return value2;
    }

    @NotNull
    private static String addAndroidPrefix(@NotNull String value2) {
        if (value2.startsWith("@") && !value2.startsWith("@android:")) {
            return "@android:" + value2.substring(1);
        }
        return value2;
    }

    private static boolean isId(@NotNull String value2) {
        return value2.startsWith("@id/") || value2.startsWith("@+id/") || value2.startsWith("@android:id/") || value2.startsWith("@android:+id/");
    }

    @Override
    @NotNull
    public NlProperty getChildProperty(@NotNull String itemName) {
        throw new UnsupportedOperationException(itemName);
    }

    @Override
    @NotNull
    public NlPropertyItem getDesignTimeProperty() {
        if ("http://schemas.android.com/tools".equals(this.myNamespace)) {
            return this;
        }
        return new NlPropertyItem(this, "http://schemas.android.com/tools");
    }

    @Override
    @NotNull
    public NlModel getModel() {
        return this.myComponents.get(0).getModel();
    }

    @Override
    @Nullable
    public XmlTag getTag() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NlComponent component = this.myComponents.size() == 1 ? this.myComponents.get(0) : null;
        return component != null ? component.getBackend().getTag() : null;
    }

    @Override
    @Nullable
    public String getTagName() {
        String tagName = null;
        for (NlComponent component : this.myComponents) {
            if (tagName == null) {
                tagName = component.getTagName();
                continue;
            }
            if (tagName.equals(component.getTagName())) continue;
            return null;
        }
        return tagName;
    }

    @Override
    @Nullable
    public ResourceResolver getResolver() {
        Configuration configuration = this.getModel().getConfiguration();
        return configuration.getResourceResolver();
    }

    @Override
    public void setValue(@Nullable Object value2) {
        String strValue;
        String string = strValue = value2 == null ? null : value2.toString();
        if (StringUtil.isEmpty((String)strValue) || this.isDefaultValue(strValue) && !this.isBooleanEditor()) {
            strValue = null;
        }
        this.setValueIgnoreDefaultValue(strValue, null);
    }

    private boolean isBooleanEditor() {
        return this.myDefinition != null && this.myDefinition.getFormats().contains(AttributeFormat.BOOLEAN);
    }

    protected void setValueIgnoreDefaultValue(@Nullable String attrValue, @Nullable Runnable valueUpdated) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        if (this.getModel().getProject().isDisposed()) {
            return;
        }
        String attrValueWithUnit = attrValue != null ? Quantity.addUnit(this, attrValue) : null;
        String oldValue = this.getValue();
        String componentName = this.myComponents.size() == 1 ? this.myComponents.get(0).getTagName() : "Multiple";
        NlWriteCommandActionUtil.run(this.myComponents, "Set " + componentName + '.' + this.myName + " to " + attrValueWithUnit, () -> {
            this.myComponents.forEach(component -> component.setAttribute(this.myNamespace, this.myName, attrValueWithUnit));
            if (this.myPropertiesManager != null) {
                this.myPropertiesManager.propertyChanged(this, oldValue, attrValueWithUnit);
            }
            if (valueUpdated == null) {
                return;
            }
            valueUpdated.run();
        });
        if (this.myPropertiesManager != null) {
            this.myPropertiesManager.logPropertyChange(this);
        }
    }

    boolean isThemeAttribute() {
        AttributeDefinitions definitions;
        StyleableDefinition theme;
        AndroidFacet facet = this.myComponents.get(0).getModel().getFacet();
        FrameworkResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
        if (resourceManager != null && (theme = (definitions = resourceManager.getAttributeDefinitions()).getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme"))) != null) {
            return theme.getAttributes().contains(this.myDefinition);
        }
        return false;
    }

    @Override
    @Nullable
    public AttributeDefinition getDefinition() {
        return this.myDefinition;
    }

    @Override
    public boolean isEditable(int column) {
        return column == 1;
    }

    public String toString() {
        return NlPropertyItem.namespaceToPrefix(this.myNamespace) + this.myName;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        String value2;
        StringBuilder sb = new StringBuilder(100);
        sb.append(NlPropertyItem.namespaceToPrefix(this.myNamespace));
        sb.append(this.myName);
        if (this.myDefinition != null && (value2 = this.myDefinition.getDescription(null)) != null) {
            sb.append(": ");
            sb.append(value2);
        }
        return sb.toString();
    }

    @NotNull
    static String namespaceToPrefix(@Nullable String namespace) {
        if (namespace == null) {
            return "";
        }
        if (namespace.equalsIgnoreCase("http://schemas.android.com/apk/res/android")) {
            return "@android:";
        }
        if (namespace.equalsIgnoreCase("http://schemas.android.com/apk/res-auto")) {
            return "@app:";
        }
        return "";
    }
}

