/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertiesSorter;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NlPropertyTableBuilder {
    private final Project myProject;
    private final PTable myTable;
    private final List<NlComponent> myComponents;
    private final List<NlPropertyItem> myProperties;

    NlPropertyTableBuilder(@NotNull Project project, @NotNull PTable table2, @NotNull List<NlComponent> components, @NotNull List<NlPropertyItem> properties) {
        this.myProject = project;
        this.myTable = table2;
        this.myComponents = components;
        this.myProperties = properties;
    }

    public boolean build() {
        List<PTableItem> groupedProperties;
        if (this.myComponents.isEmpty()) {
            groupedProperties = Collections.emptyList();
        } else {
            List<NlPropertyItem> sortedProperties = new NlPropertiesSorter().sort(this.myProperties, this.myComponents);
            groupedProperties = new NlPropertiesGrouper().group(sortedProperties, this.myComponents);
        }
        if (this.myTable.isEditing()) {
            this.myTable.removeEditor();
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        this.myTable.getModel().setItems(groupedProperties);
        this.myTable.setRendererProvider(NlPropertyRenderers.getInstance());
        this.myTable.setEditorProvider(NlPropertyEditors.getInstance(this.myProject));
        if (this.myTable.getRowCount() > 0) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        return !groupedProperties.isEmpty();
    }
}

