/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.property.AddPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlResourceHeader;
import com.android.tools.idea.uibuilder.property.NlResourceItem;
import com.android.tools.idea.uibuilder.property.editors.NlXmlEditors;
import com.android.tools.idea.uibuilder.property.renderer.NlXmlRenderers;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableItem;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.formatter.AttributeComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlXmlPropertyBuilder {
    private static final Pattern INTELLIJ_LIBRARY_NAME_PATTERN = Pattern.compile("(.+)-\\d+\\.\\d+\\.\\d+(-.+)");
    private final PropertiesManager myPropertiesManager;
    private final PTable myTable;
    private final List<NlComponent> myComponents;
    private final Table<String, String, NlPropertyItem> myProperties;
    private final Multimap<String, NlResourceItem> mySliceMap;

    NlXmlPropertyBuilder(@NotNull PropertiesManager propertiesManager, @NotNull PTable table2, @NotNull List<NlComponent> components, Table<String, String, NlPropertyItem> properties) {
        this.myPropertiesManager = propertiesManager;
        this.myTable = table2;
        this.myComponents = components;
        this.myProperties = properties;
        this.mySliceMap = TreeMultimap.create(String::compareTo, NlResourceItem::compareTo);
    }

    public boolean build() {
        this.myTable.setVisible(!this.myComponents.isEmpty());
        if (this.myComponents.isEmpty()) {
            return false;
        }
        ArrayList<PTableItem> items2 = new ArrayList<PTableItem>();
        for (Object item : this.myProperties.values()) {
            if (((NlPropertyItem)item).getValue() == null) continue;
            this.resolveValue((NlPropertyItem)item);
            items2.add((PTableItem)item);
        }
        items2.sort(new AttributeComparator<PTableItem>(property2 -> property2.getName()));
        NlComponent component = this.myComponents.get(0);
        items2.add(0, new NlResourceHeader(NlXmlPropertyBuilder.generateFileHeader(component.getModel().getVirtualFile().getPath())));
        items2.add(new AddPropertyItem(this.myProperties));
        for (String header : this.mySliceMap.keySet()) {
            items2.add(new NlResourceHeader(header));
            items2.addAll(this.mySliceMap.get((Object)header));
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        int editingRow = this.myTable.getEditingRow();
        PTableItem editingItem = editingRow >= 0 ? this.myTable.getItemAt(editingRow) : null;
        this.myTable.setRendererProvider(NlXmlRenderers.getInstance());
        this.myTable.getModel().setItems(items2);
        this.myTable.setEditorProvider(NlXmlEditors.getInstance(this.myPropertiesManager.getProject()));
        if (this.myTable.getRowCount() > 0 && !this.restoreEditing(editingRow, editingItem)) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        return true;
    }

    private void resolveValue(@NotNull NlPropertyItem property2) {
        AndroidFacet facet = property2.getModel().getFacet();
        LocalResourceRepository resourceRepository = ResourceRepositoryManager.getProjectResources(facet);
        ResourceResolver resolver = property2.getResolver();
        if (resolver == null) {
            return;
        }
        String value2 = property2.getValue();
        while (!StringUtil.isEmpty((String)value2) && NlPropertyItem.isReference(value2)) {
            ResourceValue resource = resolver.findResValue(value2, false);
            if (resource == null) {
                resource = resolver.findResValue(value2, true);
            }
            if (resource == null) {
                return;
            }
            ResourceItem item = NlXmlPropertyBuilder.findUserDefinedResourceItem(resourceRepository, resource);
            NlResourceItem row = new NlResourceItem(facet, resource, item, this.myPropertiesManager);
            value2 = row.getValue();
            if (StringUtil.isEmpty((String)row.getValue())) {
                return;
            }
            this.mySliceMap.put((Object)NlXmlPropertyBuilder.generateHeader(resource, item), (Object)row);
        }
    }

    private boolean restoreEditing(int editingRow, PTableItem editingItem) {
        if (editingRow < 0) {
            return false;
        }
        PTableItem currentItem = this.myTable.getItemAt(editingRow);
        if (currentItem == null || !editingItem.getClass().equals(currentItem.getClass())) {
            this.myTable.editingCanceled(null);
            return false;
        }
        this.myTable.restoreSelection(editingRow, editingItem);
        return true;
    }

    @Nullable
    private static ResourceItem findUserDefinedResourceItem(@NotNull LocalResourceRepository resourceRepository, @NotNull ResourceValue resource) {
        if (resource.isFramework() || resource.getLibraryName() != null) {
            return null;
        }
        List<ResourceItem> items2 = resourceRepository.getResources(ResourceNamespace.TODO(), resource.getResourceType(), resource.getName());
        for (ResourceItem item : items2) {
            if (item.getResourceValue() != resource) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private static String generateHeader(@NotNull ResourceValue resource, @Nullable ResourceItem item) {
        ResourceType resourceType = resource.getResourceType();
        String type = "<" + resource.getResourceType().getName() + ">";
        if (resource.isFramework()) {
            return "android " + type;
        }
        if (!StringUtil.isEmpty((String)resource.getLibraryName())) {
            return NlXmlPropertyBuilder.formatLibraryName(resource.getLibraryName()) + " " + type;
        }
        if (item != null && item.getSource() != null) {
            return NlXmlPropertyBuilder.generateFileHeader(item.getSource().getNativePath());
        }
        return type;
    }

    private static String generateFileHeader(@NotNull String path) {
        String fileName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getFileName((String)PathUtil.getParentPath((String)path));
        return parentPath + "/" + fileName;
    }

    @NotNull
    private static String formatLibraryName(@NotNull String libraryName) {
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)libraryName);
        if (coordinate != null) {
            String artifact = coordinate.getArtifactId();
            return !StringUtil.isEmpty((String)artifact) ? artifact : libraryName;
        }
        Matcher matcher = INTELLIJ_LIBRARY_NAME_PATTERN.matcher(libraryName);
        if (matcher.find()) {
            String artifact = matcher.group(1);
            return !StringUtil.isEmpty((String)artifact) ? artifact : libraryName;
        }
        return libraryName;
    }
}

