/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

public class ViewAllPropertiesAction
extends ToggleAction {
    public static final String VIEW_ALL_ATTRIBUTES = "View all attributes";
    public static final String VIEW_FEWER_ATTRIBUTES = "View fewer attributes";
    public static final String VIEW_XML_ATTRIBUTES = "View XML attributes";
    private final Model myModel;

    public ViewAllPropertiesAction(@NotNull Model model2) {
        this.myModel = model2;
        Presentation presentation = this.getTemplatePresentation();
        String text = this.getActualText();
        presentation.setText(text);
        presentation.setDescription(text);
        presentation.setIcon(StudioIcons.LayoutEditor.Properties.TOGGLE_PROPERTIES);
    }

    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        String text = this.getActualText();
        presentation.setText(text);
        presentation.setDescription(text);
    }

    @NotNull
    private String getActualText() {
        if (this.myModel.isAllPropertiesPanelMode()) {
            return VIEW_FEWER_ATTRIBUTES;
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        return properties.getBoolean("NlXmlPropertyEditor") ? VIEW_XML_ATTRIBUTES : VIEW_ALL_ATTRIBUTES;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.myModel.isAllPropertiesPanelMode();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (!this.myModel.isAccessoryPanelVisible()) {
            this.myModel.setAllPropertiesPanelVisible(state);
        }
    }

    public boolean isDumbAware() {
        return true;
    }

    public static interface Model {
        public boolean isAllPropertiesPanelMode();

        public void setAllPropertiesPanelVisible(boolean var1);

        public boolean isAccessoryPanelVisible();
    }
}

