/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.AddPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.TextEditorWithAutoCompletion;
import com.android.tools.idea.uibuilder.property.renderer.NlXmlNameRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddPropertyEditor
extends NlReferenceEditor {
    private AddPropertyItem myItem;

    public static NlTableCellEditor create(@NotNull Project project) {
        NlAddPropertyTableCellEditor cellEditor = new NlAddPropertyTableCellEditor();
        cellEditor.init(new AddPropertyEditor(project, cellEditor), null);
        return cellEditor;
    }

    protected AddPropertyEditor(@NotNull Project project, @NotNull NlEditingListener listener2) {
        super(project, listener2, null, false, false, false, 3);
    }

    private JComponent startEditing(@NotNull AddPropertyItem item) {
        this.myItem = item;
        TextEditorWithAutoCompletion textEditor = this.getTextEditor();
        textEditor.updateCompletions(item.getUnspecifiedProperties());
        textEditor.setText(item.getName());
        textEditor.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        textEditor.setFontStyle(1);
        textEditor.setTextColor((Color)NlXmlNameRenderer.ATTRIBUTE_COLOR);
        return this.getComponent();
    }

    @Override
    protected void editorFocusGain(@NotNull FocusEvent event) {
    }

    @Override
    protected void editorFocusLost(@NotNull FocusEvent event) {
        this.myItem.updateProperty();
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myItem.setValue(newValue);
        this.cancelEditing();
    }

    @Override
    protected void cancel() {
        this.myItem.setValue("");
        this.cancelEditing();
    }

    private static class NlAddPropertyTableCellEditor
    extends NlTableCellEditor {
        private NlAddPropertyTableCellEditor() {
        }

        @Override
        @Nullable
        public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, int row, int column) {
            AddPropertyItem item = (AddPropertyItem)value2;
            AddPropertyEditor editor2 = (AddPropertyEditor)this.getEditor();
            this.startCellEditing(table2, row);
            return editor2.startEditing(item);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

