/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.resources.ResourceType;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.api.AttributeBrowser;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.PropertyDesignState;
import com.android.tools.property.ptable.PTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.BoxLayout;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowsePanel
extends AdtSecondaryPanel {
    private final Context myContext;
    private final ActionButton myBrowseButton;
    private final ActionButton myDesignButton;
    private PropertyDesignState myDesignState;

    public BrowsePanel() {
        this(null, true);
    }

    public BrowsePanel(@Nullable Context context, boolean showDesignButton) {
        this.myContext = context;
        this.myBrowseButton = BrowsePanel.createActionButton(new BrowseAction(context));
        this.myDesignButton = showDesignButton ? BrowsePanel.createActionButton(this.createDesignAction()) : null;
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.add((Component)this.myBrowseButton);
        this.myBrowseButton.setFocusable(true);
        if (this.myDesignButton != null) {
            this.add((Component)this.myDesignButton);
            this.myDesignButton.setFocusable(true);
        }
    }

    public void setDesignState(@NotNull PropertyDesignState designState) {
        this.myDesignState = designState;
    }

    public void setProperty(@NotNull NlProperty property2) {
        this.myBrowseButton.setVisible(BrowsePanel.hasBrowseDialog(property2));
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth()) {
            this.myDesignButton.click();
        } else if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth() - (double)this.getBrowseButtonWidth()) {
            this.myBrowseButton.click();
        }
    }

    public void mouseMoved(@NotNull PTable table2, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        table2.setExpandableItemsEnabled((double)event.getX() < rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth() - (double)this.getBrowseButtonWidth());
    }

    private int getDesignButtonWidth() {
        return this.myDesignButton != null ? this.myDesignButton.getWidth() : 0;
    }

    private int getBrowseButtonWidth() {
        return this.myBrowseButton.isVisible() ? this.myBrowseButton.getWidth() : 0;
    }

    @NotNull
    private static ActionButton createActionButton(@NotNull AnAction action2) {
        return new ActionButton(action2, action2.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
    }

    private static ChooseResourceDialog showResourceChooser(@NotNull NlProperty property2, @NotNull XmlTag tag) {
        Module module = property2.getModel().getModule();
        Set<ResourceType> types = BrowsePanel.getResourceTypes(property2);
        boolean onlyLayoutType = types.size() == 1 && types.contains(ResourceType.LAYOUT);
        String propertyName = property2.getName();
        ResourceType defaultResourceType = BrowsePanel.getDefaultResourceType(propertyName);
        boolean isImageViewDrawable = "ImageView".equals(property2.getTagName()) && ("srcCompat".equals(propertyName) || "src".equals(propertyName));
        return ChooseResourceDialog.builder().setModule(module).setTypes(types).setCurrentValue(property2.getValue()).setTag(tag).setDefaultType(defaultResourceType).setFilterColorStateLists(isImageViewDrawable).setShowSampleDataPicker(!onlyLayoutType && "http://schemas.android.com/tools".equals(property2.getNamespace())).build();
    }

    public static boolean hasBrowseDialog(@NotNull NlProperty property2) {
        return property2 != EmptyProperty.INSTANCE && (BrowsePanel.getBrowser(property2) != null || !BrowsePanel.getResourceTypes(property2).isEmpty());
    }

    @Nullable
    public static String showBrowseDialog(@NotNull NlProperty property2) {
        ChooseResourceDialog dialog2;
        AttributeBrowser browser = BrowsePanel.getBrowser(property2);
        XmlTag tag = property2.getTag();
        if (browser != null) {
            ViewEditorImpl editor2 = new ViewEditorImpl(property2.getModel());
            return browser.browse(editor2, property2.getValue());
        }
        if (!BrowsePanel.getResourceTypes(property2).isEmpty() && tag != null && (dialog2 = BrowsePanel.showResourceChooser(property2, tag)).showAndGet()) {
            return dialog2.getResourceName();
        }
        return null;
    }

    @Nullable
    private static AttributeBrowser getBrowser(@NotNull NlProperty property2) {
        Project project = property2.getModel().getProject();
        if (project.isDisposed()) {
            return null;
        }
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
        for (NlComponent component : property2.getComponents()) {
            AttributeBrowser browser;
            ViewHandler handler = viewHandlerManager.getHandler(component);
            if (handler == null || (browser = handler.getBrowser(property2.getName())) == null) continue;
            return browser;
        }
        return null;
    }

    @NotNull
    public static Set<ResourceType> getResourceTypes(@NotNull NlProperty property2) {
        String propertyName = property2.getName();
        if (propertyName.equals("id")) {
            return EnumSet.noneOf(ResourceType.class);
        }
        AttributeDefinition definition = property2.getDefinition();
        Set<AttributeFormat> formats = definition != null ? definition.getFormats() : EnumSet.allOf(AttributeFormat.class);
        Collection<ResourceType> types = AndroidDomUtil.getSpecialResourceTypes(propertyName);
        return types.isEmpty() ? BrowsePanel.matchingTypes(formats) : EnumSet.copyOf(types);
    }

    private static Set<ResourceType> matchingTypes(Set<AttributeFormat> formats) {
        EnumSet<ResourceType> types = EnumSet.noneOf(ResourceType.class);
        for (AttributeFormat format : formats) {
            if (format == AttributeFormat.REFERENCE) {
                types.add(ResourceType.COLOR);
                types.add(ResourceType.DRAWABLE);
                types.add(ResourceType.MIPMAP);
                types.add(ResourceType.STRING);
                types.add(ResourceType.ID);
                types.add(ResourceType.STYLE);
                types.add(ResourceType.ARRAY);
                continue;
            }
            types.addAll(format.getMatchingTypes());
        }
        return types;
    }

    @Nullable
    private static ResourceType getDefaultResourceType(@NotNull String propertyName) {
        String lowerCaseProperty = propertyName.toLowerCase(Locale.ENGLISH);
        if (lowerCaseProperty.contains("color") || lowerCaseProperty.contains("tint")) {
            return ResourceType.COLOR;
        }
        if (lowerCaseProperty.contains("drawable") || propertyName.equals("src") || propertyName.equals("srcCompat")) {
            return ResourceType.DRAWABLE;
        }
        return null;
    }

    private AnAction createDesignAction() {
        return new AnAction(){

            public void update(@NotNull AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                switch (BrowsePanel.this.myDesignState) {
                    case MISSING_DESIGN_PROPERTY: {
                        presentation.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
                        presentation.setText("Specify Design Property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        presentation.setIcon(AllIcons.Actions.Delete);
                        presentation.setText("Remove this Design Property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    default: {
                        presentation.setIcon(null);
                        presentation.setText(null);
                        presentation.setVisible(false);
                        presentation.setEnabled(false);
                    }
                }
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (BrowsePanel.this.myContext == null) {
                    return;
                }
                switch (BrowsePanel.this.myDesignState) {
                    case MISSING_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.addDesignProperty();
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.removeDesignProperty();
                        break;
                    }
                }
            }
        };
    }

    private static class BrowseAction
    extends AnAction {
        private final Context myContext;

        private BrowseAction(@Nullable Context context) {
            this.myContext = context;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.Ellipsis);
            presentation.setText("Pick a Resource");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (this.myContext == null) {
                return;
            }
            NlProperty property2 = this.myContext.getProperty();
            if (property2 == null) {
                return;
            }
            String newValue = BrowsePanel.showBrowseDialog(property2);
            this.myContext.cancelEditing();
            if (newValue != null) {
                this.myContext.stopEditing(newValue);
            }
        }
    }

    public static class ContextDelegate
    implements Context {
        private NlComponentEditor myEditor;

        @Override
        @Nullable
        public NlProperty getProperty() {
            return this.myEditor != null ? this.myEditor.getProperty() : null;
        }

        public void setEditor(@NotNull NlComponentEditor editor2) {
            this.myEditor = editor2;
        }
    }

    public static interface Context {
        @Nullable
        public NlProperty getProperty();

        default public void cancelEditing() {
        }

        default public void stopEditing(@Nullable Object newValue) {
            NlProperty property2 = this.getProperty();
            if (property2 != null) {
                property2.setValue(newValue);
            }
        }

        default public void addDesignProperty() {
            throw new UnsupportedOperationException();
        }

        default public void removeDesignProperty() {
            throw new UnsupportedOperationException();
        }
    }
}

