/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanEditor
extends BaseComponentEditor
implements NlComponentEditor {
    static final String TIP_TEXT_DONT_CARE = "(No value)";
    static final String TIP_TEXT_NOT_SELECTED = "false";
    static final String TIP_TEXT_SELECTED = "true";
    private static final int VERTICAL_SPACING_IN_TABLE_CELL = 1;
    private final JPanel myPanel;
    private final ThreeStateCheckBox myCheckbox = new ThreeStateCheckBox();
    private final BrowsePanel myBrowsePanel;
    private NlProperty myProperty;
    private Object myValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlBooleanEditor(cellEditor, browsePanel, 1), browsePanel);
        return cellEditor;
    }

    public static NlBooleanEditor createForInspector(@NotNull NlEditingListener listener2) {
        return new NlBooleanEditor(listener2, null, 2);
    }

    private NlBooleanEditor(@NotNull NlEditingListener listener2, @Nullable BrowsePanel browsePanel, int verticalSpacing) {
        super(listener2);
        this.myCheckbox.addActionListener(this::checkboxChanged);
        this.myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
        this.myPanel.add((Component)this.myCheckbox, "Before");
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)verticalSpacing, (int)6, (int)verticalSpacing, (int)0));
        this.myBrowsePanel = browsePanel;
        if (browsePanel != null) {
            this.myPanel.add((Component)((Object)browsePanel), "After");
        }
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        this.myProperty = property2;
        String propValue = this.myProperty.getValue();
        this.myValue = propValue;
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        this.myCheckbox.setState(state == null ? ThreeStateCheckBox.State.NOT_SELECTED : state);
        this.updateTipText();
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property2);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    private void checkboxChanged(ActionEvent event) {
        this.myValue = NlBooleanRenderer.getBoolean(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
        this.updateTipText();
    }

    private void updateTipText() {
        switch (this.myCheckbox.getState()) {
            case DONT_CARE: {
                this.myCheckbox.setToolTipText(TIP_TEXT_DONT_CARE);
                break;
            }
            case NOT_SELECTED: {
                this.myCheckbox.setToolTipText(TIP_TEXT_NOT_SELECTED);
                break;
            }
            case SELECTED: {
                this.myCheckbox.setToolTipText(TIP_TEXT_SELECTED);
            }
        }
    }
}

