/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.EnumEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupportFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEnumEditor
extends EnumEditor {
    private String myApiVersion;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlEnumEditor(cellEditor, new EnumEditor.CustomComboBox(), browsePanel, false), browsePanel);
        return cellEditor;
    }

    public static NlEnumEditor createForInspector(@NotNull NlEditingListener listener2) {
        return new NlEnumEditor(listener2, new EnumEditor.CustomComboBox(), null, true);
    }

    public static NlEnumEditor createForInspectorWithBrowseButton(@NotNull NlEditingListener listener2) {
        BrowsePanel.ContextDelegate delegate = new BrowsePanel.ContextDelegate();
        NlEnumEditor editor2 = new NlEnumEditor(listener2, new EnumEditor.CustomComboBox(), new BrowsePanel(delegate, false), true);
        delegate.setEditor(editor2);
        return editor2;
    }

    public static NlEnumEditor createForTest(@NotNull NlEditingListener listener2, EnumEditor.CustomComboBox comboBox) {
        return new NlEnumEditor(listener2, comboBox, null, false);
    }

    private NlEnumEditor(@NotNull NlEditingListener listener2, @NotNull EnumEditor.CustomComboBox comboBox, @Nullable BrowsePanel browsePanel, boolean includeBorder) {
        super(listener2, comboBox, browsePanel, includeBorder, true);
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        super.setProperty(property2, !NlEnumEditor.getApiVersion(property2).equals(this.myApiVersion));
    }

    @Override
    protected void setModel(@NotNull NlProperty property2) {
        this.myApiVersion = NlEnumEditor.getApiVersion(property2);
        super.setModel(property2);
    }

    @Override
    protected EnumSupport getEnumSupport(@NotNull NlProperty property2) {
        assert (EnumSupportFactory.supportsProperty(property2)) : this.getClass().getName() + property2;
        return EnumSupportFactory.create(property2);
    }

    @NotNull
    private static String getApiVersion(@NotNull NlProperty property2) {
        IAndroidTarget target = property2 != EmptyProperty.INSTANCE ? property2.getModel().getConfiguration().getTarget() : null;
        return target == null ? "28U" : target.getVersion().getApiString();
    }
}

