/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagsEditor
extends BaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final JTextField myValue;
    private NlFlagPropertyItem myProperty;

    public static NlFlagsEditor create() {
        return new NlFlagsEditor();
    }

    private NlFlagsEditor() {
        super(NlEditingListener.DEFAULT_LISTENER);
        AnAction action2 = this.createDisplayFlagEditorAction();
        ActionButton button2 = new ActionButton(action2, action2.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        this.myValue = new CustomTextField();
        this.myValue.setEditable(false);
        this.myValue.setFocusable(true);
        this.myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)4, (int)2, (int)0));
        this.myPanel.add((Component)this.myValue, "Center");
        this.myPanel.add((Component)button2, "After");
        this.myValue.addActionListener(event -> this.displayFlagEditor());
        this.myValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        });
        this.myValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty != null ? this.myProperty : EmptyProperty.INSTANCE;
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        assert (property2 instanceof NlFlagPropertyItem);
        this.myProperty = (NlFlagPropertyItem)property2;
        this.myValue.setText(property2.getValue());
    }

    private AnAction createDisplayFlagEditorAction() {
        return new AnAction(){

            public void update(@NotNull AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                if (NlFlagsEditor.this.myProperty != null) {
                    presentation.setIcon(AllIcons.General.Ellipsis);
                    presentation.setText("Click to edit");
                    presentation.setVisible(true);
                    presentation.setEnabled(true);
                } else {
                    presentation.setIcon(null);
                    presentation.setText(null);
                    presentation.setVisible(false);
                    presentation.setEnabled(false);
                }
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        };
    }

    private void displayFlagEditor() {
        FlagsDialog dialog2 = new FlagsDialog(this.myProperty);
        dialog2.setResizable(false);
        dialog2.setInitialLocationCallback(() -> {
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this.myPanel);
            return location;
        });
        dialog2.show();
    }

    private static class CustomTextFieldUI
    extends DarculaTextFieldUI {
        private CustomTextFieldUI() {
        }

        protected void paintDarculaBackground(Graphics graphics2D, JTextComponent component) {
            graphics2D.setColor(component.getBackground());
            super.paintDarculaBackground(graphics2D, component);
        }
    }

    private static class CustomTextField
    extends JTextField {
        public CustomTextField() {
            this.setBorder((Border)new DarculaTextBorder());
        }

        @Override
        public void setUI(TextUI ui) {
            super.setUI((TextUI)((Object)new CustomTextFieldUI()));
        }
    }

    private static class FlagsDialog
    extends DialogWrapper {
        private final NlFlagPropertyItem myProperty;

        protected FlagsDialog(@NotNull NlFlagPropertyItem property2) {
            super(property2.getModel().getProject(), false, DialogWrapper.IdeModalityType.MODELESS);
            this.myProperty = property2;
            this.setTitle(property2.getName());
            this.init();
            this.getWindow().addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.close(0);
                }
            });
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction()};
        }

        @Nullable
        protected JComponent createCenterPanel() {
            AdtSecondaryPanel panel2 = new AdtSecondaryPanel();
            panel2.setLayout(new BoxLayout((Container)panel2, 3));
            AttributeDefinition definition = this.myProperty.getDefinition();
            assert (definition != null);
            for (String item : definition.getValues()) {
                NlFlagEditor editor2 = NlFlagEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
                editor2.setProperty(this.myProperty.getChildProperty(item));
                panel2.add(editor2.getComponent());
            }
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel2, (int)20, (int)31);
            scrollPane.setBorder(null);
            scrollPane.getVerticalScrollBar().setUnitIncrement(25);
            scrollPane.getVerticalScrollBar().setBlockIncrement(25);
            return scrollPane;
        }
    }
}

