/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.editors.PropertyEditors;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagsEditor;
import com.android.tools.idea.uibuilder.property.editors.NlNoEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupportFactory;
import com.android.tools.property.ptable.PTableCellEditor;
import com.android.tools.property.ptable.PTableCellEditorProvider;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;

public class NlPropertyEditors
extends PropertyEditors
implements PTableCellEditorProvider {
    private Project myProject;
    private NlTableCellEditor myBooleanEditor;
    private NlTableCellEditor myFlagEditor;
    private NlTableCellEditor myComboEditor;
    private NlTableCellEditor myDefaultEditor;

    @NotNull
    public static NlPropertyEditors getInstance(@NotNull Project project) {
        return (NlPropertyEditors)project.getComponent(NlPropertyEditors.class);
    }

    private NlPropertyEditors(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public PTableCellEditor getCellEditor(@NotNull PTableItem item, int column) {
        if (!(item instanceof NlProperty)) {
            return NlNoEditor.getInstance();
        }
        switch (NlPropertyEditors.getEditorType((NlProperty)((Object)item))) {
            case BOOLEAN: {
                return this.getBooleanEditor();
            }
            case FLAG: {
                return this.getMyFlagEditor();
            }
            case COMBO: 
            case COMBO_WITH_BROWSE: {
                return this.getMyComboEditor();
            }
        }
        return this.getDefaultEditor();
    }

    @Override
    @NotNull
    public NlComponentEditor create(@NotNull NlProperty property2) {
        switch (NlPropertyEditors.getEditorType(property2)) {
            case BOOLEAN: {
                return NlBooleanEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            }
            case FLAG: {
                return NlFlagsEditor.create();
            }
            case COMBO: {
                return NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            }
            case COMBO_WITH_BROWSE: {
                return NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            }
        }
        return NlReferenceEditor.createForInspectorWithBrowseButton(property2.getModel().getProject(), NlEditingListener.DEFAULT_LISTENER);
    }

    @Override
    protected void resetCachedEditors() {
        this.myBooleanEditor = null;
        this.myFlagEditor = null;
        this.myComboEditor = null;
        this.myDefaultEditor = null;
    }

    @NotNull
    private static EditorType getEditorType(@NotNull NlProperty property2) {
        AttributeDefinition definition = property2.getDefinition();
        Set<Object> formats = definition != null ? definition.getFormats() : Collections.emptySet();
        Boolean isBoolean = null;
        for (AttributeFormat attributeFormat : formats) {
            switch (attributeFormat) {
                case BOOLEAN: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.TRUE;
                    break;
                }
                case STRING: 
                case COLOR: 
                case DIMENSION: 
                case INTEGER: 
                case FLOAT: 
                case FRACTION: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.FALSE;
                    break;
                }
                case ENUM: {
                    return EditorType.COMBO;
                }
                case FLAGS: {
                    return EditorType.FLAG;
                }
            }
        }
        if (isBoolean == Boolean.TRUE) {
            return EditorType.BOOLEAN;
        }
        if (EnumSupportFactory.supportsProperty(property2)) {
            if (property2.getName().equals("style")) {
                return EditorType.COMBO_WITH_BROWSE;
            }
            return EditorType.COMBO;
        }
        return EditorType.DEFAULT;
    }

    private PTableCellEditor getBooleanEditor() {
        if (this.myBooleanEditor == null) {
            this.myBooleanEditor = NlBooleanEditor.createForTable();
        }
        return this.myBooleanEditor;
    }

    private PTableCellEditor getMyFlagEditor() {
        if (this.myFlagEditor == null) {
            this.myFlagEditor = NlFlagEditor.createForTable();
        }
        return this.myFlagEditor;
    }

    private PTableCellEditor getMyComboEditor() {
        if (this.myComboEditor == null) {
            this.myComboEditor = NlEnumEditor.createForTable();
        }
        return this.myComboEditor;
    }

    private PTableCellEditor getDefaultEditor() {
        if (this.myDefaultEditor == null) {
            this.myDefaultEditor = NlReferenceEditor.createForTable(this.myProject);
        }
        return this.myDefaultEditor;
    }

    private static enum EditorType {
        DEFAULT,
        BOOLEAN,
        FLAG,
        COMBO,
        COMBO_WITH_BROWSE;

    }
}

