/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.TextEditorWithAutoCompletion;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Clock;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlReferenceEditor
extends BaseComponentEditor {
    private static final int MIN_TEXT_WIDTH = 50;
    private static final int ICON_SIZE = 16;
    private static final int HORIZONTAL_SPACE_AFTER_LABEL = 4;
    private final JPanel myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout());
    private final JLabel myIconLabel = new JBLabel();
    private final JSlider mySlider;
    private final Project myProject;
    private final TextEditorWithAutoCompletion myTextEditorWithAutoCompletion;
    private final BrowsePanel myBrowsePanel;
    private final boolean myHasSliderSupport;
    private final boolean myIsInspector;
    private NlProperty myProperty;
    private boolean myPropertyHasSlider;
    private String myLastReadValue;
    private Object myLastWriteValue;
    private boolean myUpdatingProperty;
    private boolean myCompletionsUpdated;

    public static NlTableCellEditor createForTable(@NotNull Project project) {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlReferenceEditor(project, cellEditor, browsePanel, false, true, false, 0), browsePanel);
        return cellEditor;
    }

    public static NlReferenceEditor createForInspector(@NotNull Project project, @NotNull NlEditingListener listener2) {
        return new NlReferenceEditor(project, listener2, null, true, true, true, 2);
    }

    public static NlReferenceEditor createForTableTesting(@NotNull Project project, @NotNull NlEditingListener listener2, @NotNull BrowsePanel browsePanel) {
        return new NlReferenceEditor(project, listener2, browsePanel, false, true, false, 2);
    }

    public static NlReferenceEditor createForInspectorWithBrowseButton(@NotNull Project project, @NotNull NlEditingListener listener2) {
        BrowsePanel.ContextDelegate delegate = new BrowsePanel.ContextDelegate();
        BrowsePanel browsePanel = new BrowsePanel(delegate, false);
        NlReferenceEditor editor2 = new NlReferenceEditor(project, listener2, browsePanel, true, true, true, 2);
        delegate.setEditor(editor2);
        return editor2;
    }

    protected NlReferenceEditor(@NotNull Project project, @NotNull NlEditingListener listener2, @Nullable BrowsePanel browsePanel, boolean includeBorder, boolean includeSliderSupport, boolean isInspector, int verticalSpacing) {
        super(listener2);
        this.myPanel.add((Component)this.myIconLabel, "Before");
        this.myPanel.setFocusable(false);
        this.myIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NlReferenceEditor.this.showBrowseDialog();
            }
        });
        this.myIconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        Font font = UIUtil.getLabelFont();
        FontMetrics metrics = this.myPanel.getFontMetrics(font);
        int sliderHeight = metrics.getHeight() + 2 * verticalSpacing;
        this.mySlider = new SliderWithTimeDelay();
        this.myPanel.add((Component)this.mySlider, "Before");
        this.mySlider.addChangeListener(event -> this.sliderChange());
        Dimension size = this.mySlider.getMinimumSize();
        size.setSize(size.width * 2, sliderHeight);
        this.mySlider.setMinimumSize(size);
        this.mySlider.setPreferredSize(size);
        this.mySlider.setVisible(includeSliderSupport);
        this.myProject = project;
        this.myTextEditorWithAutoCompletion = TextEditorWithAutoCompletion.create(project, (Insets)JBUI.insets((int)verticalSpacing, (int)3, (int)verticalSpacing, (int)3));
        if (includeBorder) {
            this.myTextEditorWithAutoCompletion.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        }
        this.myTextEditorWithAutoCompletion.addLookupListener(new LookupListener(){

            public void itemSelected(@NotNull LookupEvent event) {
                NlReferenceEditor.this.stopEditing(NlReferenceEditor.this.getText());
            }
        });
        this.myBrowsePanel = browsePanel;
        this.myPanel.add((Component)((Object)this.myTextEditorWithAutoCompletion), "Center");
        if (browsePanel != null) {
            if (includeBorder) {
                this.myBrowsePanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)1));
            }
            this.myPanel.add((Component)((Object)this.myBrowsePanel), "After");
        }
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                NlReferenceEditor.this.updateSliderAndIconVisibility();
            }
        });
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.stopEditing(this.getText()), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextEditorWithAutoCompletion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                NlReferenceEditor.this.editorFocusGain(event);
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                NlReferenceEditor.this.editorFocusLost(event);
            }
        });
        this.myProperty = EmptyProperty.INSTANCE;
        this.myHasSliderSupport = includeSliderSupport;
        this.myIsInspector = isInspector;
    }

    protected TextEditorWithAutoCompletion getTextEditor() {
        return this.myTextEditorWithAutoCompletion;
    }

    protected void editorFocusGain(@NotNull FocusEvent event) {
        if (event.getOppositeComponent() != this.mySlider && !this.myCompletionsUpdated && this.myProperty != EmptyProperty.INSTANCE) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                NlProperty property2 = this.myProperty;
                AndroidFacet facet = this.myProperty.getModel().getFacet();
                List<String> completions = TextEditorWithAutoCompletion.loadCompletions(facet, NlReferenceEditor.getResourceTypes(this.myProperty), this.myProperty);
                if (property2 == this.myProperty) {
                    this.myTextEditorWithAutoCompletion.updateCompletions(completions);
                    this.myCompletionsUpdated = true;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        Project project;
                        if (!this.getText().equals(StringUtil.notNullize((String)property2.getValue())) && !(project = property2.getModel().getProject()).isDisposed() && this.myTextEditorWithAutoCompletion.editorHasFocus()) {
                            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(this.myTextEditorWithAutoCompletion.getEditor());
                        }
                    });
                }
            });
        }
        this.myTextEditorWithAutoCompletion.selectAll();
    }

    protected void editorFocusLost(@NotNull FocusEvent event) {
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        if (event.getOppositeComponent() != this.mySlider && !undoManager.isUndoInProgress() && !undoManager.isRedoInProgress()) {
            this.stopEditing(this.getText());
            this.myTextEditorWithAutoCompletion.removeSelection();
        }
    }

    private static Set<ResourceType> getResourceTypes(@NotNull NlProperty property2) {
        AttributeDefinition definition = property2.getDefinition();
        if (definition == null || "id".equals(property2.getName())) {
            return EnumSet.noneOf(ResourceType.class);
        }
        Set<ResourceType> resourceTypes = BrowsePanel.getResourceTypes(property2);
        if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
            resourceTypes.add(ResourceType.SAMPLE_DATA);
        }
        return resourceTypes;
    }

    @NotNull
    private String getText() {
        String text = this.myTextEditorWithAutoCompletion.getDocument().getText();
        return Quantity.addUnit(this.myProperty, text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myTextEditorWithAutoCompletion.setEnabled(enabled);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setVisible(enabled);
        }
        if (!enabled) {
            this.myLastReadValue = "";
            this.myLastWriteValue = "";
            this.myTextEditorWithAutoCompletion.setText("");
        }
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(@NotNull NlProperty property2) {
        if (this.myProperty != property2) {
            this.myProperty = property2;
            this.myLastReadValue = null;
            if (this.myBrowsePanel != null) {
                this.myBrowsePanel.setProperty(property2);
            }
            this.myCompletionsUpdated = false;
        }
        this.myUpdatingProperty = true;
        try {
            this.myPropertyHasSlider = this.configureSlider();
            if (this.myPropertyHasSlider) {
                this.myPanel.remove(this.myIconLabel);
                this.myPanel.add((Component)this.mySlider, "Before");
            } else {
                this.myPanel.remove(this.mySlider);
                this.myPanel.add((Component)this.myIconLabel, "Before");
            }
            String propValue = StringUtil.notNullize((String)this.myProperty.getValue());
            if (!propValue.equals(this.myLastReadValue)) {
                this.myLastReadValue = propValue;
                this.myLastWriteValue = propValue;
                this.myTextEditorWithAutoCompletion.setText(propValue);
            }
            JBColor color = this.myProperty.isDefaultValue(this.myLastReadValue) ? DEFAULT_VALUE_TEXT_COLOR : CHANGED_VALUE_TEXT_COLOR;
            this.myTextEditorWithAutoCompletion.setTextColor((Color)color);
            this.updateSliderAndIconVisibility();
        }
        finally {
            this.myUpdatingProperty = false;
        }
    }

    private void updateSliderAndIconVisibility() {
        if (this.myPropertyHasSlider) {
            int widthBrowsePanel = this.myBrowsePanel != null ? this.myBrowsePanel.getPreferredSize().width : 0;
            int widthForEditor = this.myPanel.getWidth() - this.mySlider.getPreferredSize().width - widthBrowsePanel;
            this.mySlider.setVisible(widthForEditor >= JBUI.scale((int)50));
        } else {
            int iconSize = JBUI.scale((int)16);
            Icon icon2 = NlDefaultRenderer.getIcon(this.myProperty, iconSize);
            this.myIconLabel.setIcon(icon2);
            this.myIconLabel.setVisible(icon2 != null);
            this.myIconLabel.setToolTipText("Pick a Resource");
        }
    }

    private boolean configureSlider() {
        int value2;
        int maximum;
        if (this.myProperty == null || !this.myHasSliderSupport) {
            return false;
        }
        AttributeDefinition definition = this.myProperty.getDefinition();
        if (definition == null || Collections.disjoint(definition.getFormats(), ImmutableList.of((Object)AttributeFormat.DIMENSION, (Object)AttributeFormat.FLOAT))) {
            return false;
        }
        switch (this.myProperty.getName()) {
            case "elevation": 
            case "cardElevation": {
                maximum = 24;
                value2 = this.getValueInDp(0);
                break;
            }
            case "minHeight": {
                maximum = 250;
                value2 = this.getValueInDp(180);
                break;
            }
            case "mockup_opacity": 
            case "layout_collapseParallaxMultiplier": {
                maximum = 10;
                value2 = (int)(this.getValueAsFloat(1.0) * 10.0 + 0.5);
                break;
            }
            default: {
                return false;
            }
        }
        this.mySlider.setMinimum(0);
        this.mySlider.setMaximum(maximum);
        this.mySlider.setValue(value2);
        return true;
    }

    private int getValueInDp(int defaultValue) {
        String valueAsString = this.myProperty.getValue();
        if (valueAsString == null) {
            return defaultValue;
        }
        ResourceResolver resolver = this.myProperty.getResolver();
        if (resolver == null) {
            return defaultValue;
        }
        Configuration configuration = this.myProperty.getModel().getConfiguration();
        Integer value2 = ViewEditor.resolveDimensionPixelSize((RenderResources)resolver, valueAsString, configuration);
        if (value2 == null) {
            return defaultValue;
        }
        return Coordinates.pxToDp(this.myProperty.getModel(), (int)value2);
    }

    private double getValueAsFloat(double defaultValue) {
        String valueAsString = this.myProperty.getValue();
        if (valueAsString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueAsString);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    private String getSliderValue() {
        int value2 = this.mySlider.getValue();
        switch (this.myProperty.getName()) {
            case "layout_collapseParallaxMultiplier": 
            case "mockup_opacity": {
                if (value2 == 10) {
                    return "1.0";
                }
                return "0." + value2;
            }
        }
        return Quantity.addUnit(this.myProperty, String.valueOf(value2));
    }

    private void sliderChange() {
        if (this.myUpdatingProperty) {
            return;
        }
        this.myTextEditorWithAutoCompletion.setText(this.getSliderValue());
        if (this.myIsInspector && !this.mySlider.getValueIsAdjusting()) {
            this.stopEditing(this.getText());
        }
    }

    @Override
    public void requestFocus() {
        if (this.myTextEditorWithAutoCompletion.getEditor() != null) {
            this.myTextEditorWithAutoCompletion.requestFocus();
        }
        this.myTextEditorWithAutoCompletion.selectAll();
        this.myTextEditorWithAutoCompletion.scrollRectToVisible(this.myTextEditorWithAutoCompletion.getBounds());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.getText();
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myTextEditorWithAutoCompletion.setText((String)newValue);
        if (this.myTextEditorWithAutoCompletion.editorHasFocus()) {
            this.myTextEditorWithAutoCompletion.selectAll();
        }
        if (!Objects.equals(newValue, this.myLastWriteValue)) {
            this.myLastWriteValue = newValue;
            this.myLastReadValue = null;
            super.stopEditing(newValue);
        }
    }

    protected void cancel() {
        this.myTextEditorWithAutoCompletion.setText(this.myProperty.getValue());
        this.myTextEditorWithAutoCompletion.selectAll();
        this.cancelEditing();
    }

    public static class SliderWithTimeDelay
    extends JSlider {
        private static final long SHORT_WAIT_MILLIS = 300L;
        private Clock myClock = Clock.systemUTC();
        private long myLastAddNotifyMillis;

        private SliderWithTimeDelay() {
        }

        public void setClock(@NotNull Clock clock) {
            this.myClock = clock;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.myLastAddNotifyMillis = this.myClock.millis();
        }

        @Override
        protected void processMouseEvent(@NotNull MouseEvent event) {
            if (this.myClock.millis() - this.myLastAddNotifyMillis > 300L) {
                super.processMouseEvent(event);
            }
        }
    }
}

