/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.PropertyDesignState;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellEditor;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableCellEditor
extends PTableCellEditor
implements NlEditingListener,
BrowsePanel.Context {
    protected NlComponentEditor myEditor;
    protected BrowsePanel myBrowsePanel;
    protected JTable myTable;
    protected int myRow;

    public void init(@NotNull NlComponentEditor editor2, @Nullable BrowsePanel browsePanel) {
        this.myEditor = editor2;
        this.myBrowsePanel = browsePanel;
    }

    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, int row, int column) {
        assert (value2 instanceof NlProperty);
        this.myEditor.setProperty((NlProperty)value2);
        this.startCellEditing(table2, row);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setDesignState(NlTableCellEditor.getDesignState(table2, row));
        }
        return this.myEditor.getComponent();
    }

    protected void startCellEditing(@NotNull JTable table2, int row) {
        this.myTable = table2;
        this.myRow = row;
    }

    @Nullable
    JTable getTable() {
        return this.myTable;
    }

    int getRow() {
        return this.myRow;
    }

    public final NlComponentEditor getEditor() {
        return this.myEditor;
    }

    public boolean stopCellEditing() {
        if (this.myTable != null) {
            this.myTable.requestFocus();
            if (!super.stopCellEditing()) {
                return false;
            }
            this.myTable = null;
            this.myRow = -1;
            this.myEditor.setProperty(EmptyProperty.INSTANCE);
        }
        return true;
    }

    @Override
    public boolean isBooleanEditor() {
        return this.myEditor instanceof NlBooleanEditor;
    }

    @Override
    public void activate() {
        this.myEditor.activate();
    }

    public Object getCellEditorValue() {
        return this.myEditor.getValue();
    }

    @Override
    public void stopEditing(@NotNull NlComponentEditor editor2, @Nullable Object value2) {
        this.stopCellEditing();
    }

    @Override
    public void cancelEditing(@NotNull NlComponentEditor editor2) {
        this.cancelCellEditing();
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return NlTableCellEditor.getPropertyAt(this.myTable, this.myRow);
    }

    @Override
    public void cancelEditing() {
        this.cancelCellEditing();
    }

    @Override
    public void addDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.addDesignProperty(this.myTable, this.myRow);
    }

    @Override
    public void removeDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.removeDesignProperty(this.myTable, this.myRow);
    }

    public static PropertyDesignState getDesignState(@NotNull JTable table2, int row) {
        NlPropertyItem property2 = NlTableCellEditor.getPropertyAt(table2, row);
        if (property2 == null) {
            return PropertyDesignState.NOT_APPLICABLE;
        }
        if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
            NlProperty runtimeProperty = NlTableCellEditor.getRuntimeProperty(table2, row);
            return runtimeProperty != null ? PropertyDesignState.IS_REMOVABLE_DESIGN_PROPERTY : PropertyDesignState.NOT_APPLICABLE;
        }
        NlProperty designProperty = NlTableCellEditor.getDesignProperty(table2, row);
        return designProperty != null ? PropertyDesignState.HAS_DESIGN_PROPERTY : PropertyDesignState.MISSING_DESIGN_PROPERTY;
    }

    @Nullable
    public static NlPropertyItem getPropertyAt(@NotNull JTable table2, int row) {
        if (!(table2 instanceof PTable) || row < 0 || row >= table2.getRowCount()) {
            return null;
        }
        Object value2 = table2.getValueAt(row, 1);
        if (value2 instanceof NlPropertyItem) {
            return (NlPropertyItem)value2;
        }
        return null;
    }

    @Nullable
    public static NlProperty getRuntimeProperty(@NotNull JTable table2, int row) {
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table2, row);
        NlPropertyItem previousProperty = NlTableCellEditor.getPropertyAt(table2, NlTableCellEditor.getPreviousPropertyRow(currentProperty, table2, row));
        if (currentProperty != null && previousProperty != null && previousProperty.getName().equals(currentProperty.getName()) && "http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && !"http://schemas.android.com/tools".equals(previousProperty.getNamespace())) {
            return previousProperty;
        }
        return null;
    }

    @Nullable
    public static NlProperty getDesignProperty(@NotNull JTable table2, int row) {
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table2, row);
        NlPropertyItem nextProperty = NlTableCellEditor.getPropertyAt(table2, NlTableCellEditor.getNextPropertyRow(currentProperty, row));
        if (currentProperty != null && nextProperty != null && nextProperty.getName().equals(currentProperty.getName()) && !"http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && "http://schemas.android.com/tools".equals(nextProperty.getNamespace())) {
            return nextProperty;
        }
        return null;
    }

    public static void addDesignProperty(@NotNull JTable table2, int row) {
        NlPropertyItem property2 = NlTableCellEditor.getPropertyAt(table2, row);
        assert (property2 != null && !"http://schemas.android.com/tools".equals(property2.getNamespace()));
        assert (NlTableCellEditor.getDesignProperty(table2, row) == null);
        PTableModel model2 = (PTableModel)table2.getModel();
        int nextRow = NlTableCellEditor.getNextPropertyRow(property2, row);
        model2.insertRow(nextRow, property2.getDesignTimeProperty());
        if (property2.isExpanded()) {
            model2.expand(nextRow);
        }
        SwingUtilities.invokeLater(() -> table2.editCellAt(row + 1, 1));
    }

    public static void removeDesignProperty(@NotNull JTable table2, int row) {
        NlPropertyItem designProperty = NlTableCellEditor.getPropertyAt(table2, row);
        assert (designProperty != null && "http://schemas.android.com/tools".equals(designProperty.getNamespace()));
        int previousRow = NlTableCellEditor.getPreviousPropertyRow(designProperty, table2, row);
        PTableModel model2 = (PTableModel)table2.getModel();
        designProperty.setValue(null);
        designProperty.delete();
        model2.collapse(row);
        model2.deleteRow(row);
        SwingUtilities.invokeLater(() -> table2.editCellAt(previousRow, 1));
    }

    private static int getNextPropertyRow(@Nullable NlPropertyItem currentProperty, int row) {
        if (currentProperty == null) {
            return -1;
        }
        return row + 1 + (currentProperty.isExpanded() ? currentProperty.getChildren().size() : 0);
    }

    private static int getPreviousPropertyRow(@Nullable NlPropertyItem currentProperty, @NotNull JTable table2, int row) {
        if (currentProperty == null || row == 0) {
            return -1;
        }
        PTableItem previous = (PTableItem)table2.getValueAt(row - 1, 1);
        if (previous.getParent() != null && currentProperty.getParent() == null) {
            return row - previous.getParent().getChildren().size() - 1;
        }
        return row - 1;
    }
}

