/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.AddPropertyItem;
import com.android.tools.idea.uibuilder.property.NlResourceItem;
import com.android.tools.idea.uibuilder.property.editors.AddPropertyEditor;
import com.android.tools.idea.uibuilder.property.editors.NlResourceValueEditor;
import com.android.tools.idea.uibuilder.property.editors.NlSlicePropertyEditor;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.property.ptable.PTableCellEditor;
import com.android.tools.property.ptable.PTableCellEditorProvider;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class NlXmlEditors
implements PTableCellEditorProvider,
ProjectComponent,
LafManagerListener {
    private final Project myProject;
    private NlTableCellEditor myPropertyEditor;
    private NlTableCellEditor myAddPropertyEditor;
    private NlResourceValueEditor myResourceValueEditor;

    @NotNull
    public static NlXmlEditors getInstance(@NotNull Project project) {
        return (NlXmlEditors)project.getComponent(NlXmlEditors.class);
    }

    private NlXmlEditors(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public PTableCellEditor getCellEditor(@NotNull PTableItem item, int column) {
        if (item instanceof NlProperty) {
            return this.getPropertyEditor();
        }
        if (item instanceof NlResourceItem) {
            return this.getResourceValueEditor();
        }
        if (item instanceof AddPropertyItem) {
            return column == 0 ? this.getAddPropertyEditor() : this.getPropertyEditor();
        }
        return null;
    }

    private void resetCachedEditors() {
        this.myPropertyEditor = null;
        this.myAddPropertyEditor = null;
        this.myResourceValueEditor = null;
    }

    private NlTableCellEditor getPropertyEditor() {
        if (this.myPropertyEditor == null) {
            this.myPropertyEditor = NlSlicePropertyEditor.create(this.myProject);
        }
        return this.myPropertyEditor;
    }

    private NlTableCellEditor getAddPropertyEditor() {
        if (this.myAddPropertyEditor == null) {
            this.myAddPropertyEditor = AddPropertyEditor.create(this.myProject);
        }
        return this.myAddPropertyEditor;
    }

    private NlResourceValueEditor getResourceValueEditor() {
        if (this.myResourceValueEditor == null) {
            this.myResourceValueEditor = NlResourceValueEditor.createForSliceTable(this.myProject);
        }
        return this.myResourceValueEditor;
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        this.resetCachedEditors();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    public void disposeComponent() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    @NotNull
    public String getComponentName() {
        return NlXmlEditors.class.getSimpleName();
    }
}

