/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnumSupport {
    protected final NlProperty myProperty;

    public EnumSupport(@NotNull NlProperty property2) {
        this.myProperty = property2;
    }

    @NotNull
    public abstract List<ValueWithDisplayString> getAllValues();

    public boolean customizeCellRenderer(@NotNull ColoredListCellRenderer<ValueWithDisplayString> renderer, @NotNull ValueWithDisplayString value2, boolean selected) {
        return false;
    }

    @NotNull
    public ValueWithDisplayString createValue(@NotNull String editorValue) {
        String resolvedValue;
        if (editorValue.isEmpty()) {
            editorValue = null;
        }
        if (StringUtil.isEmpty((String)(resolvedValue = this.myProperty.resolveValue(editorValue)))) {
            return ValueWithDisplayString.UNSET;
        }
        String hint = StringUtil.isEmpty((String)editorValue) ? "default" : (!editorValue.equals(resolvedValue) ? editorValue : null);
        return this.createFromResolvedValue(resolvedValue, editorValue, hint);
    }

    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        return new ValueWithDisplayString(resolvedValue, value2, hint);
    }
}

