/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.fonts.MoreFontsDialog;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontEnumSupport
extends EnumSupport {
    private ProjectFonts myProjectFonts;

    public FontEnumSupport(@NotNull NlProperty property2) {
        super(property2);
        this.myProjectFonts = new ProjectFonts(this.myProperty.getModel().getFacet());
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        List<FontFamily> fonts = this.myProjectFonts.getFonts();
        for (FontFamily font : fonts) {
            values.add(new ValueWithDisplayString(font.getName(), "@font/" + font.getName()));
        }
        if (!values.isEmpty()) {
            values.add(ValueWithDisplayString.SEPARATOR);
        }
        for (String stringValue : AndroidDomUtil.AVAILABLE_FAMILIES) {
            values.add(new ValueWithDisplayString(stringValue, stringValue));
        }
        AndroidFacet facet = this.myProperty.getModel().getFacet();
        ResourceResolver resolver = this.myProperty.getResolver();
        if (resolver != null) {
            values.add(ValueWithDisplayString.SEPARATOR);
            values.add(new ValueWithDisplayString("More Fonts...", null, null, new MoreFontSelector(facet, resolver)));
        }
        return values;
    }

    @Override
    public boolean customizeCellRenderer(@NotNull ColoredListCellRenderer<ValueWithDisplayString> renderer, @NotNull ValueWithDisplayString value2, boolean selected) {
        String fontValue = value2.getValue();
        if (fontValue == null && value2.getValueSelector() == null) {
            fontValue = this.myProperty.resolveValue(null);
        }
        if (fontValue == null) {
            return false;
        }
        FontFamily fontFamily = this.myProjectFonts.getFont(fontValue);
        switch (fontFamily.getFontSource()) {
            case SYSTEM: {
                renderer.setIcon(StudioIcons.Shell.Filetree.ANDROID_PROJECT);
                break;
            }
            case PROJECT: {
                if (fontFamily.getMenu().startsWith("file://")) {
                    renderer.setIcon(StudioIcons.Shell.Filetree.FONT_FILE);
                    break;
                }
                if (fontFamily.getMenu().startsWith("https://")) {
                    renderer.setIcon(StudioIcons.Common.LINK);
                    break;
                }
                renderer.setIcon(AllIcons.General.BalloonError);
                break;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        if (value2 != null && !value2.startsWith("@font/") && !AndroidDomUtil.AVAILABLE_FAMILIES.contains(value2)) {
            value2 = "@font/" + value2;
        }
        return new ValueWithDisplayString(resolvedValue, value2);
    }

    private static class MoreFontSelector
    implements ValueWithDisplayString.ValueSelector {
        private final AndroidFacet myFacet;
        private final ResourceResolver myResolver;

        MoreFontSelector(@NotNull AndroidFacet facet, @NotNull ResourceResolver resolver) {
            this.myFacet = facet;
            this.myResolver = resolver;
        }

        @Override
        @Nullable
        public ValueWithDisplayString selectValue(@Nullable String currentValue) {
            String font;
            MoreFontsDialog dialog2 = new MoreFontsDialog(this.myFacet, currentValue);
            dialog2.show();
            String string = font = dialog2.isOK() ? dialog2.getResultingFont() : null;
            if (font == null) {
                return null;
            }
            return new ValueWithDisplayString(StringUtil.trimStart((String)font, (String)"@font/"), font);
        }
    }
}

