/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.AttributeDefinitionEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.IdAnalyzer;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdEnumSupport
extends AttributeDefinitionEnumSupport {
    private final IdAnalyzer myIdAnalyzer;

    public IdEnumSupport(@NotNull NlProperty property2) {
        this(property2, new IdAnalyzer(property2));
    }

    public IdEnumSupport(@NotNull NlProperty property2, @NotNull IdAnalyzer analyzer) {
        super(property2);
        this.myIdAnalyzer = analyzer;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        List<ValueWithDisplayString> values = this.myIdAnalyzer.findIds().stream().map(id -> new ValueWithDisplayString(this.isEnumValue((String)id) ? "@+id/" + id : id, "@+id/" + id)).collect(Collectors.toList());
        this.addAttributeDefinitionValues(values);
        return values;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        if (!(value2 == null || value2.startsWith("@+id/") || value2.startsWith("@id/") || this.isEnumValue(value2))) {
            value2 = "@+id/" + value2;
        }
        String display2 = resolvedValue;
        display2 = StringUtil.trimStart((String)display2, (String)"@id/");
        if (this.isEnumValue(display2 = StringUtil.trimStart((String)display2, (String)"@+id/"))) {
            display2 = resolvedValue;
        }
        return new ValueWithDisplayString(display2, value2, hint);
    }
}

