/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.property.NlProperty;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Quantity
implements Comparable<Quantity> {
    private static final Pattern QUANTITY_PATTERN = Pattern.compile("^(-?\\d+(\\.\\d+)?)(.*)$");
    private final int myValue;
    private final String myUnit;

    @Nullable
    public static Quantity parse(@NotNull String value2) {
        Matcher matcher = QUANTITY_PATTERN.matcher(value2);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new Quantity(Integer.parseInt(matcher.group(1)), matcher.group(3).trim());
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @NotNull
    public static String addUnit(@NotNull NlProperty property2, @NotNull String value2) {
        boolean isDimension;
        AttributeDefinition definition = property2.getDefinition();
        boolean bl = isDimension = definition != null && definition.getFormats().contains(AttributeFormat.DIMENSION);
        if (!isDimension) {
            return value2;
        }
        Quantity quantity = Quantity.parse(value2);
        if (quantity == null || !quantity.myUnit.isEmpty()) {
            return value2;
        }
        switch (property2.getName()) {
            case "textSize": 
            case "lineSpacingExtra": {
                return quantity.myValue + "sp";
            }
        }
        return quantity.myValue + "dp";
    }

    public static String addUnit(@NotNull ResourceType type, @NotNull String value2) {
        if (type != ResourceType.DIMEN) {
            return value2;
        }
        Quantity quantity = Quantity.parse(value2);
        if (quantity == null || !quantity.myUnit.isEmpty()) {
            return value2;
        }
        return quantity.myValue + "dp";
    }

    private Quantity(int value2, @NotNull String unit) {
        this.myValue = value2;
        this.myUnit = unit;
    }

    public int getValue() {
        return this.myValue;
    }

    @NotNull
    public String getUnit() {
        return this.myUnit;
    }

    @Override
    public int compareTo(@Nullable Quantity other) {
        if (other == null) {
            return -1;
        }
        return Comparator.comparing(Quantity::getUnit).thenComparing(Quantity::getValue).compare(this, other);
    }
}

