/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleValuePairEnumSupport
extends EnumSupport {
    private final Map<String, String> myPossibleValues;

    public SimpleValuePairEnumSupport(@NotNull NlProperty property2, @NotNull Map<String, String> possibleValues) {
        super(property2);
        this.myPossibleValues = possibleValues;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>(this.myPossibleValues.size());
        for (Map.Entry<String, String> valuePair : this.myPossibleValues.entrySet()) {
            values.add(new ValueWithDisplayString(valuePair.getValue(), valuePair.getKey()));
        }
        return values;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        String displayValue = this.myPossibleValues.get(resolvedValue);
        if (displayValue == null) {
            displayValue = resolvedValue;
        }
        return new ValueWithDisplayString(displayValue, value2, hint);
    }
}

