/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleEnumSupport
extends EnumSupport {
    protected final StyleFilter myStyleFilter;
    protected final ResourceNamespace myDefaultNamespace;

    public StyleEnumSupport(@NotNull NlProperty property2) {
        this(property2.getModel().getFacet(), property2);
    }

    private StyleEnumSupport(@NotNull AndroidFacet facet, @NotNull NlProperty property2) {
        this(property2, new StyleFilter(facet, property2.getResolver()), ResourceRepositoryManager.getInstance(facet).getNamespace());
    }

    @VisibleForTesting
    StyleEnumSupport(@NotNull NlProperty property2, @NotNull StyleFilter styleFilter, @NotNull ResourceNamespace defaultNamespace2) {
        super(property2);
        this.myStyleFilter = styleFilter;
        this.myDefaultNamespace = defaultNamespace2;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        String tagName = this.myProperty.getTagName();
        assert (tagName != null);
        return this.convertStylesToDisplayValues(this.myStyleFilter.getWidgetStyles(tagName));
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        String shortDisplay;
        if (value2 != null && !value2.startsWith("@") && !value2.startsWith("?")) {
            StyleResourceValue styleFound = this.resolve(this.myDefaultNamespace, value2);
            if (styleFound == null) {
                for (String namespaceUri : this.findKnownNamespaces()) {
                    StyleResourceValue resource;
                    ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                    if (namespace == null || (resource = this.resolve(namespace, value2)) == null) continue;
                    styleFound = resource;
                    break;
                }
            }
            value2 = styleFound != null ? styleFound.asReference().getRelativeResourceUrl(this.myDefaultNamespace, this.getResolver()).toString() : "@style/" + value2;
        }
        String display2 = (shortDisplay = StringUtil.substringAfter((String)resolvedValue, (String)"style/")) != null ? shortDisplay : resolvedValue;
        return new ValueWithDisplayString(display2, value2, this.generateHint(display2, value2));
    }

    @NotNull
    protected String[] findKnownNamespaces() {
        XmlTag tag = this.getTagOfFirstComponent();
        return tag != null ? tag.knownNamespaces() : new String[]{};
    }

    @NotNull
    protected ResourceNamespace.Resolver getResolver() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag tag = this.getTagOfFirstComponent();
        return tag != null ? ResourceHelper.getNamespaceResolver((XmlElement)tag) : ResourceNamespace.Resolver.EMPTY_RESOLVER;
    }

    @Nullable
    private XmlTag getTagOfFirstComponent() {
        List<NlComponent> components = this.myProperty.getComponents();
        return !components.isEmpty() ? components.get(0).getBackend().getTag() : null;
    }

    @Nullable
    protected StyleResourceValue resolve(@NotNull ResourceNamespace namespace, @NotNull String styleName) {
        ResourceResolver resolver = this.myProperty.getResolver();
        if (resolver == null) {
            return null;
        }
        return resolver.getStyle(ResourceReference.style((ResourceNamespace)namespace, (String)styleName));
    }

    @Nullable
    protected String generateHint(@NotNull String display2, @Nullable String value2) {
        if (value2 == null) {
            return "default";
        }
        if (value2.endsWith(display2)) {
            return null;
        }
        return value2;
    }

    @NotNull
    protected List<ValueWithDisplayString> convertStylesToDisplayValues(@NotNull List<StyleResourceValue> styles2) {
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        StyleResourceValue previousStyle = null;
        for (StyleResourceValue style : styles2) {
            if (!(previousStyle == null || previousStyle.getNamespace().equals((Object)style.getNamespace()) && previousStyle.isUserDefined() == style.isUserDefined())) {
                values.add(ValueWithDisplayString.SEPARATOR);
            }
            previousStyle = style;
            values.add(this.createFromResolvedValue(style.getName(), style.asReference().getRelativeResourceUrl(ResourceNamespace.TODO(), this.getResolver()).toString(), null));
        }
        return values;
    }
}

