/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleFilter {
    private final AndroidFacet myFacet;
    private final ResourceResolver myResolver;

    public StyleFilter(@NotNull AndroidFacet facet, @Nullable ResourceResolver resolver) {
        this.myFacet = facet;
        this.myResolver = resolver;
    }

    public boolean hasWidgetStyles(@NotNull String tagName) {
        return !this.getWidgetBaseStyles(tagName).isEmpty();
    }

    public List<StyleResourceValue> getWidgetStyles(@NotNull String tagName) {
        return this.findDerivedStyles(this.getWidgetBaseStyles(tagName));
    }

    @NotNull
    public List<StyleResourceValue> getStylesDerivedFrom(@NotNull StyleResourceValue baseStyle) {
        return this.findDerivedStyles(Collections.singletonList(baseStyle));
    }

    private List<StyleResourceValue> findDerivedStyles(@NotNull List<StyleResourceValue> baseStyles) {
        if (this.myResolver == null) {
            return baseStyles;
        }
        ArrayList<StyleResourceValue> bases = new ArrayList<StyleResourceValue>(baseStyles);
        HashSet<StyleResourceValue> styles2 = new HashSet<StyleResourceValue>();
        while (!bases.isEmpty()) {
            StyleResourceValue base = (StyleResourceValue)bases.remove(bases.size() - 1);
            if (styles2.contains(base)) continue;
            styles2.add(base);
            bases.addAll(this.myResolver.getChildren(base));
        }
        return styles2.stream().filter(this::filter).sorted(Comparator.comparing(ResourceValue::isUserDefined).reversed().thenComparing(ResourceValue::getNamespace).thenComparing(ResourceValue::getName)).collect(Collectors.toList());
    }

    boolean filter(@NotNull StyleResourceValue style) {
        if (style.getName().startsWith("Base.") && style.getName().contains(".AppCompat")) {
            return false;
        }
        return ResourceHelper.isAccessibleInXml((ResourceValue)style, this.myFacet);
    }

    @NotNull
    private List<StyleResourceValue> getWidgetBaseStyles(@NotNull String tagName) {
        ViewHandlerManager manager = ViewHandlerManager.get(this.myFacet.getModule().getProject());
        ViewHandler handler = manager.getHandler(tagName);
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<StyleResourceValue> styles2 = new ArrayList<StyleResourceValue>();
        List<String> possibleNames = handler.getBaseStyles(tagName);
        Map<String, String> prefixMap = handler.getPrefixToNamespaceMap();
        for (String styleName : possibleNames) {
            StyleResourceValue style = this.resolve(styleName, prefixMap);
            if (style == null) continue;
            styles2.add(style);
        }
        return styles2;
    }

    @Nullable
    private StyleResourceValue resolve(@NotNull String qualifiedStyleName, @NotNull Map<String, String> prefixMap) {
        if (this.myResolver == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parseStyleParentReference((String)qualifiedStyleName);
        if (url == null) {
            return null;
        }
        ResourceReference reference2 = url.resolve(ResourceNamespace.ANDROID, prefixMap::get);
        if (reference2 == null) {
            return null;
        }
        return this.myResolver.getStyle(reference2);
    }
}

