/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.StyleEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAppearanceEnumSupport
extends StyleEnumSupport {
    static final String TEXT_APPEARANCE = "TextAppearance";
    static final Pattern TEXT_APPEARANCE_PATTERN = Pattern.compile("^((@(\\w+:)?)style/)?TextAppearance(\\.(.+))?$");

    public TextAppearanceEnumSupport(@NotNull NlProperty property2) {
        super(property2);
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        StyleResourceValue style = this.resolve(ResourceNamespace.ANDROID, TEXT_APPEARANCE);
        if (style == null) {
            return Collections.emptyList();
        }
        return this.convertStylesToDisplayValues(this.myStyleFilter.getStylesDerivedFrom(style));
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        String display2;
        Matcher matcher;
        if (value2 != null && !value2.startsWith("@") && !value2.startsWith("?")) {
            StyleResourceValue styleFound = this.resolve(this.myDefaultNamespace, value2);
            if (styleFound == null) {
                for (String namespaceUri : this.findKnownNamespaces()) {
                    StyleResourceValue resource;
                    ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                    if (namespace == null || (resource = this.resolve(namespace, value2)) == null) continue;
                    styleFound = resource;
                    break;
                }
            }
            String string = value2 = styleFound != null ? styleFound.asReference().getRelativeResourceUrl(this.myDefaultNamespace, this.getResolver()).toString() : "@style/" + value2;
        }
        if ((matcher = TEXT_APPEARANCE_PATTERN.matcher(resolvedValue)).matches()) {
            display2 = matcher.group(5);
            if (display2 == null) {
                display2 = TEXT_APPEARANCE;
            }
        } else {
            String shortDisplay = StringUtil.substringAfter((String)resolvedValue, (String)"style/");
            display2 = shortDisplay != null ? shortDisplay : resolvedValue;
        }
        return new ValueWithDisplayString(display2, value2, this.generateHint(display2, value2));
    }

    @Override
    @Nullable
    protected StyleResourceValue resolve(@NotNull ResourceNamespace namespace, @NotNull String styleName) {
        StyleResourceValue value2 = super.resolve(namespace, styleName);
        if (value2 != null) {
            return value2;
        }
        return super.resolve(namespace, "TextAppearance." + styleName);
    }
}

